/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.Future;
import hj.lang.Object;
import hj.lang.Runtime;
import hj.runtime.wsh.ModCountDownLatch;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshRuntime_c;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;

public final class Future_c
extends Future {
    private Throwable exception_;
    private Object result_;
    private boolean completed_;
    private ModCountDownLatch cdl = new ModCountDownLatch(1);
    private long critPathOps = 0L;
    private long curIdealTime = 0L;

    public void setResult(Object result) {
        this.result_ = result;
        this.completed_ = true;
        if (this.cdl.getCount() > 0L) {
            this.cdl.countDown();
        }
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.maxCritPathOps(((AbstractMetrics)((java.lang.Object)WshRuntime_c.getCurrentActivity())).getCritPathOps());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((AbstractMetrics)((java.lang.Object)Runtime.getCurrentActivity())).updateIdealTime();
                this.maxIdealTime(((AbstractMetrics)((java.lang.Object)Runtime.getCurrentActivity())).getCritPathTime());
            }
        }
    }

    public void setException(Throwable t) {
        this.exception_ = t;
        this.completed_ = true;
        if (this.cdl.getCount() > 0L) {
            this.cdl.countDown();
        }
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            this.maxCritPathOps(((AbstractMetrics)((java.lang.Object)Runtime.getCurrentActivity())).getCritPathOps());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((AbstractMetrics)((java.lang.Object)Runtime.getCurrentActivity())).updateIdealTime();
                this.maxIdealTime(((AbstractMetrics)((java.lang.Object)Runtime.getCurrentActivity())).getCritPathTime());
            }
        }
    }

    public Object force() {
        PoolRunner t = (PoolRunner)Thread.currentThread();
        if (this.cdl.getCount() > 0L) {
            t.getPlace().threadBlockedNotification();
            try {
                this.cdl.await();
            }
            catch (InterruptedException ie) {
                System.err.println("Future_c::force - unexpected exception e" + ie);
                throw new Error(ie);
            }
            t.getPlace().threadUnblockedNotification();
        }
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            ((Activity)Runtime.getCurrentActivity()).maxCritPathOps(this.getCritPathOps());
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                ((Activity)Runtime.getCurrentActivity()).maxCritPathTime(this.getIdealTime());
                ((Activity)Runtime.getCurrentActivity()).setResumeTime();
            }
        }
        if (this.exception_ != null) {
            if (this.exception_ instanceof Error) {
                throw (Error)this.exception_;
            }
            if (this.exception_ instanceof RuntimeException) {
                throw (RuntimeException)this.exception_;
            }
            assert (false);
        }
        return this.result_;
    }

    public boolean forced() {
        return this.completed_;
    }

    public synchronized void maxCritPathOps(long n) {
        this.critPathOps = Math.max(this.critPathOps, n);
    }

    public long getCritPathOps() {
        return this.critPathOps;
    }

    public synchronized void maxIdealTime(long t) {
        this.curIdealTime = Math.max(this.curIdealTime, t);
    }

    public long getIdealTime() {
        return this.curIdealTime;
    }

    public static abstract class Activity
    extends hj.runtime.wsh.Activity {
        public Future_c future;

        public abstract Object getResult();

        public abstract void runSource();

        public void runHjTask() {
            try {
                try {
                    this.startFinish();
                    this.runSource();
                }
                catch (Throwable t) {
                    try {
                        this.pushException(t);
                        this.stopFinish();
                    }
                    catch (Throwable t1) {
                        this.future.setException(t1);
                        return;
                    }
                }
                this.stopFinish();
                this.future.setResult(this.getResult());
            }
            catch (Throwable t) {
                this.future.setException(t);
            }
        }

        public boolean isHjTaskReady() {
            return true;
        }

        public void finalizeTermination() {
            super.finalizeTermination();
        }

        public void finalizeTermination(Throwable t) {
            this.future.setException(t);
            super.finalizeTermination(t);
        }
    }
}

