/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.runtime.wsh.Activity;

public abstract class InvocationStrategy {
    public static final InvocationStrategy ASYNC = new DefaultStrategy();
    public static final InvocationStrategy ASYNC_IN_FINISH = new AsyncInFinishStrategy();

    public abstract void invokeHjTask(Activity var1);

    public static class AsyncInFinishStrategy
    extends InvocationStrategy {
        private AsyncInFinishStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeHjTask(Activity activityToInvoke) {
            activityToInvoke.startFinish();
            try {
                activityToInvoke.runHjTask();
            }
            catch (Throwable t) {
                activityToInvoke.pushException(t);
            }
            finally {
                activityToInvoke.stopFinish();
            }
        }
    }

    public static class DefaultStrategy
    extends InvocationStrategy {
        private DefaultStrategy() {
        }

        public void invokeHjTask(Activity activityToInvoke) {
            try {
                activityToInvoke.runHjTask();
            }
            catch (Throwable e) {
                activityToInvoke.finalizeTermination(e);
                return;
            }
            activityToInvoke.finalizeTermination();
        }
    }
}

