/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.lang.Future;
import hj.lang.Runtime;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Future_c;
import hj.runtime.wsh.InvocationStrategy;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.abstractmetrics.AbstractMetrics;
import hj.runtime.wsh.abstractmetrics.AbstractMetricsFactory;

public class LocalPlace_c
extends Place {
    boolean shutdown;
    private AbstractMetrics abstractMetricsManager = AbstractMetricsFactory.getAbstractMetricsManager();

    public void runAsync(Activity a) {
        this.runActivity(a);
    }

    public void runAsyncInFinish(Activity activity2) {
        activity2.setInvocationStrategy(InvocationStrategy.ASYNC_IN_FINISH);
        this.runAsync(activity2);
        try {
            activity2.join();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
    }

    private void prepareActivity(Activity childActivity) {
        childActivity.setPlace(this);
        Activity parent = (Activity)Runtime.getCurrentActivity();
        if (parent != null) {
            parent.finalizeActivitySpawn(childActivity);
        }
    }

    protected void runActivity(Activity activity2) {
        this.prepareActivity(activity2);
        this.threadPoolService.execute(activity2);
    }

    public Future runFuture(Future_c.Activity a) {
        Future_c result = a.future = new Future_c();
        this.runAsync(a);
        return result;
    }

    public String longName() {
        return this.toString() + "(shutdown=" + this.shutdown + ")";
    }

    public void customShutdown() {
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " shutting down " + this);
        }
        this.shutdown = true;
    }

    public int getNbThreadBlocked() {
        return this.nbThreadBlocked.get();
    }

    public void threadBlockedNotification() {
        this.nbThreadBlocked.addAndGet(1);
        if (this.getNbThreadBlocked() >= this.getThreadPool().getCorePoolSize()) {
            this.getThreadPool().increasePoolSize();
        }
    }

    public void threadUnblockedNotification() {
        this.nbThreadBlocked.addAndGet(-1);
        this.getThreadPool().decreasePoolSize();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void addUnblockedTime(long t) {
        this.abstractMetricsManager.addUnblockedTime(t);
    }

    public long getTotalOps() {
        return this.abstractMetricsManager.getTotalOps();
    }

    public long getCritPathOps() {
        return this.abstractMetricsManager.getCritPathOps();
    }

    public void addLocalOps(long n) {
        this.abstractMetricsManager.addLocalOps(n);
    }

    public void addCritPathOps(long n) {
        this.abstractMetricsManager.addCritPathOps(n);
    }

    public void maxCritPathOps(long n) {
        this.abstractMetricsManager.maxCritPathOps(n);
    }

    public long getTotalUnblockedTime() {
        return this.abstractMetricsManager.getTotalUnblockedTime();
    }

    public long getCritPathTime() {
        return this.abstractMetricsManager.getCritPathTime();
    }

    public void maxCritPathTime(long t) {
        this.abstractMetricsManager.maxCritPathTime(t);
    }

    public long getResumeTime() {
        return this.abstractMetricsManager.getResumeTime();
    }

    public void setResumeTime() {
        this.abstractMetricsManager.setResumeTime();
    }

    public void updateIdealTime() {
        this.abstractMetricsManager.updateIdealTime();
    }

    public long getCurrentTime() {
        return this.abstractMetricsManager.getCurrentTime();
    }
}

