/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.runtime.wsh.Activity;
import hj.runtime.wsh.ActivityRunner;
import hj.runtime.wsh.Place;

public class PoolRunner
extends Thread
implements ActivityRunner {
    private Activity activity;
    private Place place;
    private final String namePrefix;

    PoolRunner(ThreadGroup group, Runnable r, String namePrefix) {
        super(group, r, namePrefix, 0L);
        this.namePrefix = namePrefix;
    }

    public void setPlace(Place p) {
        this.place = p;
    }

    public Place getPlace() {
        return this.place;
    }

    public void setActivity(Activity a) {
        this.activity = a;
        this.setName(this.namePrefix + ": " + a.myName());
    }

    public Activity getActivity() {
        return this.activity;
    }

    private String thisThreadString() {
        return Thread.currentThread() + "@" + this.place + ":" + System.currentTimeMillis();
    }

    public static String logString() {
        return ((PoolRunner)Thread.currentThread()).thisThreadString();
    }

    public String toString() {
        return "<PoolRunner " + this.hashCode() + ">";
    }
}

