/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh;

import hj.array.ArrayFactory;
import hj.array.DistributionFactory;
import hj.array.point_c;
import hj.array.sharedmemory.DefaultArrayFactory;
import hj.array.sharedmemory.RegionFactory;
import hj.lang.Object;
import hj.lang.Runtime;
import hj.lang.accumulator;
import hj.lang.clock;
import hj.lang.dist;
import hj.lang.phaser;
import hj.lang.place;
import hj.lang.point;
import hj.lang.region;
import hj.runtime.wsh.Accumulator;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.ActivityRunner;
import hj.runtime.wsh.Clock;
import hj.runtime.wsh.LocalPlace_c;
import hj.runtime.wsh.Place;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.PreLoader;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.TwoLevelLockPlace;
import hj.runtime.wsh.VMInterface;
import hj.runtime.wsh.WshConfiguration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class WshRuntime_c
extends Runtime {
    private Place[] places_;
    private static WshRuntime_c wshRuntime;
    private static final Class[] STRING_ARRAYS;

    public WshRuntime_c() {
        wshRuntime = this;
    }

    public static Activity getCurrentWshActivity() {
        return wshRuntime.currentActivity();
    }

    private synchronized void createPlaces() {
        int pc = WshConfiguration.NUMBER_OF_LOCAL_PLACES;
        this.places_ = new Place[pc];
        place.MAX_PLACES = pc;
        for (int i = 0; i < pc; ++i) {
            this.places_[i] = new LocalPlace_c();
        }
        place.initialize();
        TwoLevelLockPlace.init(this.places_.length);
    }

    protected synchronized void initialize() {
        this.createPlaces();
    }

    protected synchronized void loadAndInitLibs() {
        if (null != WshConfiguration.LOAD) {
            String[] libs = WshConfiguration.LOAD.split(":");
            for (int i = libs.length - 1; i >= 0; --i) {
                System.loadLibrary(libs[i]);
            }
        }
    }

    public void prepareForBoot() {
        this.initialize();
        if (Report.should_report("activity", 5)) {
            Thread t = Thread.currentThread();
            int tCount = Thread.activeCount();
            Report.report(5, Thread.currentThread() + ":" + System.currentTimeMillis() + " starts in group " + t.getThreadGroup() + " with " + tCount + " threads active.");
            Thread[] a = new Thread[tCount];
            int count = Thread.enumerate(a);
            for (int i = 0; i < count; ++i) {
                Report.report(5, "Thread " + (a[i] == null ? "null" : a[i].getName()) + " is active.");
            }
        }
        this.loadAndInitLibs();
    }

    public void shutdown() {
        this.shutdownAllPlaces();
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " terminates.");
        }
        this.finalizeAndTermLibs();
        this.dumpStatistics();
    }

    private void shutdownAllPlaces() {
        for (int i = 0; i < this.places_.length; ++i) {
            this.places_[i].shutdown();
        }
    }

    protected void finalizeAndTermLibs() {
    }

    protected void run(String[] args) {
        this.prepareForBoot();
        try {
            Activity mainActivity = this.createMainActivity(args);
            this.run(mainActivity);
            if (!mainActivity.success) {
                WshRuntime_c.setExitCode(202);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            WshRuntime_c.setExitCode(201);
        }
        this.shutdown();
    }

    public void run(Activity mainActivity) {
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " starts running the Boot Activity.");
        }
        Runtime.getDefaultPlace().runAsyncInFinish(mainActivity);
        if (Report.should_report("activity", 5)) {
            Report.report(5, PoolRunner.logString() + " finished running the Boot Activity.");
        }
    }

    private Activity createMainActivity(String[] args) throws Error {
        java.lang.Object[] tmp = new java.lang.Object[]{args};
        Activity atmp = null;
        try {
            if (Report.should_report("activity", 5)) {
                Report.report(5, Thread.currentThread() + ":" + System.currentTimeMillis() + " " + this + " starting user class |" + WshConfiguration.MAIN_CLASS_NAME + "|.");
            }
            Class<?> main = Class.forName(WshConfiguration.MAIN_CLASS_NAME + "$Main");
            if (WshConfiguration.PRELOAD_CLASSES) {
                PreLoader.preLoad(main, WshConfiguration.PRELOAD_STRINGS);
            }
            atmp = (Activity)main.getDeclaredConstructor(STRING_ARRAYS).newInstance(tmp);
        }
        catch (Exception e) {
            System.err.println("Could not find default constructor of main class '" + WshConfiguration.MAIN_CLASS_NAME + "$Main" + "'!");
            throw new Error(e);
        }
        Activity appMain = atmp;
        return appMain;
    }

    public synchronized void setCurrentPlace(place p) {
        assert (p != null);
        Thread t = Thread.currentThread();
        if (t instanceof PoolRunner) {
            ((PoolRunner)t).setPlace((Place)p);
        }
    }

    public synchronized Place currentPlace() {
        if (this.getPlaces().length == 1) {
            return this.getPlaces()[0];
        }
        Thread t = Thread.currentThread();
        Place ret = null;
        if (t instanceof PoolRunner) {
            ret = ((PoolRunner)t).getPlace();
        }
        return ret;
    }

    public Activity currentActivity() {
        Thread t = Thread.currentThread();
        Activity result = null;
        if (t instanceof ActivityRunner) {
            result = ((ActivityRunner)((java.lang.Object)t)).getActivity();
        }
        return result;
    }

    protected Place[] getPlaces() {
        return this.places_;
    }

    protected Place getPlace0() {
        if (this.places_ == null) {
            throw new RuntimeException("There's no place in runtime");
        }
        return this.places_[0];
    }

    protected Place[] getLocalPlaces() {
        return this.getPlaces();
    }

    public Runtime.Factory getFactory() {
        Runtime.Factory f = new Runtime.Factory(){

            public region.factory getRegionFactory() {
                return new RegionFactory();
            }

            public dist.factory getDistributionFactory() {
                return new DistributionFactory();
            }

            public point.factory getPointFactory() {
                return new point_c.factory();
            }

            public clock.factory getClockFactory() {
                return new clock.factory(){

                    public clock clock() {
                        return new Clock();
                    }

                    public clock clock(Clock.Mode mode) {
                        return new Clock(mode);
                    }

                    public clock clock(int bound) {
                        return new Clock(bound);
                    }

                    public clock clock(Clock.Mode mode, int bound) {
                        return new Clock(mode, bound);
                    }

                    public clock clock(String name, Clock.Mode mode, int busyWaitCount, int bound) {
                        return new Clock(name, mode, busyWaitCount, bound);
                    }
                };
            }

            public accumulator.factory getAccumulatorFactory() {
                return new accumulator.factory(){

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph) {
                        return new Accumulator(ope, type, ph);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, int arrsize) {
                        return new Accumulator(ope, type, ph, arrsize);
                    }

                    public accumulator accumulator(accumulator.Operator ope, Class type, phaser ph, int func, double delay, double coef, int arrsize) {
                        return new Accumulator(ope, type, ph, func, delay, coef, arrsize);
                    }
                };
            }

            public ArrayFactory getArrayFactory() {
                return new DefaultArrayFactory();
            }

            public place.factory getPlaceFactory() {
                return new place.factory(){

                    public place place(int i) {
                        int index = i % place.MAX_PLACES;
                        return WshRuntime_c.this.places_[index];
                    }

                    public Set places(int last) {
                        TreeSet<Place> result = new TreeSet<Place>();
                        for (int i = 0; i <= last % place.MAX_PLACES; ++i) {
                            result.add(WshRuntime_c.this.places_[i]);
                        }
                        return result;
                    }

                    public place here() {
                        return WshRuntime_c.this.currentPlace();
                    }
                };
            }
        };
        return f;
    }

    private void dumpStatistics() {
        if (VMInterface.ABSTRACT_EXECUTION_STATS) {
            int i;
            int i2;
            System.err.println("\n#### START OF ABSTRACT EXECUTION STATISTICS (EXCLUDING MAIN ACTIVITY) ####");
            long sum = 0L;
            for (i2 = 0; i2 <= this.getPlaces().length - 1; ++i2) {
                sum += this.getPlaces()[i2].getThreadPool().getCompletedTaskCount();
            }
            System.err.println("  TOTAL NUMBER OF ACTIVITIES = " + sum);
            System.err.print("  TOTAL NUMBER OF ACTIVITIES PER PLACE = [ ");
            for (i2 = 0; i2 <= this.getPlaces().length - 1; ++i2) {
                System.err.print(this.getPlaces()[i2].getThreadPool().getCompletedTaskCount() + " ");
            }
            System.err.println("]");
            sum = 0L;
            for (i2 = 0; i2 <= this.getPlaces().length - 1; ++i2) {
                sum += this.getPlaces()[i2].getTotalOps();
            }
            System.err.println("\n  TOTAL NUMBER OF OPS DEFINED BY CALLS TO hj.lang.perf.addLocalOps() = " + sum);
            System.err.print("  TOTAL NUMBER OF OPS PER PLACE = [ ");
            for (i2 = 0; i2 <= this.getPlaces().length - 1; ++i2) {
                System.err.print(this.getPlaces()[i2].getTotalOps() + " ");
            }
            System.err.println("]");
            long max = 0L;
            for (i = 0; i <= this.getPlaces().length - 1; ++i) {
                max = Math.max(max, this.getPlaces()[i].getCritPathOps());
            }
            System.err.println("\n  CRITICAL PATH LENGTH OF OPS DEFINED BY CALLS TO hj.lang.perf.addLocalOps() = " + max);
            System.err.print("  CRITICAL PATH LENGTH OF OPS PER PLACE = [ ");
            for (i = 0; i <= this.getPlaces().length - 1; ++i) {
                System.err.print(this.getPlaces()[i].getCritPathOps() + " ");
            }
            System.err.println("]");
            double speedup = (double)max > 0.0 ? (double)sum / (double)max : 0.0;
            System.err.println("\n  IDEAL SPEEDUP IN NUMBER OF OPS, (TOTAL NUMBER) / (CRIT PATH LENGTH) = " + speedup);
            if (VMInterface.ABSTRACT_EXECUTION_TIMES) {
                int i3;
                int i4;
                sum = 0L;
                for (i4 = 0; i4 <= this.getPlaces().length - 1; ++i4) {
                    sum += this.getPlaces()[i4].getTotalUnblockedTime();
                }
                System.err.println("\n  TOTAL UNBLOCKED TIME FOR ALL ACTIVITIES (in milliseconds) = " + sum);
                System.err.print("  TOTAL UNBLOCKED TIME PER PLACE = [ ");
                for (i4 = 0; i4 <= this.getPlaces().length - 1; ++i4) {
                    System.err.print(this.getPlaces()[i4].getTotalUnblockedTime() + " ");
                }
                System.err.println("]");
                max = 0L;
                for (i3 = 0; i3 <= this.getPlaces().length - 1; ++i3) {
                    max = Math.max(max, this.getPlaces()[i3].getCritPathTime());
                }
                System.err.println("\n  CRITICAL PATH LENGTH OF ALL ACTIVITIES (in milliseconds) = " + max);
                System.err.print("  CRITICAL PATH LENGTH PER PLACE = [ ");
                for (i3 = 0; i3 <= this.getPlaces().length - 1; ++i3) {
                    System.err.print(this.getPlaces()[i3].getCritPathTime() + " ");
                }
                System.err.println("]");
                speedup = (double)max > 0.0 ? (double)sum / (double)max : 0.0;
                System.err.println("\n  IDEAL SPEEDUP IN EXECUTION TIME,(TOTAL TIME) / (CRIT PATH LENGTH) = " + speedup);
            }
            System.err.println("#### END OF ABSTRACT EXECUTION STATISTICS (EXCLUDING MAIN ACTIVITY) ####");
        }
    }

    public void startIsolation_() {
        TwoLevelLockPlace.atomicStarLock();
    }

    public int[] startIsolation_(List objs) {
        if (objs == null || objs.size() == 0) {
            TwoLevelLockPlace.atomicStarLock();
            return null;
        }
        int[] placeIDs = new int[objs.size()];
        for (int i = 0; i < objs.size(); ++i) {
            Object obj = (Object)objs.get(i);
            placeIDs[i] = obj instanceof place ? ((place)obj).id : obj.location.id;
        }
        TwoLevelLockPlace.atomicPLock(placeIDs);
        return placeIDs;
    }

    public int[] startIsolation_(Object[] objs) {
        if (objs == null) {
            TwoLevelLockPlace.atomicStarLock();
            return null;
        }
        int[] placeIDs = new int[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Object obj = objs[i];
            placeIDs[i] = obj instanceof place ? ((place)obj).id : obj.location.id;
        }
        TwoLevelLockPlace.atomicPLock(placeIDs);
        return placeIDs;
    }

    public int startIsolation_(Object obj) {
        int placeID = obj instanceof place ? ((place)obj).id : obj.location.id;
        TwoLevelLockPlace.atomicPLock(placeID);
        return placeID;
    }

    public void stopIsolation_() {
        TwoLevelLockPlace.atomicStarUnlock();
    }

    public int[] startIsolation_(Object obj1, Object obj2) {
        int[] placeIDs = new int[]{obj1 instanceof place ? ((place)obj1).id : obj1.location.id, obj2 instanceof place ? ((place)obj2).id : obj2.location.id};
        TwoLevelLockPlace.atomicPLock(placeIDs[0], placeIDs[1]);
        return placeIDs;
    }

    public void stopIsolation_(int placeID) {
        TwoLevelLockPlace.atomicPUnlock(placeID);
    }

    public void stopIsolation_(int[] placeIDs) {
        if (placeIDs == null) {
            TwoLevelLockPlace.atomicStarUnlock();
        } else if (placeIDs.length == 2) {
            TwoLevelLockPlace.atomicPUnlock(placeIDs[0], placeIDs[1]);
        } else {
            TwoLevelLockPlace.atomicPUnlock(placeIDs);
        }
    }

    static {
        STRING_ARRAYS = new Class[]{String[].class};
    }
}

