/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wsh.clock;

import hj.lang.Runtime;
import hj.runtime.wsh.Activity;
import hj.runtime.wsh.Clock;
import hj.runtime.wsh.PoolRunner;
import hj.runtime.wsh.Report;
import hj.runtime.wsh.clock.ClockManager;
import hj.runtime.wsh.clock.ClockRegMode;
import java.util.LinkedList;
import java.util.List;

public class ClockManagerImpl
implements ClockManager {
    protected Activity activity;
    private ClockRegMode singleClockRegMode;
    private List clockRegModeList;

    public ClockManagerImpl(Activity activity2) {
        this.activity = activity2;
    }

    public ClockManagerImpl(Activity activity2, List clockRegModes) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " adding clockRegModes " + clockRegModes + " to " + activity2);
        }
        this.clockRegModeList = clockRegModes;
    }

    public ClockManagerImpl(Activity activity2, ClockRegMode clockRegMode) {
        this(activity2);
        if (Report.should_report("activity", 3)) {
            Report.report(3, PoolRunner.logString() + " adding clockRegMode " + clockRegMode + " to " + activity2);
        }
        this.singleClockRegMode = clockRegMode;
    }

    private void switchFromSingleToListStrategy() {
        this.clockRegModeList = new LinkedList();
        this.clockRegModeList.add(this.singleClockRegMode);
        this.singleClockRegMode = null;
    }

    public List cloneClocks() {
        LinkedList<ClockRegMode> L = new LinkedList<ClockRegMode>();
        Activity current = (Activity)Runtime.getCurrentActivity();
        for (Object o : this.clockRegModeList) {
            ClockRegMode cr = current.checkClockUse((ClockRegMode)o);
            Clock c = (Clock)cr.getClock();
            ClockRegMode ccr = new ClockRegMode(c, cr.getMode());
            L.add(ccr);
        }
        return L;
    }

    public void addClock(ClockRegMode cr) {
        if (Report.should_report("clock", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this.activity + " adds " + cr + ".");
        }
        if (this.singleClockRegMode != null) {
            this.switchFromSingleToListStrategy();
        }
        this.clockRegModeList.add(cr);
    }

    public void dropClock(Clock c) {
        if (Report.should_report("clock", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this.activity + " drops " + c + ".");
        }
        if (this.singleClockRegMode != null) {
            Clock singleClock = (Clock)this.singleClockRegMode.getClock();
            if (singleClock.equals(c)) {
                this.singleClockRegMode = null;
            } else if (Report.should_report("clock", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + " dropClock attempt failed because clock to drop is not known by the activity " + c + ".");
            }
        } else {
            ClockRegMode cr = null;
            for (ClockRegMode tcr : this.clockRegModeList) {
                Clock c2 = (Clock)tcr.getClock();
                if (!c2.equals(c)) continue;
                cr = tcr;
                break;
            }
            if (cr != null) {
                this.clockRegModeList.remove(cr);
            }
        }
    }

    public void dropAllClocks() {
        if (this.singleClockRegMode != null) {
            Clock singleClock = (Clock)this.singleClockRegMode.getClock();
            singleClock.drop(this.activity);
            this.singleClockRegMode = null;
        } else {
            ClockRegMode[] arr = this.clockRegModeList.toArray(new ClockRegMode[0]);
            for (int i = 0; i < arr.length; ++i) {
                Clock c = (Clock)arr[i].getClock();
                c.drop(this.activity);
            }
            arr = null;
            this.clockRegModeList = null;
        }
        if (Report.should_report("clock", 3)) {
            Report.report(3, PoolRunner.logString() + " " + this.activity + " drops all clocks.");
        }
    }

    public void doSignal() {
        if (this.singleClockRegMode != null) {
            Clock.Mode mode;
            Clock singleClock = (Clock)this.singleClockRegMode.getClock();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".signal() on " + singleClock);
            }
            if ((mode = this.singleClockRegMode.getMode()) == Clock.Mode.SIG || (mode == Clock.Mode.SIG_WAIT || mode == Clock.Mode.SINGLE) && !singleClock.quiescent()) {
                singleClock.signal();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".signal() on " + this.clockRegModeList);
            }
            for (ClockRegMode cr : this.clockRegModeList) {
                Clock c = (Clock)cr.getClock();
                Clock.Mode mode = cr.getMode();
                if (mode != Clock.Mode.SIG && (mode != Clock.Mode.SIG_WAIT && mode != Clock.Mode.SINGLE || c.quiescent())) continue;
                c.signal();
            }
        }
    }

    public void doWait() {
        if (this.singleClockRegMode != null) {
            Clock.Mode mode;
            Clock singleClock = (Clock)this.singleClockRegMode.getClock();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doWait() on " + singleClock);
            }
            if ((mode = this.singleClockRegMode.getMode()) == Clock.Mode.WAIT || (mode == Clock.Mode.SIG_WAIT || mode == Clock.Mode.SINGLE) && singleClock.quiescent()) {
                singleClock.doWait();
            }
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doWait() on " + this.clockRegModeList);
            }
            for (ClockRegMode cr : this.clockRegModeList) {
                Clock c = (Clock)cr.getClock();
                Clock.Mode mode = cr.getMode();
                if (mode != Clock.Mode.WAIT && (mode != Clock.Mode.SIG_WAIT && mode != Clock.Mode.SINGLE || !c.quiescent())) continue;
                c.doWait();
            }
        }
    }

    public void doNext() {
        if (this.singleClockRegMode != null) {
            Clock.Mode mode;
            Clock singleClock = (Clock)this.singleClockRegMode.getClock();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext() on " + singleClock);
            }
            if ((mode = this.singleClockRegMode.getMode()) == Clock.Mode.SIG || (mode == Clock.Mode.SIG_WAIT || mode == Clock.Mode.SINGLE) && !singleClock.quiescent()) {
                singleClock.signal();
            }
            if (mode != Clock.Mode.SIG) {
                singleClock.doWait();
            }
        } else {
            Clock.Mode mode;
            Clock c;
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext() on " + this.clockRegModeList);
            }
            for (ClockRegMode cr : this.clockRegModeList) {
                c = (Clock)cr.getClock();
                mode = cr.getMode();
                if (mode != Clock.Mode.SIG && (mode != Clock.Mode.SIG_WAIT && mode != Clock.Mode.SINGLE || c.quiescent())) continue;
                c.signal();
            }
            for (ClockRegMode cr : this.clockRegModeList) {
                c = (Clock)cr.getClock();
                mode = cr.getMode();
                if (mode == Clock.Mode.SIG) continue;
                c.doWait();
            }
        }
    }

    public int doNext1(String loc) {
        int ret = 0;
        if (this.singleClockRegMode != null) {
            Clock singleClock = (Clock)this.singleClockRegMode.getClock();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext1() on " + singleClock);
            }
            if (!singleClock.quiescent()) {
                singleClock.signal();
            }
            if (singleClock.doWaitSingle1(loc)) {
                ++ret;
            }
        } else {
            Clock c;
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext1() on " + this.clockRegModeList);
            }
            for (ClockRegMode cr : this.clockRegModeList) {
                c = (Clock)cr.getClock();
                if (c.quiescent()) continue;
                c.signal();
            }
            for (ClockRegMode cr : this.clockRegModeList) {
                c = (Clock)cr.getClock();
                if (!c.doWaitSingle1(loc)) continue;
                ++ret;
            }
        }
        return ret;
    }

    public void doNext2() {
        if (this.singleClockRegMode != null) {
            Clock singleClock = (Clock)this.singleClockRegMode.getClock();
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext2() on " + singleClock);
            }
            singleClock.doWaitSingle2();
        } else {
            if (Report.should_report("activity", 3)) {
                Report.report(3, PoolRunner.logString() + " " + this.activity + ".doNext2() on " + this.clockRegModeList);
            }
            for (ClockRegMode cr : this.clockRegModeList) {
                Clock c = (Clock)cr.getClock();
                c.doWaitSingle2();
            }
        }
    }

    public void registerClocks() {
        if (this.singleClockRegMode != null) {
            Clock singleClock = (Clock)this.singleClockRegMode.getClock();
            Clock.Mode mode = this.singleClockRegMode.getMode();
            singleClock.register(this.activity, mode);
        } else {
            for (ClockRegMode cr : this.clockRegModeList) {
                Clock c = (Clock)cr.getClock();
                Clock.Mode mode = cr.getMode();
                c.register(this.activity, mode);
            }
        }
    }

    public Clock checkClockUse(Clock c) {
        assert (false);
        return null;
    }

    public int getNbRegisteredClocks() {
        if (this.singleClockRegMode != null) {
            return 1;
        }
        if (this.clockRegModeList != null) {
            return this.clockRegModeList.size();
        }
        return 0;
    }
}

