/*
 * Decompiled with CFR 0.152.
 */
package hj.runtime.wst.adaptive;

import hj.runtime.wst.adaptive.ActivationFrame;
import hj.runtime.wst.adaptive.BfAsyncFrame;
import hj.runtime.wst.adaptive.Closure;
import hj.runtime.wst.adaptive.ContinuationFrame;
import hj.runtime.wst.adaptive.DelayedAsync;
import hj.runtime.wst.adaptive.Deque;
import hj.runtime.wst.adaptive.DequeNoLeak;
import hj.runtime.wst.adaptive.FinishTreeNode;
import hj.runtime.wst.adaptive.Runtime;
import hj.runtime.wst.adaptive.WorkerAbortException;
import hj.runtime.wst.adaptive.WorkerBlockedException;
import hj.runtime.wst.adaptive.WorkerException;
import hj.runtime.wst.adaptive.WorkerExecutable;
import java.util.Random;

public class Worker
extends Thread {
    public final int id;
    public final int index;
    public int status;
    public int PROFILE_eval = 0;
    public int PROFILE_switch_to_workfirst = 0;
    public int PROFILE_switch_to_helpfirst = 0;
    public int PROFILE_stay_workfirst = 0;
    public int PROFILE_stay_helpfirst = 0;
    public static final int STATUS_READYTOGO = 0;
    public static final int STATUS_STEALING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_SUSPENDED = 3;
    public static final int STATUS_ABORT = 4;
    public static final int STATUS_TERM = 5;
    public static final int SCHED_HELPFIRST = 10;
    public static final int SCHED_WORKFIRST = 11;
    public static int SCHED_SWITCHING_DEQUE_THRESHOLD;
    private static int SCHED_POLICY_REVISIT_INTERVAL;
    private static int SCHED_STACK_DEPTH_THRESHOLD;
    private int _pgsCount = 0;
    private int _policyRevisitClock = SCHED_POLICY_REVISIT_INTERVAL;
    private int _lastDequeSize = 0;
    private int _sched_policy = 10;
    private final Deque _wfDeque;
    private final Deque _hfDeque;
    private final Closure closure;
    private int numSteals = 0;
    private int numStealAttempts = 0;

    public Worker(int id, Closure initClosure) {
        this.id = id;
        this.index = id * 16;
        this.closure = initClosure != null ? initClosure : new Closure();
        this._hfDeque = new DequeNoLeak();
        this._wfDeque = new DequeNoLeak();
        this.initializeAdaptiveParameters();
    }

    public void initializeAdaptiveParameters() {
        SCHED_SWITCHING_DEQUE_THRESHOLD = 2 * Runtime.getNumWorkers();
        SCHED_POLICY_REVISIT_INTERVAL = 50;
        SCHED_STACK_DEPTH_THRESHOLD = 100;
    }

    public void run() {
        Random rand = new Random(System.currentTimeMillis() + (long)this.id);
        WorkerExecutable work = null;
        if (this.closure.getFinishScope() != null) {
            work = new ContinuationFrame(this.closure);
        }
        int victimId = this.id;
        int numWorkers = Runtime.getNumWorkers();
        Worker victim = null;
        while (!Runtime.done) {
            if (work == null) {
                this.status = 1;
                this.set_sched_policy(10);
            }
            victimId = (int)(rand.nextDouble() * (double)numWorkers);
            int count = 0;
            while (work == null && !Runtime.done) {
                ++count;
                do {
                    if ((victimId = (victimId + 1) % numWorkers) == this.id) continue;
                    victim = Runtime.getWorker(victimId);
                } while (victim == null);
                work = victim.steal(this);
                if (work != null) continue;
            }
            if (Runtime.done) break;
            if ((work = this.startWork(work)) != null) continue;
            this.set_sched_policy(10);
            this._lastDequeSize = 0;
            this._pgsCount = 0;
            this._policyRevisitClock = SCHED_POLICY_REVISIT_INTERVAL;
        }
    }

    private WorkerExecutable evaluateAllDelayedAsyncs() {
        for (FinishTreeNode finish : FinishTreeNode.FinishWithDelayedAsyncs) {
            DelayedAsync work;
            if (finish == null || (work = finish.evaluateDelayedAsyncs(this)) == null) continue;
            return work;
        }
        return null;
    }

    private WorkerExecutable startWork(WorkerExecutable executable) {
        this.status = 2;
        this.closure.initializeFromExecutable(executable);
        try {
            this.closure.stackDepth = 0;
            if (executable instanceof ContinuationFrame && ((ContinuationFrame)executable).head == null) {
                System.out.println("head is null");
            }
            executable.execute(this);
            this.status = 5;
            WorkerExecutable work = this.taskTerminating();
            if (work != null) {
                return work;
            }
        }
        catch (WorkerBlockedException e) {
            this.status = 3;
            if (e.work != null) {
                return e.work;
            }
        }
        catch (WorkerAbortException e) {
            this.status = 4;
            WorkerExecutable work = this.taskTerminating();
            if (work != null) {
                return work;
            }
            assert (this._wfDeque.size() == 0 && this._hfDeque.size() == 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Runtime.done = true;
            return null;
        }
        return this.findProvablyGoodSteal();
    }

    public void pushBfAsync(BfAsyncFrame frame) {
        FinishTreeNode finish = frame.getFinishScope();
        finish.incLocalCounter(this);
        this._hfDeque.pushBottom(frame);
        finish.fast = false;
        if (this._policyRevisitClock-- == 0) {
            this.evaluateSchedulePolicy();
        }
    }

    public void pushContinuation() {
        FinishTreeNode finish = this.getCurrentFinishScope();
        assert (this.closure.head != null) : this + " head is null";
        ContinuationFrame frame = new ContinuationFrame(this.closure);
        this._wfDeque.pushBottom(frame);
        finish.incLocalCounter(this);
        this.closure.head = null;
        if (this._policyRevisitClock-- == 0) {
            this.evaluateSchedulePolicy();
        }
    }

    public void popAndAbortOnSteal() throws WorkerAbortException {
        Object o = this._wfDeque.popBottom();
        if (o == Deque.Empty) {
            throw new WorkerAbortException();
        }
        ContinuationFrame f = (ContinuationFrame)o;
        f.getFinishScope().decLocalCounter(this);
        this.closure.head = ((ContinuationFrame)o).head;
        ++this._pgsCount;
    }

    private void evaluateSchedulePolicy() {
        int size = this._hfDeque.size() + this._wfDeque.size();
        ++this.PROFILE_eval;
        if (this.closure.stackDepth < SCHED_STACK_DEPTH_THRESHOLD && (size > SCHED_SWITCHING_DEQUE_THRESHOLD || size + this._pgsCount > this._lastDequeSize)) {
            if (this.sched_policy() == 10) {
                ++this.PROFILE_switch_to_workfirst;
            } else {
                ++this.PROFILE_stay_workfirst;
            }
            this.set_sched_policy(11);
        } else {
            if (this.sched_policy() == 11) {
                ++this.PROFILE_switch_to_helpfirst;
            } else {
                ++this.PROFILE_stay_helpfirst;
            }
            this.set_sched_policy(10);
        }
        this._policyRevisitClock = SCHED_POLICY_REVISIT_INTERVAL;
        this._lastDequeSize = size;
        this._pgsCount = 0;
    }

    private WorkerExecutable steal(Worker thief) {
        ++this.numStealAttempts;
        Object o = this._hfDeque.steal();
        if (!(o != Deque.Empty && o != Deque.Abort || (o = this._wfDeque.steal()) != Deque.Empty && o != Deque.Abort)) {
            return null;
        }
        WorkerExecutable w = (WorkerExecutable)o;
        FinishTreeNode finish = w.getFinishScope();
        finish.checkIn(thief);
        finish.incStealCounter(this);
        ++this.numSteals;
        return w;
    }

    private WorkerExecutable getMoreLocalWork(FinishTreeNode finish) {
        WorkerExecutable f;
        Object o = this._wfDeque.popBottom();
        if (o != Deque.Empty) {
            f = (ContinuationFrame)o;
            if (((ContinuationFrame)f).getFinishScope() != finish) {
                this._wfDeque.pushBottom(o);
            } else {
                ++this._pgsCount;
                finish.decLocalCounter(this);
                return f;
            }
        }
        if ((o = this._hfDeque.popBottom()) != Deque.Empty) {
            f = (BfAsyncFrame)o;
            if (((BfAsyncFrame)f).getFinishScope() != finish) {
                this._hfDeque.pushBottom(o);
            } else {
                ++this._pgsCount;
                finish.decLocalCounter(this);
                return f;
            }
        }
        return null;
    }

    private WorkerExecutable findProvablyGoodSteal() {
        WorkerExecutable f;
        Object o = this._hfDeque.popBottom();
        if (o == Deque.Empty) {
            o = this._wfDeque.popBottom();
            if (o == Deque.Empty) {
                return null;
            }
            f = (ContinuationFrame)o;
        } else {
            f = (BfAsyncFrame)o;
        }
        FinishTreeNode finish = f.getFinishScope();
        finish.checkIn(this);
        finish.decLocalCounter(this);
        ++this._pgsCount;
        return f;
    }

    private WorkerExecutable taskTerminating() {
        FinishTreeNode finish = this.closure.getFinishScope();
        WorkerExecutable f = this.getMoreLocalWork(finish);
        if (f != null) {
            return f;
        }
        if (finish.checkOut(this) == 0 && finish.verifyComplete()) {
            f = finish.evaluateDelayedAsyncs(this);
            if (f != null) {
                return f;
            }
            if (finish.completeForContinuation()) {
                if (finish.suspendedContinuation == null) {
                    Runtime.done = true;
                }
                return finish.suspendedContinuation;
            }
        }
        return null;
    }

    public void startFinish() {
        Closure c = this.closure;
        c.setFinishScope(new FinishTreeNode(c.getFinishScope(), this));
    }

    public void stopFinish() throws WorkerBlockedException {
        FinishTreeNode finish = this.getCurrentFinishScope();
        if (finish.fast) {
            this.stopFinishFast();
        } else {
            this.stopFinishSlow();
        }
    }

    public void stopFinishFast() {
        this.closure.setFinishScope(this.closure.getFinishScope().parent);
    }

    public boolean stopFinishSlow() throws WorkerBlockedException {
        Closure c = this.closure;
        FinishTreeNode finish = c.getFinishScope();
        c.setFinishScope(finish.parent);
        assert (c.head != null) : "closure.head is null";
        finish.suspendedContinuation = new ContinuationFrame(c);
        WorkerExecutable f = this.getMoreLocalWork(finish);
        if (f == null && finish.checkOut(this) == 0) {
            f = finish.evaluateDelayedAsyncs(this);
            if (f != null) {
                throw new WorkerBlockedException(f);
            }
            if (finish.verifyComplete() && finish.completeForContinuation()) {
                if (finish == FinishTreeNode.mainFinishScope) {
                    Runtime.done = true;
                }
                return true;
            }
        }
        this.status = 3;
        throw new WorkerBlockedException(f);
    }

    public void set_sched_policy(int _sched_policy) {
        this._sched_policy = _sched_policy;
    }

    public int sched_policy() {
        return this._sched_policy;
    }

    public int getNumSteals() {
        return this.numSteals;
    }

    public int getNumStealAttempts() {
        return this.numStealAttempts;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public FinishTreeNode getCurrentFinishScope() {
        return this.closure.getFinishScope();
    }

    public String toString() {
        return "Worker " + this.id;
    }

    public void startTimer() {
        Runtime.startTimer();
    }

    public void stopTimer() {
        Runtime.stopTimer();
    }

    public void beginMethod(ActivationFrame af) {
        ++this.closure.stackDepth;
        af.next = this.closure.head;
        this.closure.head = af;
    }

    public void endMethodFast() {
        --this.closure.stackDepth;
        this.closure.head = this.closure.head.next;
    }

    public void endMethodSlow() throws WorkerException {
        assert (this.closure.head != null) : this + "'s head is null";
        this.closure.head = this.closure.head.next;
        if (this.closure.head != null) {
            ++this.closure.stackDepth;
            this.closure.head.execute(this);
            --this.closure.stackDepth;
        }
        --this.closure.stackDepth;
    }

    public void endMethodSlow(Object retObject) throws WorkerException {
        this.closure.head = this.closure.head.next;
        if (this.closure.head != null) {
            if (retObject != null) {
                this.closure.head.setReturnResult(retObject);
            }
            this.closure.head.execute(this);
        } else assert (retObject == null);
    }

    public void pushDelayedAsync(DelayedAsync frame) {
        if (frame.isReady()) {
            this.pushBfAsync(frame);
        } else {
            FinishTreeNode finish = frame.getFinishScope();
            finish.addDelayedAsync(frame);
        }
    }

    public void printProfilingStats() {
        System.out.println(this + " adaptive switching statistics:");
        System.out.println(this + " PROFILE_eval = " + this.PROFILE_eval);
        System.out.println(this + " PROFILE_switch_to_work_first = " + this.PROFILE_switch_to_workfirst);
        System.out.println(this + " PROFILE_switch_to_help_first = " + this.PROFILE_switch_to_helpfirst);
        System.out.println(this + " PROFILE_stay_work_first = " + this.PROFILE_stay_workfirst);
        System.out.println(this + " PROFILE_stay_help_first = " + this.PROFILE_stay_helpfirst);
    }
}

