/*
 * Decompiled with CFR 0.152.
 */
package CnCParser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class Option {
    String fileName = "input";
    boolean dumpTokens = false;
    boolean dumpKeywords = false;
    boolean print = false;
    char[] inputChars;

    public Option(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '-') {
                if (stringArray[i].equals("-d")) {
                    this.dumpTokens = true;
                    continue;
                }
                if (stringArray[i].equals("-k")) {
                    this.dumpKeywords = true;
                    continue;
                }
                if (stringArray[i].equals("-p")) {
                    this.print = true;
                    continue;
                }
                System.err.println("Unknown option: " + stringArray[i]);
                this.Usage();
                System.exit(1);
                continue;
            }
            this.fileName = stringArray[i];
            break;
        }
    }

    public void Usage() {
        System.err.println("Usage:");
        System.err.println("CnCc [options] filename");
        System.err.println("Options:");
        System.err.println("-d: dump parsed tokens");
        System.err.println("-k: dump keywords");
        System.err.println("-p: print the AST");
        System.err.println("filename: the source file containing the CnC code");
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean dumpTokens() {
        return this.dumpTokens;
    }

    public boolean dumpKeywords() {
        return this.dumpKeywords;
    }

    public boolean printTokens() {
        return this.print;
    }

    public char[] getInputChars() {
        return this.inputChars;
    }

    public int readInputChars() throws IOException {
        int n = 0;
        try {
            File file = new File(this.fileName);
            int n2 = (int)file.length();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            this.inputChars = new char[n2];
            n = bufferedReader.read(this.inputChars, 0, n2);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            throw iOException;
        }
        return n;
    }
}

