/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Binary;
import polyglot.ast.Call;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.Async;
import polyglot.ext.hj.ast.Clocked;
import polyglot.ext.hj.ast.HjField_c;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.RemoteActivityInvocation;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Async_c
extends Stmt_c
implements Async,
CompoundStmt {
    public Expr place;
    public Stmt body;
    protected List clocks;
    public Expr condExpr;
    private static final Collection TOPICS = CollectionUtil.list((Object)"types", (Object)"context");

    public Async_c(Position pos, Expr place, List clocks, Stmt body) {
        super(pos);
        this.place = place;
        this.clocks = clocks;
        this.body = body;
    }

    public Async_c(Position pos, Expr place, List clocks, Expr condExpr, Stmt body) {
        super(pos);
        this.place = place;
        this.clocks = clocks;
        this.condExpr = condExpr;
        this.body = body;
    }

    public Async_c(Position p) {
        super(p);
    }

    public Stmt body() {
        return this.body;
    }

    public List clocks() {
        return this.clocks;
    }

    public Clocked clocks(List clocks) {
        Async_c n = (Async_c)this.copy();
        n.clocks = clocks;
        return n;
    }

    public Async body(Stmt body) {
        Async_c n = (Async_c)this.copy();
        n.body = body;
        return n;
    }

    public Expr cond() {
        return this.condExpr;
    }

    public Expr place() {
        return this.place;
    }

    public RemoteActivityInvocation place(Expr place) {
        if (place != this.place) {
            Async_c n = (Async_c)this.copy();
            n.place = place;
            return n;
        }
        return this;
    }

    protected Async reconstruct(Expr place, List clocks, Stmt body) {
        if (place != this.place || body != this.body || clocks != this.clocks) {
            Async_c n = (Async_c)this.copy();
            n.place = place;
            n.clocks = clocks;
            n.body = body;
            return n;
        }
        return this;
    }

    protected Async reconstruct(Expr place, List clocks, Stmt body, Expr condExpr) {
        if (place != this.place || body != this.body || clocks != this.clocks || condExpr != condExpr) {
            Async_c n = (Async_c)this.copy();
            n.place = place;
            n.clocks = clocks;
            n.body = body;
            n.condExpr = condExpr;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr place = (Expr)this.visitChild((Node)this.place, v);
        List clocks = this.visitList(this.clocks, v);
        Expr condExpr = (Expr)this.visitChild((Node)this.condExpr, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(place, clocks, body, condExpr);
    }

    public Context enterScope(Context c) {
        if (Report.should_report((Collection)TOPICS, (int)5)) {
            Report.report((int)5, (String)"enter async scope");
        }
        HjTypeSystem ts = (HjTypeSystem)c.typeSystem();
        c = ((HjContext)c).pushAsync(ts.asyncCodeInstance(c.inStaticContext()));
        return c;
    }

    public Context enterChildScope(Node child, Context c) {
        if (child != this.body) {
            c = c.pop();
        }
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjContext c;
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
        if (this.condExpr != null) {
            if (this.condExpr instanceof Binary) {
                Binary.Operator op = ((Binary)this.condExpr).operator();
                if (op != Binary.GE && op != Binary.LE && op != Binary.GT && op != Binary.LT && op != Binary.EQ && op != Binary.NE && op != Binary.COND_AND && op != Binary.COND_OR) {
                    throw new SemanticException("Delay async condition should be boolean type: " + this.condExpr + " -->" + this.condExpr.getClass().getName());
                }
            } else if (!(this.condExpr instanceof Call) && !(this.condExpr instanceof HjField_c)) {
                throw new SemanticException("Delay async condition should be boolean type: " + this.condExpr + " -->" + this.condExpr.getClass().getName());
            }
        }
        Type placeType = this.place.type();
        Expr newPlace = this.place;
        boolean placeIsPlace = ts.isImplicitCastValid(placeType, (Type)ts.place());
        if (!placeIsPlace) {
            newPlace = (Expr)nf.Field(this.position(), (Receiver)this.place, nf.Id(this.position(), "location")).del().typeCheck(tc);
        }
        if ((c = (HjContext)tc.context()).inSequentialCode()) {
            throw new SemanticException("async may not be invoked in sequential code.", this.position());
        }
        if (this.clocks() == null) return (Node)this.place(newPlace);
        boolean odd = true;
        Iterator i = this.clocks().iterator();
        while (i.hasNext()) {
            Expr tn = (Expr)i.next();
            Type t = tn.type();
            if (odd) {
                if (!(tn instanceof IntLit)) throw new SemanticException("Type \"" + t + "\" in phaser list must be an int literal.", tn.position());
                long v = ((IntLit)tn).value();
                if (v <= 0L || v > 4L) {
                    throw new SemanticException("Integer value in phaser list must be in range 1 ... 4.", tn.position());
                }
            } else if (!t.isSubtype((Type)ts.clock())) {
                throw new SemanticException("Type \"" + t + "\" in phaser list must be hj.lang.clock.", tn.position());
            }
            if ((odd = !odd) || i.hasNext()) continue;
            throw new SemanticException("Phaser list must end with hj.lang.clock.", tn.position());
        }
        return (Node)this.place(newPlace);
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.place) {
            return ts.Object();
        }
        return child.type();
    }

    public String toString() {
        return "async (" + this.place + ") { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("async (");
        this.printBlock((Node)this.place, w, tr);
        w.write(") ");
        if (this.clocks != null && !this.clocks.isEmpty()) {
            w.write("clocked (");
            w.begin(0);
            Iterator i = this.clocks.iterator();
            while (i.hasNext()) {
                Formal f = (Formal)i.next();
                this.print((Node)f, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.end();
            w.write(")");
        }
        this.printSubStmt(this.body, w, tr);
    }

    public Term entry() {
        return this.place != null ? this.place.entry() : this;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.place, FlowGraph.EDGE_KEY_TRUE, this.body.entry(), FlowGraph.EDGE_KEY_FALSE, (Term)this);
        if (this.condExpr != null) {
            v.visitCFG((Term)this.condExpr, this.body.entry());
        }
        if (this.clocks() == null) {
            v.visitCFG((Term)this.body, (Term)this);
        } else {
            v.visitCFGList(this.clocks, this.body.entry());
            v.visitCFG((Term)this.body, (Term)this);
        }
        return succs;
    }
}

