/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.Closure;
import polyglot.ext.hj.ast.ClosureCall;
import polyglot.ext.hj.types.ClosureInstance;
import polyglot.ext.hj.types.ClosureType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ClosureCall_c
extends Expr_c
implements ClosureCall {
    protected Expr target;
    protected List arguments;
    protected ClosureInstance ci;

    public ClosureCall_c(Position pos, Expr target, List arguments) {
        super(pos);
        assert (target != null && arguments != null);
        this.target = target;
        this.arguments = TypedList.copyAndCheck((List)arguments, Expr.class, (boolean)true);
    }

    public Term entry() {
        if (!(this.target instanceof Closure)) {
            return this.target.entry();
        }
        return ClosureCall_c.listEntry((List)this.arguments, (Term)this);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (!(this.target instanceof Closure)) {
            Expr t = this.target;
            v.visitCFG((Term)t, ClosureCall_c.listEntry((List)this.arguments, (Term)this));
        }
        v.visitCFGList(this.arguments, (Term)this);
        return succs;
    }

    public Expr target() {
        return this.target;
    }

    public ClosureCall target(Expr target) {
        ClosureCall_c n = (ClosureCall_c)this.copy();
        n.target = target;
        return n;
    }

    public ClosureInstance closureInstance() {
        return this.ci;
    }

    public ClosureCall closureInstance(ClosureInstance ci) {
        if (ci == this.ci) {
            return this;
        }
        ClosureCall_c n = (ClosureCall_c)this.copy();
        n.ci = ci;
        return n;
    }

    public ProcedureInstance procedureInstance() {
        return this.ci;
    }

    public List arguments() {
        return this.arguments;
    }

    public ProcedureCall arguments(List arguments) {
        ClosureCall_c n = (ClosureCall_c)this.copy();
        n.arguments = TypedList.copyAndCheck((List)arguments, Expr.class, (boolean)true);
        return n;
    }

    protected ClosureCall_c reconstruct(Expr target, List arguments) {
        if (target != this.target || !CollectionUtil.equals((Collection)arguments, (Collection)this.arguments)) {
            ClosureCall_c n = (ClosureCall_c)this.copy();
            n.target = target;
            n.arguments = TypedList.copyAndCheck((List)arguments, Expr.class, (boolean)true);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr target = (Expr)this.visitChild((Node)this.target, v);
        List arguments = this.visitList(this.arguments, v);
        return this.reconstruct(target, arguments);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        ClosureCall_c n = (ClosureCall_c)super.buildTypes(tb);
        HjTypeSystem hjts = (HjTypeSystem)tb.typeSystem();
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(this.arguments.size());
        for (int i = 0; i < this.arguments.size(); ++i) {
            l.add(hjts.unknownType(this.position()));
        }
        ClosureInstance ci = hjts.closureInstance(this.position(), hjts.Object(), null, (Type)hjts.unknownType(this.position()), l, Collections.EMPTY_LIST);
        return n.closureInstance(ci);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Type targetType = this.target.type();
        if (!(targetType instanceof ClosureType)) {
            throw new SemanticException("The target of a closure call must be a closure, not " + targetType + ".", this.target.position());
        }
        ClosureType closureType = (ClosureType)targetType;
        List<Type> formalArgTypes = closureType.argumentTypes();
        if (this.arguments.size() != formalArgTypes.size()) {
            throw new SemanticException("Closure call has wrong # of arguments (" + this.arguments.size() + ", should be " + formalArgTypes.size() + ").", this.position());
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            Expr actualArg = (Expr)this.arguments.get(i);
            Type formalArgType = formalArgTypes.get(i);
            Type actualArgType = actualArg.type();
            if (actualArgType.isImplicitCastValid(formalArgType)) continue;
            throw new SemanticException("Closure call argument must be " + formalArgType + ", not " + actualArgType + ".", actualArg.position());
        }
        Type returnType = closureType.returnType();
        return this.type(returnType);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.target).append("(");
        Iterator iter = this.arguments.iterator();
        while (iter.hasNext()) {
            Expr arg = (Expr)iter.next();
            buff.append(arg);
            if (!iter.hasNext()) continue;
            buff.append(", ");
        }
        buff.append(")");
        return buff.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        this.printSubExpr(this.target, w, tr);
        w.write("(");
        if (this.arguments.size() > 0) {
            w.allowBreak(2, 2, "", 0);
            w.begin(0);
            Iterator i = this.arguments.iterator();
            while (i.hasNext()) {
                Expr e = (Expr)i.next();
                this.print((Node)e, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.end();
        }
        w.write(")");
        w.end();
    }
}

