/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.ComplexAccessor;
import polyglot.ext.hj.ast.ComplexOperation;
import polyglot.ext.hj.types.HjComplexType;
import polyglot.ext.hj.types.HjType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class ComplexAccessor_c
extends Expr_c
implements ComplexAccessor {
    private ComplexOperation.Kind kind;
    private Expr receiver;

    public ComplexAccessor_c(Position pos, ComplexOperation.Kind kind, Expr receiver) {
        super(pos);
        this.kind = kind;
        this.receiver = receiver;
    }

    public ComplexOperation.Kind getKind() {
        return this.kind;
    }

    public Expr getReceiver() {
        return this.receiver;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.receiver, (Term)this);
        return succs;
    }

    public Term entry() {
        LinkedList<Expr> l = new LinkedList<Expr>();
        l.add(this.receiver);
        return ComplexAccessor_c.listEntry(l, (Term)this);
    }

    public Node visitChildren(NodeVisitor v) {
        Expr vreceiver = (Expr)this.visitChild((Node)this.receiver, v);
        return this.reconstruct(vreceiver);
    }

    protected ComplexAccessor_c reconstruct(Expr vreceiver) {
        if (vreceiver != this.receiver) {
            ComplexAccessor_c ca = (ComplexAccessor_c)this.copy();
            ca.receiver = vreceiver;
            ca.kind = this.kind;
            return ca;
        }
        return this;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjType receiverType = (HjType)this.receiver.type();
        if (receiverType.isComplex32() || receiverType.isComplex64()) {
            return this.type((Type)((HjComplexType)receiverType).base());
        }
        throw new SemanticException("Complex accessor may only be applied to a complex");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write(this.kind.toString());
        w.write("(");
        this.receiver.prettyPrint(w, tr);
        w.write(")");
    }
}

