/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ast.Unary;
import polyglot.ast.Unary_c;
import polyglot.ast.Variable;
import polyglot.ext.hj.ast.HjArrayAccess1;
import polyglot.ext.hj.ast.HjArrayAccess1Unary;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class HjArrayAccess1Unary_c
extends Unary_c
implements HjArrayAccess1Unary {
    public HjArrayAccess1Unary_c(Position pos, Unary.Operator op, Expr expr) {
        super(pos, op, expr);
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    public Unary expr(Expr expr) {
        HjArrayAccess1Unary_c n = (HjArrayAccess1Unary_c)super.expr(expr);
        n.assertExprType();
        return n;
    }

    private void assertExprType() {
        if (!(this.expr() instanceof HjArrayAccess1)) {
            throw new InternalCompilerError("expression of an HjArrayAccess1Unary must be an Hj array access");
        }
    }

    public String opString(Unary.Operator op) {
        if (op == PRE_INC) {
            return "preInc";
        }
        if (op == POST_INC) {
            return "postInc";
        }
        if (op == PRE_DEC) {
            return "preDec";
        }
        if (op == POST_DEC) {
            return "postDec";
        }
        throw new InternalCompilerError("Unknown unary operator");
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        if (!this.expr.type().isNumeric()) {
            throw new SemanticException("Operand of " + this.op + " operator must be numeric.", this.expr.position());
        }
        if (!(this.expr instanceof Variable)) {
            throw new SemanticException("Operand of " + this.op + " operator must be a variable.", this.expr.position());
        }
        if (((Variable)this.expr).flags().isFinal()) {
            throw new SemanticException("Operand of " + this.op + " operator must be a non-final variable.", this.expr.position());
        }
        return this.type(this.expr.type());
    }

    public Term entry() {
        return this.expr().entry();
    }

    public List throwTypes(TypeSystem ts) {
        ArrayList<ClassType> l = new ArrayList<ClassType>(super.throwTypes(ts));
        l.add(ts.NullPointerException());
        return l;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        super.prettyPrint(w, tr);
    }
}

