/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Cast_c;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjCast;
import polyglot.ext.hj.ast.HjCastInfo;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.TypeChecker;

public class HjCast_c
extends Cast_c
implements HjCast,
HjCastInfo {
    protected boolean primitiveType = false;
    protected boolean notNullRequired = false;
    protected boolean toTypeNullable = false;

    public HjCast_c(Position pos, TypeNode castType, Expr expr) {
        super(pos, castType, expr);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Type toType = this.castType.type();
        Type fromType = this.expr.type();
        HjType hjToType = (HjType)toType;
        HjType hjFromType = (HjType)fromType;
        TypeSystem ts = tc.typeSystem();
        HjTypeSystem xts = (HjTypeSystem)hjToType.typeSystem();
        this.primitiveType = false;
        this.toTypeNullable = false;
        this.notNullRequired = false;
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)5, (String)("[Cast_c] |" + this + "|.typeCheck(...):"));
            Report.report((int)5, (String)("[Cast_c] ...type=|" + this.type + "|."));
        }
        Expr result = this.type(toType);
        if (Report.should_report((String)"debug", (int)5)) {
            Report.report((int)5, (String)("[Cast_c] ...returning=|" + result + "| of type=|" + result.type() + "|."));
        }
        if (!ts.isCastValid(fromType, toType)) {
            throw new SemanticException("Cannot cast the expression of type \"" + fromType + "\" to type \"" + toType + "\".", this.position());
        }
        this.primitiveType = toType.isPrimitive();
        if (this.primitiveType) {
            this.primitiveType = true;
        }
        if (xts.isNullable(hjToType)) {
            this.toTypeNullable = true;
            this.notNullRequired = false;
            this.primitiveType = false;
        } else {
            this.toTypeNullable = false;
            if (xts.isNullable(hjFromType)) {
                this.notNullRequired = true;
            }
        }
        return this.type(toType);
    }

    public boolean isDepTypeCheckingNeeded() {
        return false;
    }

    public boolean notNullRequired() {
        return this.notNullRequired;
    }

    public boolean isPrimitiveCast() {
        return this.primitiveType;
    }

    public boolean isToTypeNullable() {
        return this.toTypeNullable;
    }

    public TypeNode getTypeNode() {
        return (TypeNode)this.castType().copy();
    }

    public void setToTypeNullable(boolean b) {
        this.toTypeNullable = b;
    }

    public void setPrimitiveCast(boolean b) {
        this.primitiveType = b;
    }

    public void setNotNullRequired(boolean b) {
        this.notNullRequired = b;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.expr) {
            if (this.castType.type().isReference()) {
                return ts.Object();
            }
            if (((HjType)this.castType.type()).isComplex32()) {
                return ((HjTypeSystem)ts).Complex32();
            }
            if (((HjType)this.castType.type()).isComplex64()) {
                return ((HjTypeSystem)ts).Complex64();
            }
            if (this.castType.type().isNumeric()) {
                return this.castType.type();
            }
            if (this.castType.type().isBoolean()) {
                return ts.Boolean();
            }
        }
        return child.type();
    }
}

