/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Conditional_c;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.TypeChecker;

public class HjConditional_c
extends Conditional_c {
    public HjConditional_c(Position pos, Expr cond, Expr consequent, Expr alternative) {
        super(pos, cond, consequent, alternative);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        Expr e1 = this.consequent;
        Expr e2 = this.alternative;
        HjType t1 = (HjType)e1.type();
        HjType t2 = (HjType)e2.type();
        if (!ts.typeEquals(this.cond.type(), (Type)ts.Boolean())) {
            throw new SemanticException("Condition of ternary expression must be of type boolean.", this.cond.position());
        }
        if (ts.typeEquals(t1, t2)) {
            return this.type(t1);
        }
        if (ts.typeBaseEquals(t1, t2)) {
            return this.type(t1.rootType());
        }
        if (t1.isNumeric() && t2.isNumeric()) {
            if (t1.isByte() && t2.isShort() || t1.isShort() && t2.isByte()) {
                return this.type((Type)ts.Short());
            }
            if (t1.isIntOrLess() && t2.isInt() && ts.numericConversionValid(t1, e2.constantValue())) {
                return this.type(t1);
            }
            if (t2.isIntOrLess() && t1.isInt() && ts.numericConversionValid(t2, e1.constantValue())) {
                return this.type(t2);
            }
            return this.type((Type)ts.promote(t1, t2));
        }
        if (t1.isNull() && t2.isReference()) {
            return this.type(t2);
        }
        if (t2.isNull() && t1.isReference()) {
            return this.type(t1);
        }
        if (t1.isReference() && t2.isReference()) {
            if (ts.isImplicitCastValid(t1, t2)) {
                return this.type(t2);
            }
            if (ts.isImplicitCastValid(t2, t1)) {
                return this.type(t1);
            }
        }
        throw new SemanticException("Could not determine type of ternary conditional expression; cannot assign " + t1 + " to " + t2 + " or vice versa.", this.position());
    }
}

