/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Expr;
import polyglot.ast.Field_c;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.HjSpecial;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjFieldInstance;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.NullableType;
import polyglot.ext.hj.types.constr.C_Field_c;
import polyglot.ext.hj.types.constr.C_Special;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.visit.TypeElaborator;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.NoMemberException;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.TypeChecker;

public class HjField_c
extends Field_c {
    public HjField_c(Position pos, Receiver target, Id name) {
        super(pos, target, name);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory xnf = (HjNodeFactory)tc.nodeFactory();
        Type tType = this.target.type();
        try {
            HjType type;
            Context c = tc.context();
            TypeSystem ts = tc.typeSystem();
            if (!tType.isReference()) {
                throw new NoMemberException(3, "Field \"" + this.name + "\" not found in type \"" + tType + "\".");
            }
            FieldInstance fi = ts.findField(tType.toReference(), this.name.id(), c.currentClass());
            if (fi == null) {
                throw new InternalCompilerError("Cannot access field " + this.name + " on node of type " + this.target.getClass().getName() + ".", this.position());
            }
            boolean inTypeElaboration = tc instanceof TypeElaborator;
            HjField_c result = this;
            HjType retType = type = (HjType)fi.type();
            if (!inTypeElaboration) {
                HjType thisType = (HjType)tType;
                Constraint rc = type.realClause();
                if (rc != null) {
                    C_Var var = thisType.selfVar();
                    if (var == null) {
                        var = rc.genEQV(thisType, true);
                    }
                    Constraint newRC = rc.substitute(var, C_Special.This);
                    retType = type.makeVariant(newRC, null);
                    fi = fi.type((Type)retType);
                }
            }
            result = (HjField_c)this.fieldInstance(fi).type((Type)retType);
            result.checkConsistency(c);
            if (!result.isTypeChecked()) {
                return result;
            }
            if (!inTypeElaboration) {
                this.checkFieldAccessesInDepClausesAreFinal(result, tc);
            }
            result = this.checkArrayFields(result);
            return result;
        }
        catch (NoMemberException e) {
            if (e.getKind() != 3 || this.target == null) {
                throw e;
            }
            if (xts.isHjArray(tType)) {
                if (this.name().equals("distribution") || this.name().equals("region")) {
                    ClassType array = xts.array();
                    CanonicalTypeNode typenode = xnf.CanonicalTypeNode(this.position(), (Type)array);
                    return this.target((Receiver)xnf.Cast(this.position(), (TypeNode)typenode, (Expr)this.target).type((Type)array)).del().typeCheck(tc);
                }
            } else if (xts.isValueType(tType) && this.name().equals("location")) {
                return xnf.Cast(this.position, (TypeNode)xnf.CanonicalTypeNode(this.position(), xts.createNullableType(this.position(), (HjNamedType)xts.place())), (Expr)xnf.NullLit(this.position()).typeCheck(tc)).typeCheck(tc);
            }
            throw e;
        }
    }

    protected void checkFieldAccessesInDepClausesAreFinal(HjField_c result, TypeChecker tc) throws SemanticException {
        HjContext xtc = (HjContext)tc.context();
        if (xtc.inDepType()) {
            FieldInstance fi = result.fieldInstance();
            if (!fi.flags().contains(Flags.FINAL)) {
                throw new SemanticException("Field " + fi.name() + " is not final. Only final fields are permitted in a depclause.", this.position());
            }
            if (!(!(this.target instanceof HjSpecial) || ((HjSpecial)this.target).kind() != HjSpecial.SELF || fi instanceof HjFieldInstance && ((HjFieldInstance)fi).isProperty())) {
                throw new SemanticException("Field \"" + fi.name() + "\" is not a property of " + fi.container() + ". " + "Only properties may appear unqualified or prefixed with self in a depclause.");
            }
        }
    }

    protected HjField_c checkArrayFields(HjField_c result) {
        HjType aType = (HjType)result.target.type();
        HjTypeSystem xts = (HjTypeSystem)aType.typeSystem();
        if (result.name().equals("distribution") && xts.isHjArray(aType)) {
            C_Var me;
            Constraint c;
            C_Var place2;
            HjParsedClassType aType1 = (HjParsedClassType)aType;
            HjParsedClassType type = ((HjParsedClassType)result.type()).makeVariant();
            C_Var rank = aType1.rank();
            if (rank != null) {
                type.setRank(rank);
            }
            if (aType1.isRect()) {
                type.setRect();
            }
            if (aType1.isZeroBased()) {
                type.setZeroBased();
            }
            if ((place2 = aType1.onePlace()) != null) {
                type.setOnePlace(place2);
            }
            if ((c = aType1.depClause()) != null && (me = c.selfVar()) != null) {
                C_Field_c f = new C_Field_c(result.fieldInstance(), me);
                Constraint myC = type.depClause();
                myC.setSelfVar(f);
            }
            result = (HjField_c)result.fieldInstance(result.fieldInstance().type((Type)type)).type((Type)type);
            return result;
        }
        if (this.name().equals("region") && (xts.isHjArray(aType) || xts.isDistribution(aType))) {
            C_Var me;
            Constraint c;
            HjParsedClassType aType1 = (HjParsedClassType)(aType instanceof NullableType ? ((NullableType)aType).base() : aType);
            HjParsedClassType type = ((HjParsedClassType)result.type()).makeVariant();
            C_Var aRank = aType1.rank();
            if (aRank != null) {
                type.setRank(aRank);
            }
            if (aType1.isRect()) {
                type.setRect();
            }
            if (aType1.isZeroBased()) {
                type.setZeroBased();
            }
            if ((c = aType1.depClause()) != null && (me = c.selfVar()) != null) {
                C_Field_c f = new C_Field_c(result.fieldInstance(), me);
                Constraint myC = type.depClause();
                myC.setSelfVar(f);
            }
            result = (HjField_c)result.fieldInstance(result.fieldInstance().type((Type)type)).type((Type)type);
            return result;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Field_c)) {
            return false;
        }
        Field_c other = (Field_c)o;
        return this.target.equals(other.target()) && this.name().equals(other.name());
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.target) {
            return this.fi.container();
        }
        return child.type();
    }
}

