/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.plugin;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.StringTokenizer;
import polyglot.ext.hj.Configuration;
import polyglot.ext.hj.ExtensionInfo;
import polyglot.ext.hj.plugin.CompilerPlugin;
import polyglot.frontend.AbstractPass;
import polyglot.frontend.FileSource;
import polyglot.frontend.Parser;
import polyglot.frontend.ParserlessJLExtensionInfo;
import polyglot.frontend.Pass;
import polyglot.frontend.SourceLoader;
import polyglot.frontend.goals.AbstractGoal;
import polyglot.frontend.goals.Goal;
import polyglot.util.ErrorQueue;
import polyglot.util.InternalCompilerError;
import polyglot.util.QuotedStringTokenizer;

public class LoadPlugins
extends AbstractGoal {
    public static void loadPlugin(ExtensionInfo extInfo, String pluginName) {
        ErrorQueue eq = extInfo.compiler().errorQueue();
        Object sourceFile = null;
        ParserlessJLExtensionInfo jlExtInfo = new ParserlessJLExtensionInfo(){

            public Parser parser(Reader reader, FileSource source, ErrorQueue eq) {
                throw new InternalCompilerError("Missing parser");
            }

            public String[] fileExtensions() {
                return new String[]{"java"};
            }
        };
        SourceLoader sourceLoader = new SourceLoader((polyglot.frontend.ExtensionInfo)jlExtInfo, extInfo.getOptions().source_path);
        FileSource s = sourceLoader.classSource(pluginName);
        while (true) {
            block9: {
                try {
                    Class<?> c = Class.forName(pluginName);
                    Object o = c.newInstance();
                    if (o instanceof CompilerPlugin) {
                        CompilerPlugin plugin = (CompilerPlugin)o;
                        extInfo.addPlugin(pluginName, plugin);
                        return;
                    }
                    if (s == null) {
                        eq.enqueue(0, "Class " + pluginName + " does not implement CompilerPlugin.  Continuing.");
                        return;
                    }
                }
                catch (IllegalAccessException e) {
                    if (s == null) {
                        eq.enqueue(0, "Plugin class " + pluginName + " could not be accessed.  Continuing without it.");
                        return;
                    }
                }
                catch (InstantiationException e) {
                    if (s == null) {
                        eq.enqueue(0, "Plugin class " + pluginName + " could not be instantiated.  Continuing without it.");
                        return;
                    }
                }
                catch (ClassNotFoundException e) {
                    if (s != null) break block9;
                    eq.enqueue(0, "Plugin class " + pluginName + " not found.  Continuing without it.");
                    return;
                }
            }
            if (s == null) continue;
            eq.enqueue(0, "Compiling " + pluginName + " in " + s.path());
            LoadPlugins.compilePlugin(extInfo, s.path());
            s = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compilePlugin(ExtensionInfo extInfo, String sourceFile) {
        ErrorQueue eq = extInfo.compiler().errorQueue();
        String javac = Configuration.PLUGIN_COMPILER;
        if (javac == null || javac.equals("")) {
            javac = extInfo.getOptions().post_compiler;
        }
        if (javac != null) {
            Runtime runtime = Runtime.getRuntime();
            QuotedStringTokenizer qst = new QuotedStringTokenizer(javac);
            int pc_size = qst.countTokens();
            String[] javacCmd = new String[pc_size + 3];
            int j = 0;
            int source = -2;
            for (int i = 0; i < pc_size; ++i) {
                String arg = qst.nextToken();
                if (arg.equals("-source")) {
                    source = i;
                }
                if (source + 1 == i && (arg.equals("1.0") || arg.equals("1.1") || arg.equals("1.2") || arg.equals("1.3") || arg.equals("1.4"))) {
                    arg = "1.5";
                }
                javacCmd[j++] = arg;
            }
            javacCmd[j++] = "-classpath";
            javacCmd[j++] = extInfo.getOptions().constructPostCompilerClasspath();
            javacCmd[j++] = sourceFile;
            try {
                Process proc = runtime.exec(javacCmd);
                InputStreamReader err = new InputStreamReader(proc.getErrorStream());
                try {
                    int len;
                    char[] c = new char[72];
                    StringBuffer sb = new StringBuffer();
                    while ((len = err.read(c)) > 0) {
                        sb.append(String.valueOf(c, 0, len));
                    }
                    if (sb.length() != 0) {
                        eq.enqueue(0, sb.toString());
                    }
                }
                finally {
                    err.close();
                }
                proc.waitFor();
                if (proc.exitValue() > 0) {
                    eq.enqueue(0, "Non-zero return code: " + proc.exitValue());
                }
            }
            catch (Exception e) {
                eq.enqueue(0, e.getMessage());
            }
        }
    }

    public LoadPlugins() {
        super(null, "LoadPlugins");
    }

    public Pass createPass(polyglot.frontend.ExtensionInfo extInfo) {
        return new LoadPluginsPass((Goal)this, (ExtensionInfo)extInfo);
    }

    public static Goal create(ExtensionInfo.HjScheduler scheduler) {
        return scheduler.internGoal((Goal)new LoadPlugins());
    }

    protected static final class LoadPluginsPass
    extends AbstractPass {
        private final ExtensionInfo extInfo;

        protected LoadPluginsPass(Goal goal, ExtensionInfo extInfo) {
            super(goal);
            this.extInfo = extInfo;
        }

        public boolean run() {
            String compilerPlugins;
            String xmlProcessor = Configuration.XML_PROCESSOR;
            boolean exportXML = Configuration.EXTERNALIZE_ASTS;
            if (xmlProcessor != null && !xmlProcessor.equals("")) {
                exportXML = true;
            }
            if (exportXML) {
                LoadPlugins.loadPlugin(this.extInfo, "polyglot.ext.hj.dom.ExternalizerPlugin");
            }
            if ((compilerPlugins = Configuration.PLUGINS) != null && !compilerPlugins.equals("")) {
                this.loadPluginsFromConfigString(compilerPlugins);
            }
            return true;
        }

        private void loadPluginsFromConfigString(String compilerPlugins) {
            StringTokenizer st = new StringTokenizer(compilerPlugins, ",; \t\n");
            while (st.hasMoreTokens()) {
                String pluginName = st.nextToken();
                if (pluginName.length() <= 0) continue;
                LoadPlugins.loadPlugin(this.extInfo, pluginName);
            }
        }
    }
}

