/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import polyglot.ext.hj.types.HjComplexType;
import polyglot.ext.hj.types.HjPrimitiveType_c;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.PrimitiveType;
import polyglot.types.Type;

public class HjComplexType_c
extends HjPrimitiveType_c
implements HjComplexType {
    public static String FIELD_REAL = "real";
    public static String FIELD_IMAG = "imag";
    private PrimitiveType baseType;

    public HjComplexType_c(HjTypeSystem xts, PrimitiveType.Kind kind) {
        super(xts, kind);
        this.baseType = this.getBaseType(xts);
    }

    private PrimitiveType getBaseType(HjTypeSystem xts) {
        return this.isComplex64() ? xts.Double() : xts.Float();
    }

    public boolean isComplex64() {
        return this.kind == COMPLEX_64;
    }

    public boolean isComplex32() {
        return this.kind == COMPLEX_32;
    }

    public PrimitiveType base() {
        return this.baseType;
    }

    public boolean isImplicitCastValidImpl(Type toType) {
        HjTypeSystem xts = (HjTypeSystem)this.typeSystem();
        PrimitiveType baseFromType = this.base();
        Type baseToType = toType;
        if (xts.isComplex32(toType) || xts.isComplex64(toType)) {
            baseToType = ((HjComplexType)toType).base();
        }
        return xts.isImplicitCastValid((Type)baseFromType, baseToType);
    }
}

