/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import polyglot.ast.Formal;
import polyglot.ext.hj.ExtensionInfo;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjFlags;
import polyglot.ext.hj.types.HjMethodInstance;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjProcedureInstance;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeObject;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_Root;
import polyglot.ext.hj.types.constr.C_Special;
import polyglot.ext.hj.types.constr.C_Special_c;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.types.constr.Constraint_c;
import polyglot.frontend.MissingDependencyException;
import polyglot.main.Report;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.MethodInstance_c;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjMethodInstance_c
extends MethodInstance_c
implements HjMethodInstance {
    protected List<HjClassType> annotations;
    List<Formal> formals;

    @Override
    public List<HjClassType> annotations() {
        if (this != this.orig()) {
            return ((HjMethodInstance)this.orig()).annotations();
        }
        if (!this.annotationsSet()) {
            if (this.container() instanceof HjParsedClassType) {
                ExtensionInfo.HjScheduler scheduler = (ExtensionInfo.HjScheduler)this.typeSystem().extensionInfo().scheduler();
                HjParsedClassType ct = (HjParsedClassType)this.container();
                if (ct.job() != null) {
                    throw new MissingDependencyException(scheduler.TypeObjectAnnotationsPropagated(ct), false);
                }
            }
            this.annotations = Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public boolean annotationsSet() {
        if (this != this.orig()) {
            return ((HjMethodInstance)this.orig()).annotationsSet();
        }
        return this.annotations != null;
    }

    @Override
    public void setAnnotations(List<HjClassType> annotations) {
        assert (this == this.orig());
        if (annotations == null) {
            annotations = Collections.EMPTY_LIST;
        }
        this.annotations = new ArrayList<HjClassType>(annotations);
    }

    @Override
    public HjTypeObject annotations(List<HjClassType> annotations) {
        HjTypeObject n = (HjTypeObject)this.copy();
        n.setAnnotations(annotations);
        return n;
    }

    @Override
    public List<HjClassType> annotationMatching(Type t) {
        ArrayList<HjClassType> l = new ArrayList<HjClassType>();
        for (HjClassType ct : this.annotations()) {
            if (!ct.isSubtype(t)) continue;
            l.add(ct);
        }
        return l;
    }

    public HjMethodInstance_c() {
    }

    public HjMethodInstance_c(TypeSystem ts, Position pos, ReferenceType container, Flags flags, Type returnType, String name, List formalTypes, List excTypes) {
        super(ts, pos, container, flags, returnType, name, formalTypes, excTypes);
    }

    public boolean canOverrideImpl(MethodInstance mj, boolean quiet) throws SemanticException {
        boolean result = super.canOverrideImpl(mj, quiet);
        HjMethodInstance_c mi = this;
        HjFlags miF = HjFlags.toHjFlags(mi.flags());
        HjFlags mjF = HjFlags.toHjFlags(mj.flags());
        if (result && !miF.hasAllAnnotationsOf(mjF)) {
            if (Report.should_report((String)"types", (int)3)) {
                Report.report((int)3, (String)(mi.flags() + " is more liberal than " + mj.flags()));
            }
            if (quiet) {
                return false;
            }
            throw new SemanticException(mi.signature() + " in " + mi.container() + " cannot override " + mj.signature() + " in " + mj.container() + "; attempting to assign weaker " + "behavioral annotations", mi.position());
        }
        return result;
    }

    public boolean isPropertyGetter() {
        assert (this.container instanceof HjParsedClassType);
        boolean isJavaType = ((HjParsedClassType)this.container).isJavaType();
        if (isJavaType) {
            return false;
        }
        if (!this.formalTypes.isEmpty()) {
            return false;
        }
        FieldInstance fi = this.container.fieldNamed("propertyNames$");
        if (fi == null) {
            return false;
        }
        String propertyNames = (String)fi.constantValue();
        Scanner s = new Scanner(propertyNames);
        while (s.hasNext()) {
            String propName = s.next();
            if (!propName.equals(this.name())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isJavaMethod() {
        assert (this.container instanceof HjParsedClassType);
        boolean result = ((HjParsedClassType)this.container).isJavaType();
        return result;
    }

    @Override
    public boolean isSafe() {
        assert (this.container instanceof HjParsedClassType);
        boolean result = ((HjParsedClassType)this.container).safe();
        if (result) {
            return true;
        }
        HjFlags f = HjFlags.toHjFlags(this.flags());
        result = f.isSafe();
        return result;
    }

    protected static String myListToString(List l) {
        StringBuffer sb = new StringBuffer();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            sb.append(o.toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public HjMethodInstance instantiateForThis(HjType thisType) {
        HjType retType;
        boolean needed = false;
        HjType newRetType = retType = (HjType)this.returnType();
        Constraint rc = retType.realClause();
        C_Special THIS = C_Special_c.This;
        C_Var selfVar = thisType.selfVar();
        Iterator it = this.formalTypes().iterator();
        while (!needed && it.hasNext()) {
            HjType type = (HjType)it.next();
            rc = type.realClause();
            if (rc == null) continue;
            needed = rc.hasVar(THIS);
        }
        if (!needed) {
            return this;
        }
        ArrayList<HjType> newFormalTypes = new ArrayList<HjType>(this.formalTypes.size());
        for (HjType type : this.formalTypes()) {
            rc = type.realClause();
            HjType newType = type;
            if (rc != null && rc.hasVar(THIS)) {
                C_Var myVar = selfVar;
                if (myVar == null) {
                    myVar = rc.genEQV(type, true);
                }
                Constraint rc2 = rc.substitute(selfVar, THIS, false);
                newType = type.makeVariant(rc2, null);
            }
            newFormalTypes.add(newType);
        }
        HjMethodInstance_c result = new HjMethodInstance_c(this.ts, this.position(), this.container, this.flags, newRetType, this.name, newFormalTypes, this.throwTypes());
        return result;
    }

    public boolean callValidImpl(List argTypes) {
        return HjMethodInstance_c.callValidImpl(this, argTypes);
    }

    public static boolean callValidImpl(HjProcedureInstance me, List<HjType> args) {
        int i;
        boolean result = me.callValidImplNoClauses(args);
        if (!result) {
            return result;
        }
        List<HjType> formals = me.formalTypes();
        int n = formals.size();
        boolean typesNotDep = true;
        for (int i2 = 0; typesNotDep && i2 < n; ++i2) {
            Constraint d = formals.get(i2).realClause();
            typesNotDep = d == null || d.valid();
        }
        if (typesNotDep) {
            return true;
        }
        Constraint_c env = new Constraint_c((HjTypeSystem)me.typeSystem());
        C_Root[] x = new C_Root[n];
        C_Var[] y = new C_Var[n];
        for (i = 0; i < n; ++i) {
            Constraint fc;
            HjType type = formals.get(i);
            HjType aType = args.get(i);
            Constraint yc = aType.depClause();
            if (yc != null) {
                y[i] = yc.selfVar();
            }
            if (y[i] == null) {
                y[i] = env.genEQV(aType, false, false);
            }
            if ((fc = type.depClause()) != null) {
                x[i] = (C_Root)fc.selfVar();
            }
            if (x[i] == null) {
                x[i] = env.genEQV(type, false, false);
            }
            env.internRecursively(y[i]);
        }
        for (i = 0; result && i < n; ++i) {
            Constraint query = formals.get(i).realClause();
            if (query == null || query.valid()) continue;
            Constraint query2 = query.substitute(y, x, false);
            Constraint query3 = query2.substitute(y[i], C_Special_c.Self, false);
            result = env.entails(query3);
        }
        return result;
    }

    @Override
    public boolean callValidImplNoClauses(List argTypes) {
        return HjMethodInstance_c.callValidImplNoClauses(this, argTypes);
    }

    public static boolean callValidImplNoClauses(HjProcedureInstance me, List<HjType> argTypes) {
        List<HjType> l1 = me.formalTypes();
        List<HjType> l2 = argTypes;
        TypeSystem ts = me.typeSystem();
        Iterator<HjType> i1 = l1.iterator();
        Iterator<HjType> i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            HjType t1 = i1.next();
            HjType t2 = i2.next();
            if (ts.isImplicitCastValid((Type)t2.makeNoClauseVariant(), (Type)t1.makeNoClauseVariant())) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public String toString() {
        String s = this.designator() + " " + this.flags + " " + this.returnType + " " + this.container() + "." + this.signature();
        if (!this.throwTypes.isEmpty()) {
            s = s + " throws " + HjMethodInstance_c.myListToString(this.throwTypes);
        }
        return s;
    }
}

