/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types;

import java.util.List;
import polyglot.ast.ClassDecl;
import polyglot.ast.CodeDecl;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Special;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.types.FutureType;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.NullableType;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.types.Type_c;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public abstract class HjType_c
extends Type_c
implements HjType {
    protected Constraint depClause;
    protected List typeParameters;
    protected HjType rootType = this;
    protected HjTypeSystem xts = (HjTypeSystem)this.ts;

    public void setTypeParameters(List t) {
        this.typeParameters = t;
    }

    public void setDepClause(Constraint d) {
        this.depClause = d;
    }

    public HjType rootType() {
        return this.rootType;
    }

    public boolean isParametric() {
        return this.typeParameters == null || !this.typeParameters.isEmpty();
    }

    public List typeParameters() {
        return this.typeParameters;
    }

    public Constraint depClause() {
        return this.depClause();
    }

    private HjType_c() {
    }

    private HjType_c(HjTypeSystem ts, Position pos) {
        super((TypeSystem)ts, pos);
    }

    public static HjType substituteForThis(HjType t, final Expr e) {
        DepParameterExpr dep = t.dep();
        DepParameterExpr dep2 = (DepParameterExpr)dep.visit(new NodeVisitor(){

            public Node override(Node n) {
                if (n instanceof ClassDecl || n instanceof CodeDecl) {
                    return n;
                }
                if (n instanceof Special && ((Special)n).kind() == Special.THIS) {
                    return e;
                }
                return null;
            }
        });
        return t.dep(dep2);
    }

    public boolean typeEqualsImpl(Type o) {
        return this.equalsImpl((TypeObject)o);
    }

    public int hashCode() {
        return (this.rootType == this ? super.hashCode() : this.rootType.hashCode()) + (this.depClause != null ? this.depClause.hashCode() : 0) + (this.typeParameters != null && !this.typeParameters.isEmpty() ? ((Object)this.typeParameters).hashCode() : 0);
    }

    public static boolean isSubtypeImpl(Type me, Type other) {
        HjType target = (HjType)other;
        HjType xme = (HjType)me;
        HjTypeSystem ts = (HjTypeSystem)xme.typeSystem();
        HjType tb = xme.rootType();
        HjType ob = target.rootType();
        boolean result = false;
        boolean bl = result = (ts.equals(tb, ob) || ts.descendsFrom(tb, ob)) && ts.entailsClause(xme, target);
        if (result) {
            return result;
        }
        if (ts.isNullable(target)) {
            NullableType toType = HjType_c.toNullable(target);
            HjNamedType baseType = toType.base();
            result = me.isSubtypeImpl((Type)baseType);
            return result;
        }
        return result;
    }

    public static NullableType toNullable(HjType me) {
        HjTypeSystem ts = (HjTypeSystem)me.typeSystem();
        return ts.isNullable(me) ? (NullableType)me : null;
    }

    public static FutureType toFuture(HjType me) {
        HjTypeSystem ts = (HjTypeSystem)me.typeSystem();
        return ts.isFuture(me) ? (FutureType)me : null;
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isFuture() {
        return false;
    }

    public FutureType toFuture() {
        return HjType_c.toFuture(this);
    }

    public NullableType toNullable() {
        return HjType_c.toNullable(this);
    }

    public boolean isPrimitiveTypeArray() {
        return this.xts.isPrimitiveTypeArray(this);
    }

    public boolean isHjArray() {
        return this.xts.isHjArray(this);
    }

    public boolean isBooleanArray() {
        return this.xts.isBooleanArray(this);
    }

    public boolean isCharArray() {
        return this.xts.isCharArray(this);
    }

    public boolean isByteArray() {
        return this.xts.isByteArray(this);
    }

    public boolean isShortArray() {
        return this.xts.isShortArray(this);
    }

    public boolean isIntArray() {
        return this.xts.isIntArray(this);
    }

    public boolean isLongArray() {
        return this.xts.isLongArray(this);
    }

    public boolean isFloatArray() {
        return this.xts.isFloatArray(this);
    }

    public boolean isDoubleArray() {
        return this.xts.isDoubleArray(this);
    }

    public boolean isClock() {
        return this.xts.isClock(this);
    }

    public boolean isPoint() {
        return this.xts.isPoint(this);
    }

    public boolean isPlace() {
        return this.xts.isPlace(this);
    }

    public boolean isRegion() {
        return this.xts.isRegion(this);
    }

    public boolean isDistribution() {
        return this.xts.isDistribution(this);
    }

    public boolean isValueType() {
        return this.xts.isValueType(this);
    }

    public boolean isComplex32() {
        return this.xts.isComplex32(this);
    }

    public boolean isComplex64() {
        return this.xts.isComplex64(this);
    }
}

