/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.basic;

import habanero.runtime.basic.Closure;
import habanero.runtime.basic.Deque;
import habanero.runtime.basic.DequeReserveBottom;
import habanero.runtime.basic.FinishTreeNode;
import habanero.runtime.basic.Frame;
import habanero.runtime.basic.Runtime;
import habanero.runtime.basic.SpawnFrameStolenException;
import java.util.Random;

public class Worker
extends Thread {
    public final int id;
    public int status;
    public static final int STATUS_READYTOGO = 0;
    public static final int STATUS_STEALING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_SUSPENDED = 3;
    private Deque deque;
    public final Runtime runtime;
    private Closure closure;
    private int numSteals = 0;
    private int numStealAttempts = 0;
    private Closure provablyGoodSteal;

    public Worker(int id, Runtime rt, Closure c) {
        this.id = id;
        this.runtime = rt;
        this.closure = c;
        this.deque = rt.reserveBottom ? new DequeReserveBottom() : new Deque();
    }

    public void run() {
        Random rand = new Random(System.currentTimeMillis() + (long)this.id);
        Closure c = this.closure;
        int victimId = this.id;
        int numWorkers = this.runtime.getNumWorkers();
        Worker victim = null;
        while (!Runtime.done) {
            if (c == null) {
                this.status = 1;
            }
            while (c == null && !Runtime.done) {
                do {
                    if ((victimId = (int)(rand.nextDouble() * (double)numWorkers)) == this.id) continue;
                    victim = this.runtime.getWorker(victimId);
                } while (victim == null);
                c = super.steal();
            }
            if (Runtime.done) break;
            this.status = 0;
            c = this.startWork(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Closure startWork(Closure c) {
        this.closure = c;
        Frame f = c.getFrame();
        this.provablyGoodSteal = null;
        this.status = 2;
        try {
            f.executeSlow(this);
        }
        catch (SpawnFrameStolenException spawnFrameStolenException) {
        }
        finally {
            this.closureTerminating();
        }
        return this.provablyGoodSteal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closureTerminating() {
        assert (!Runtime.done);
        if (this.status != 3) {
            FinishTreeNode finish;
            if (this.closure.getCurrentFinishScope() == null) {
                Runtime.done = true;
                return;
            }
            FinishTreeNode finishTreeNode = finish = this.closure.getCurrentFinishScope();
            synchronized (finishTreeNode) {
                if (finish.decNumLiveChildren() == 0) {
                    this.provablyGoodSteal = finish.getSuspendedClosure();
                }
            }
        }
    }

    private Closure steal() {
        Object o = this.deque.steal();
        ++this.numStealAttempts;
        if (o == Deque.Empty || o == Deque.Abort) {
            return null;
        }
        ++this.numSteals;
        Closure c = (Closure)o;
        return c;
    }

    public void startFinish() {
        Closure c = this.closure;
        c.setCurrentFinishScope(new FinishTreeNode(c.getCurrentFinishScope()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopFinishSlow() {
        Closure c = this.closure;
        FinishTreeNode finish = c.getCurrentFinishScope();
        FinishTreeNode parent = finish.getParent();
        c.setCurrentFinishScope(parent);
        FinishTreeNode finishTreeNode = finish;
        synchronized (finishTreeNode) {
            if (finish.getNumLiveChildren() > 0) {
                this.status = 3;
                finish.setSuspendedClosure(c);
                return false;
            }
        }
        return true;
    }

    public void stopFinishFast() {
        this.closure.setCurrentFinishScope(this.getCurrentFinishScope().getParent());
    }

    public void pushFrame(Frame f) {
        this.deque.pushBottom(f);
    }

    public Frame popFrame() {
        return (Frame)this.deque.popBottom();
    }

    public Frame popFrameAndThrowException() throws SpawnFrameStolenException {
        Frame f = (Frame)this.deque.popBottom();
        if (f == null) {
            throw new SpawnFrameStolenException();
        }
        return f;
    }

    public boolean checkStolen() {
        return this.deque.isEmpty();
    }

    public int getNumSteals() {
        return this.numSteals;
    }

    public int getNumStealAttempts() {
        return this.numStealAttempts;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public FinishTreeNode getCurrentFinishScope() {
        return this.closure.getCurrentFinishScope();
    }

    public String toString() {
        return "Worker " + this.id;
    }
}

