/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.bfAsyncs;

import habanero.runtime.bfAsyncs.Deque;
import habanero.runtime.bfAsyncs.Worker;
import java.util.concurrent.atomic.AtomicInteger;

public class DequeLeak
implements Deque {
    protected Worker worker;
    public static final Object Empty = null;
    public static final Object Abort = new Object();
    protected static final int K = 3;
    protected volatile int bottom = 0;
    protected AtomicInteger top = new AtomicInteger(0);
    protected volatile CircularArray activeArray = new CircularArray(12);

    public DequeLeak(Worker worker) {
        this.worker = worker;
    }

    public void pushBottom(Object o) {
        CircularArray a;
        int b = this.bottom;
        int t = this.top.get();
        int size = b - t;
        if (size >= (a = this.activeArray).size() - 1) {
            this.activeArray = a = a.grow(b, t);
        }
        a.put(b, o);
        this.bottom = b + 1;
    }

    public Object steal() {
        int t = this.top.get();
        int b = this.bottom;
        CircularArray a = this.activeArray;
        int size = b - t;
        if (size <= 0) {
            return Empty;
        }
        Object o = a.get(t);
        assert (o != null);
        return o;
    }

    public Object popBottom() {
        int b = this.bottom;
        CircularArray a = this.activeArray;
        this.bottom = --b;
        int t = this.top.get();
        int size = b - t;
        if (size < 0) {
            this.bottom = t;
            return Empty;
        }
        Object o = a.get(b);
        if (size > 0) {
            return o;
        }
        if (!this.top.compareAndSet(t, t + 1)) {
            o = Empty;
        }
        this.bottom = t + 1;
        return o;
    }

    public boolean isEmpty() {
        return this.bottom - this.top.get() <= 0;
    }

    protected void perhapsShrink(int b, int t) {
        CircularArray a = this.activeArray;
        if (b - t < a.size() / 3) {
            CircularArray aa;
            this.activeArray = aa = a.shrink(b, t);
        }
    }

    public int size() {
        return this.bottom - this.top.get();
    }

    class CircularArray {
        private int log_size;
        private int size;
        private Object[] segment;

        CircularArray(int log_size) {
            this.log_size = log_size;
            this.size = 1 << log_size;
            this.segment = new Object[this.size];
        }

        int size() {
            return this.size;
        }

        Object get(int i) {
            int index = i % this.size;
            return this.segment[index];
        }

        void put(int i, Object o) {
            int index = i % this.size;
            this.segment[index] = o;
        }

        CircularArray grow(int b, int t) {
            CircularArray a = new CircularArray(this.log_size + 1);
            for (int i = t; i < b; ++i) {
                a.put(i, this.get(i));
            }
            return a;
        }

        CircularArray shrink(int b, int t) {
            CircularArray a = new CircularArray(this.log_size - 1);
            for (int i = t; i < b; ++i) {
                a.put(i, this.get(i));
            }
            return a;
        }
    }
}

