/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.bfAsyncs;

import habanero.runtime.bfAsyncs.Deque;
import habanero.runtime.bfAsyncs.Worker;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class DequeNoLeak
implements Deque {
    protected Worker worker;
    protected static final int K = 3;
    protected volatile int bottom = 0;
    protected volatile int top = 0;
    protected volatile CircularArray activeArray = new CircularArray(12);

    public DequeNoLeak(Worker worker) {
        this.worker = worker;
    }

    public void pushBottom(Object o) {
        int b = this.bottom;
        int t = this.top;
        int size = b - t;
        CircularArray a = this.activeArray;
        if (size >= a.size() - 1) {
            this.activeArray = a = a.grow(b, t);
        }
        a.put(b, o);
        this.bottom = b + 1;
    }

    public Object steal() {
        int t = this.top;
        int b = this.bottom;
        CircularArray a = this.activeArray;
        int size = b - t;
        if (size <= 0) {
            return Empty;
        }
        Object o = a.get(t);
        if (o == null) {
            return Abort;
        }
        return o;
    }

    public Object popBottom() {
        int b = this.bottom;
        CircularArray a = this.activeArray;
        this.bottom = --b;
        int t = this.top;
        int size = b - t;
        if (size < 0) {
            this.bottom = t;
            return Empty;
        }
        Object o = a.get(b);
        if (size > 0) {
            assert (o != null);
            a.put(b, null);
            return o;
        }
        if (o == null || !a.compareAndSet(t, o, null)) {
            this.bottom = t + 1;
            return Empty;
        }
        return o;
    }

    public boolean isEmpty() {
        return this.bottom - this.top <= 0;
    }

    void perhapsShrink(int b, int t) {
        CircularArray a = this.activeArray;
        if (b - t < a.size() / 3) {
            CircularArray aa;
            this.activeArray = aa = a.shrink(b, t);
        }
    }

    public int size() {
        return this.bottom - this.top;
    }

    class CircularArray {
        private int log_size;
        private int size;
        private AtomicReferenceArray<Object> segment;

        CircularArray(int log_size) {
            this.log_size = log_size;
            this.size = 1 << log_size;
            this.segment = new AtomicReferenceArray(this.size);
        }

        int size() {
            return this.size;
        }

        Object get(int i) {
            int index = i % this.size;
            return this.segment.get(index);
        }

        void put(int i, Object o) {
            int index = i % this.size;
            this.segment.lazySet(index, o);
        }

        boolean compareAndSet(int i, Object expect, Object update) {
            int index = i % this.size;
            return this.segment.compareAndSet(index, expect, update);
        }

        CircularArray grow(int b, int t) {
            System.err.println("WARNING: Growing Deque");
            CircularArray a = new CircularArray(this.log_size + 1);
            for (int i = t; i < b; ++i) {
                a.put(i, this.get(i));
            }
            return a;
        }

        CircularArray shrink(int b, int t) {
            CircularArray a = new CircularArray(this.log_size - 1);
            for (int i = t; i < b; ++i) {
                a.put(i, this.get(i));
            }
            return a;
        }
    }
}

