/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.bfAsyncs;

import habanero.runtime.Configuration;
import habanero.runtime.bfAsyncs.Closure;
import habanero.runtime.bfAsyncs.Place;
import habanero.runtime.bfAsyncs.Runtime;
import habanero.runtime.bfAsyncs.Worker;
import habanero.runtime.bfAsyncs.WorkerExecutable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FinishTreeNode {
    private static volatile int ctr = 0;
    private final int _id;
    public final FinishTreeNode parent;
    public Closure suspendedClosure = null;
    private AtomicInteger[] localWorkloadCounter = null;
    private final AtomicBoolean continuationToken = new AtomicBoolean(true);
    private final FinishPlaceControl _initFinishPlaceControl;
    private final Place _mainActivityPlace;
    private FinishPlaceControl[] _finishPlaceControls = null;

    public FinishTreeNode(FinishTreeNode parent, Worker creator) {
        this.parent = parent;
        this._mainActivityPlace = creator.place();
        this._initFinishPlaceControl = new FinishPlaceControl();
        this._initFinishPlaceControl.numActiveWorker().set(1);
        this._id = ctr++;
    }

    public AtomicInteger getLocalWorkloadCounterByWorker(Worker worker) {
        int index = worker.index;
        if (this.localWorkloadCounter == null) {
            this.localWorkloadCounter = new AtomicInteger[Configuration.NUMBER_OF_WORKERS_PER_PLACE * Configuration.NUMBER_OF_PLACES * 16];
        }
        if (this.localWorkloadCounter[index] == null) {
            this.localWorkloadCounter[index] = new AtomicInteger(0);
        }
        return this.localWorkloadCounter[index];
    }

    public boolean hasCompletedLocalWork(int index) {
        if (this.localWorkloadCounter == null) {
            return true;
        }
        if (this.localWorkloadCounter[index] == null) {
            return true;
        }
        return this.localWorkloadCounter[index].get() == 0;
    }

    public FinishPlaceControl getFinishPlaceControlByPlace(Place place) {
        if (place == this._mainActivityPlace) {
            return this._initFinishPlaceControl;
        }
        int placeId = place.id();
        if (this._finishPlaceControls == null) {
            this._finishPlaceControls = new FinishPlaceControl[Runtime.singleton.getNumPlaces()];
            this._finishPlaceControls[this._mainActivityPlace.id()] = this._initFinishPlaceControl;
        }
        if (this._finishPlaceControls[placeId] == null) {
            this._finishPlaceControls[placeId] = new FinishPlaceControl();
        }
        return this._finishPlaceControls[placeId];
    }

    public AtomicInteger getNumActiveWorkersByPlace(Place place) {
        return this.getFinishPlaceControlByPlace(place).numActiveWorker();
    }

    public AtomicIntegerWithVersion getPendingIncomingTasksByPlace(Place place) {
        return this.getFinishPlaceControlByPlace(place).pendingIncomingTasks();
    }

    public BlockingQueue<WorkerExecutable> getIncomingTaskQueueByPlace(Place place) {
        return place.incomingTaskQueue();
    }

    public boolean verifyCompleteAndCompleteForContinuation() {
        if (this.verifyComplete()) {
            return this.continuationToken.compareAndSet(true, false);
        }
        return false;
    }

    public boolean verifyComplete() {
        int i;
        if (this._finishPlaceControls == null) {
            return this._initFinishPlaceControl.isQuiet();
        }
        int conflictDectect = 0;
        for (i = 0; i < this._finishPlaceControls.length; ++i) {
            if (!this._finishPlaceControls[i].isQuiet()) {
                return false;
            }
            conflictDectect += this._finishPlaceControls[i].pendingIncomingTasks().version();
        }
        for (i = 0; i < this._finishPlaceControls.length; ++i) {
            conflictDectect -= this._finishPlaceControls[i].pendingIncomingTasks().version();
        }
        return conflictDectect == 0;
    }

    public boolean isTopLevel() {
        return this.parent == null;
    }

    public String toString() {
        String s = this.parent == null ? "TopFinish" : "Finish(" + this._id + ",up" + this.parent._id;
        if (this._finishPlaceControls == null) {
            return s + ",[p" + this._mainActivityPlace.id() + ",aw=" + this._initFinishPlaceControl.numActiveWorker() + ",pt=" + this._initFinishPlaceControl.pendingIncomingTasks() + "])";
        }
        for (int i = 0; i < this._finishPlaceControls.length; ++i) {
            if (i > 0) {
                s = "," + s;
            }
            s = s + "[p" + i;
            s = this._finishPlaceControls[i] == null ? s + ",aw=0,pt=0]" : s + ",aw=" + this._finishPlaceControls[i]._numActiveWorkers.get() + ",pt=" + this._finishPlaceControls[i].pendingIncomingTasks().get() + "]";
        }
        return s;
    }

    public class FinishPlaceControl {
        private final AtomicInteger _numActiveWorkers = new AtomicInteger(0);
        private final AtomicIntegerWithVersion _pendingIncomingTasks = new AtomicIntegerWithVersion(0);

        public AtomicInteger numActiveWorker() {
            return this._numActiveWorkers;
        }

        public AtomicIntegerWithVersion pendingIncomingTasks() {
            return this._pendingIncomingTasks;
        }

        public boolean isQuiet() {
            return this._numActiveWorkers.get() == 0 && this.pendingIncomingTasks().get() == 0;
        }
    }

    public static class AtomicIntegerWithVersion {
        private final AtomicInteger _version = new AtomicInteger(0);
        private final AtomicInteger _value;

        public AtomicIntegerWithVersion() {
            this(0);
        }

        public AtomicIntegerWithVersion(int initValue) {
            this._value = new AtomicInteger(initValue);
        }

        private int version() {
            return this._version.get();
        }

        private int get() {
            return this._value.get();
        }

        public int incrementAndGet() {
            this._version.incrementAndGet();
            return this._value.incrementAndGet();
        }

        public int decrementAndGet() {
            this._version.incrementAndGet();
            return this._value.decrementAndGet();
        }

        public String toString() {
            return this._value.toString();
        }
    }
}

