/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.bfAsyncs;

import habanero.runtime.Configuration;
import habanero.runtime.bfAsyncs.ActivationFrame;
import habanero.runtime.bfAsyncs.Closure;
import habanero.runtime.bfAsyncs.FinishTreeNode;
import habanero.runtime.bfAsyncs.Place;
import habanero.runtime.bfAsyncs.Worker;
import x10.runtime.DefaultRuntime_c;

public class Runtime {
    public static Runtime singleton = null;
    private final Worker[] allWorkers;
    private final Place[] allPlaces;
    private final int _numWorkersPerPlace;
    private final int _numPlaces;
    public final boolean reserveBottom;
    public static volatile boolean done = false;
    private long intervalTimer;

    public Runtime(int numPlaces, int numWorkersPerPlace, boolean reserveBottom, boolean reporting) {
        assert (numWorkersPerPlace > 0 && numPlaces > 0);
        this.reserveBottom = reserveBottom;
        this._numPlaces = numPlaces;
        this._numWorkersPerPlace = numWorkersPerPlace;
        Configuration.NUMBER_OF_PLACES = numPlaces;
        Configuration.REPORTING = reporting;
        this.allWorkers = new Worker[numWorkersPerPlace * numPlaces];
        this.allPlaces = new Place[numPlaces];
        done = false;
        this.startX10Runtime();
        assert (singleton == null);
        singleton = this;
    }

    public Runtime(int numWorkersPerPlace, boolean reserveBottom, boolean reporting) {
        this(1, numWorkersPerPlace, reserveBottom, reporting);
    }

    public void startWorkers(ActivationFrame mainAF) {
        int i;
        Closure initClosure = new Closure(null, Place.initPlace);
        this.allWorkers[0] = new Worker(Place.initPlace, 0, this, initClosure);
        FinishTreeNode mainFinishScope = new FinishTreeNode(null, this.allWorkers[0]);
        initClosure.head = mainAF;
        initClosure.currentFinishScope = mainFinishScope;
        for (i = 0; i < this.getNumPlaces(); ++i) {
            Place place = i == 0 ? Place.initPlace : new Place(i);
            this.allPlaces[i] = place;
            for (int j = 0; j < this._numWorkersPerPlace; ++j) {
                int workerID = i * this._numWorkersPerPlace + j;
                if (workerID <= 0) continue;
                this.allWorkers[workerID] = new Worker(place, workerID, this, null);
            }
        }
        for (i = 1; i < this.getNumWorkers(); ++i) {
            this.allWorkers[i].start();
        }
        this.allWorkers[0].run();
        for (i = 1; i < this.getNumWorkers(); ++i) {
            try {
                this.allWorkers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                --i;
            }
        }
        this.stopRuntime();
        if (Configuration.EXECUTION_STATS) {
            this.dumpStatistics();
        }
    }

    public int getNumWorkers() {
        return this._numWorkersPerPlace * this._numPlaces;
    }

    public int getNumPlaces() {
        return this._numPlaces;
    }

    public Worker getWorker(int i) {
        return this.allWorkers[i];
    }

    public Place getPlace(int i) {
        return this.allPlaces[i];
    }

    public int getStealCounts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.getNumWorkers(); ++i) {
            sum += this.allWorkers[i].getNumSteals();
        }
        return sum;
    }

    public int getStealAttempts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.getNumWorkers(); ++i) {
            sum += this.allWorkers[i].getNumStealAttempts();
        }
        return sum;
    }

    private void dumpStatistics() {
        int sumSteals = 0;
        int sumStealAttempts = 0;
        for (int i = 0; i < this.getNumWorkers(); ++i) {
            sumSteals += this.allWorkers[i].getNumSteals();
            sumStealAttempts += this.allWorkers[i].getNumStealAttempts();
        }
        System.err.println("StealAttempts=" + sumStealAttempts + "\t NumSteals=" + sumSteals);
    }

    public void startTimer() {
        this.intervalTimer = -System.nanoTime();
    }

    public void stopTimer() {
        this.intervalTimer += System.nanoTime();
    }

    public long getTimer() {
        return this.intervalTimer;
    }

    private void startX10Runtime() {
        x10.runtime.Configuration.NUMBER_OF_LOCAL_PLACES = 1;
        x10.lang.Runtime.runtime = new DefaultRuntime_c();
        x10.lang.Runtime.factory = x10.lang.Runtime.runtime.getFactory();
        x10.lang.Runtime.runtime.prepareForBoot();
    }

    private void stopRuntime() {
        x10.lang.Runtime.runtime.shutdown();
    }
}

