/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.bfAsyncs;

import habanero.runtime.bfAsyncs.ActivationFrame;
import habanero.runtime.bfAsyncs.BfAsyncFrame;
import habanero.runtime.bfAsyncs.BfJobDequeNoLeak;
import habanero.runtime.bfAsyncs.Closure;
import habanero.runtime.bfAsyncs.Deque;
import habanero.runtime.bfAsyncs.DequeLeak;
import habanero.runtime.bfAsyncs.FinishTreeNode;
import habanero.runtime.bfAsyncs.Place;
import habanero.runtime.bfAsyncs.Runtime;
import habanero.runtime.bfAsyncs.SpawnFrameStolenException;
import habanero.runtime.bfAsyncs.WorkerExecutable;
import java.util.Random;

public class Worker
extends Thread {
    public final int id;
    public final int index;
    private final Place _place;
    public int status;
    public static final int STATUS_READYTOGO = 0;
    public static final int STATUS_STEALING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_SUSPENDED = 3;
    private Deque bfTaskDeque;
    public final Runtime runtime;
    private Closure closure;
    private int numSteals = 0;
    private int numStealAttempts = 0;
    private WorkerExecutable provablyGoodSteal;
    private BfAsyncFrame nextLocalWork;

    public Worker(Place place, int id, Runtime rt, Closure c) {
        this._place = place;
        this.id = id;
        this.index = id * 16;
        this.runtime = rt;
        this.closure = c;
        this.bfTaskDeque = new BfJobDequeNoLeak(this);
    }

    public void setClosure(Closure c) {
        this.closure = c;
    }

    public void run() {
        Random rand = new Random(System.currentTimeMillis() + (long)this.id);
        WorkerExecutable work = this.closure;
        int victimId = this.id;
        int numWorkers = this.runtime.getNumWorkers();
        Worker victim = null;
        while (!Runtime.done) {
            if (work == null) {
                this.status = 1;
            }
            victimId = (int)(rand.nextDouble() * (double)numWorkers);
            int count = 0;
            while (work == null && !Runtime.done) {
                if (count % numWorkers == 0 && this._place.incomingTaskQueue().size() > 0 && (work = (WorkerExecutable)this._place.incomingTaskQueue().poll()) != null) {
                    FinishTreeNode finish = work.getFinishScope();
                    if (!(work instanceof Closure)) {
                        finish.getNumActiveWorkersByPlace(this._place).incrementAndGet();
                    }
                    finish.getPendingIncomingTasksByPlace(this._place).decrementAndGet();
                    break;
                }
                do {
                    victimId = (victimId + 1) % numWorkers;
                    ++count;
                    if (victimId == this.id) continue;
                    victim = this.runtime.getWorker(victimId);
                } while (victim == null);
                if (victim.place() != this._place) continue;
                work = victim.steal();
            }
            if (Runtime.done) break;
            work = this.provablyGoodSteal = this.startWork(work);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerExecutable startWork(WorkerExecutable executable) {
        assert (executable.place() == this._place) : executable.place() + " " + this._place;
        this.provablyGoodSteal = null;
        this.nextLocalWork = null;
        this.status = 2;
        this.closure = executable instanceof Closure ? (Closure)executable : new Closure(executable.getFinishScope(), this._place);
        try {
            executable.execute(this);
        }
        catch (Exception ex) {
            if (!(ex instanceof SpawnFrameStolenException)) {
                System.err.println(ex.toString());
            }
        }
        finally {
            this.provablyGoodSteal = this.closureTerminating();
        }
        return this.provablyGoodSteal;
    }

    public void pushBfAsync(BfAsyncFrame frame) {
        this.pushBfAsync(frame.place(), frame);
    }

    public void pushBfAsync(Place place, BfAsyncFrame frame) {
        if (place.id() == this._place.id()) {
            FinishTreeNode finish = frame.finishScope;
            finish.getLocalWorkloadCounterByWorker(this).incrementAndGet();
            this.bfTaskDeque.pushBottom(frame);
        } else {
            this.pushRemoteTask(place, frame);
        }
    }

    private void pushRemoteTask(Place place, WorkerExecutable task) {
        assert (task.place() == place);
        FinishTreeNode finish = task.getFinishScope();
        FinishTreeNode.FinishPlaceControl control = finish.getFinishPlaceControlByPlace(place);
        control.pendingIncomingTasks().incrementAndGet();
        if (!place.incomingTaskQueue().add(task)) {
            throw new RuntimeException("Incoming task queue of " + place + " is overflow");
        }
    }

    public Object popBfAsync() {
        return this.bfTaskDeque.popBottom();
    }

    private BfAsyncFrame getMoreLocalWork(FinishTreeNode finish) {
        Object o = this.bfTaskDeque.popBottom();
        if (o == DequeLeak.Empty) {
            return null;
        }
        BfAsyncFrame f = (BfAsyncFrame)o;
        if (f.finishScope != finish) {
            this.bfTaskDeque.pushBottom(o);
            return null;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerExecutable closureTerminating() {
        BfAsyncFrame f;
        assert (!Runtime.done);
        if (this.status != 3) {
            FinishTreeNode finish = this.closure.currentFinishScope;
            if (finish.isTopLevel()) {
                Runtime.done = true;
                return null;
            }
            f = this.getMoreLocalWork(finish);
            if (f == null) {
                finish.getNumActiveWorkersByPlace(this._place).decrementAndGet();
                if (finish.hasCompletedLocalWork(this.index) && finish.getNumActiveWorkersByPlace(this._place).get() == 0 && finish.verifyComplete()) {
                    FinishTreeNode finishTreeNode = finish;
                    synchronized (finishTreeNode) {
                        if (finish.verifyCompleteAndCompleteForContinuation()) {
                            Closure c = finish.suspendedClosure;
                            if (c.place() != this._place) {
                                this.pushRemoteTask(c.place(), c);
                            } else {
                                this.provablyGoodSteal = c;
                                return c;
                            }
                        }
                    }
                }
            } else {
                this.nextLocalWork = f;
            }
        }
        if (this.nextLocalWork == null) {
            Object o = this.bfTaskDeque.popBottom();
            if (o == DequeLeak.Empty) {
                return null;
            }
            this.nextLocalWork = (BfAsyncFrame)o;
        }
        f = this.nextLocalWork;
        f.finishScope.getLocalWorkloadCounterByWorker(this).decrementAndGet();
        return f;
    }

    private BfAsyncFrame steal() {
        ++this.numStealAttempts;
        Object o = this.bfTaskDeque.steal();
        if (!(o != Deque.Empty && o != Deque.Abort || (o = this.bfTaskDeque.steal()) != Deque.Empty && o != Deque.Abort)) {
            return null;
        }
        BfAsyncFrame f = (BfAsyncFrame)o;
        FinishTreeNode finish = f.getFinishScope();
        finish.getNumActiveWorkersByPlace(this._place).incrementAndGet();
        finish.getLocalWorkloadCounterByWorker(this).decrementAndGet();
        ++this.numSteals;
        return (BfAsyncFrame)o;
    }

    public void startFinish() {
        Closure c = this.closure;
        c.currentFinishScope = new FinishTreeNode(c.currentFinishScope, this);
    }

    public void stopFinishFast() {
        this.closure.currentFinishScope = this.closure.currentFinishScope.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopFinishSlow() {
        Closure c = this.closure;
        FinishTreeNode finish = c.currentFinishScope;
        c.currentFinishScope = finish.parent;
        finish.suspendedClosure = c;
        BfAsyncFrame f = this.getMoreLocalWork(finish);
        if (f == null) {
            finish.getNumActiveWorkersByPlace(this._place).decrementAndGet();
        }
        if (finish.hasCompletedLocalWork(this.index) && finish.getNumActiveWorkersByPlace(this._place).get() == 0 && finish.verifyComplete()) {
            FinishTreeNode finishTreeNode = finish;
            synchronized (finishTreeNode) {
                if (finish.verifyCompleteAndCompleteForContinuation()) {
                    return true;
                }
            }
        }
        this.status = 3;
        this.nextLocalWork = f;
        return false;
    }

    public int getNumSteals() {
        return this.numSteals;
    }

    public int getNumStealAttempts() {
        return this.numStealAttempts;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public FinishTreeNode getCurrentFinishScope() {
        return this.closure.currentFinishScope;
    }

    public String toString() {
        return "Worker " + this.id;
    }

    public int getLocalQueueSize() {
        return this.bfTaskDeque.size();
    }

    public void startTimer() {
        this.runtime.startTimer();
    }

    public void stopTimer() {
        this.runtime.stopTimer();
    }

    public boolean checkActivationFrameStolen() {
        return this.closure.head == null;
    }

    public void beginMethod(ActivationFrame af) {
        af.next = this.closure.head;
        this.closure.head = af;
    }

    public void endMethodFast() {
        this.closure.head = this.closure.head.next;
    }

    public void endMethodSlow() throws SpawnFrameStolenException {
        this.closure.head = this.closure.head.next;
        if (this.closure.head != null) {
            this.closure.head.execute(this);
        }
    }

    public void endMethodSlow(Object retObject) throws SpawnFrameStolenException {
        this.closure.head = this.closure.head.next;
        if (this.closure.head != null) {
            if (retObject != null) {
                this.closure.head.setReturnResult(retObject);
            }
            this.closure.head.execute(this);
        } else assert (retObject == null);
    }

    public Place place() {
        return this._place;
    }
}

