/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.bfAsyncs.example;

import habanero.runtime.bfAsyncs.ActivationFrame;
import habanero.runtime.bfAsyncs.BfAsyncFrame;
import habanero.runtime.bfAsyncs.FinishTreeNode;
import habanero.runtime.bfAsyncs.Place;
import habanero.runtime.bfAsyncs.Runtime;
import habanero.runtime.bfAsyncs.SpawnFrameStolenException;
import habanero.runtime.bfAsyncs.Worker;

public final class FibHfDist {
    public static final int[] fibsol = new int[]{0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368, 75025, 121393, 196418, 317811, 514229, 832040, 1346269, 2178309, 3524578, 5702887, 0x8CCCC9, 14930352, 24157817, 39088169, 63245986, 102334155, 165580141, 267914296, 433494437, 701408733, 1134903170};

    private static void FibSeq(Worker worker, BoxInteger res, int n) throws SpawnFrameStolenException {
        if (n < 2) {
            res.v = n;
            return;
        }
        FibActivationFrame fibAf = new FibActivationFrame(res, n);
        worker.beginMethod(fibAf);
        worker.startFinish();
        BoxInteger x = new BoxInteger();
        worker.pushBfAsync(new FibBfAsyncFrame(worker.getCurrentFinishScope(), worker.place(), x, n - 1));
        BoxInteger y = new BoxInteger();
        worker.pushBfAsync(new FibBfAsyncFrame(worker.getCurrentFinishScope(), Place.getPlace(1 - worker.place().id()), y, n - 2));
        fibAf.pc = 2;
        fibAf.x = x;
        fibAf.y = y;
        fibAf.n = n;
        fibAf.res = res;
        if (!worker.stopFinishSlow()) {
            throw new SpawnFrameStolenException();
        }
        res.v = x.v + y.v;
        worker.endMethodFast();
    }

    private static void FibSlow(Worker worker, FibActivationFrame af) throws SpawnFrameStolenException {
        BoxInteger res = af.res;
        int n = af.n;
        BoxInteger x = af.x;
        BoxInteger y = af.y;
        assert (af.pc == 2);
        switch (af.pc) {
            case 2: {
                res.v = x.v + y.v;
                assert (res.v == fibsol[n]);
                worker.endMethodSlow();
            }
        }
    }

    private static void mainSlow(Worker worker, MainActivationFrame mainAf) throws SpawnFrameStolenException {
        int n = mainAf.n;
        int ans = mainAf.ans;
        String[] args = mainAf.args;
        switch (mainAf.pc) {
            case 0: {
                n = Integer.parseInt(args[0]);
                mainAf.pc = 1;
                mainAf.n = n;
                ans = FibHfDist.DoFast(worker, n);
                if (worker.checkActivationFrameStolen()) {
                    return;
                }
            }
            case 1: {
                System.out.println("Fib(" + n + ") = " + ans + " " + (ans == fibsol[n] ? "OK" : "FAILURE"));
                worker.endMethodSlow();
            }
        }
    }

    private static int DoFast(Worker worker, int n) throws SpawnFrameStolenException {
        BoxInteger ret;
        DoActivationFrame doCf = new DoActivationFrame(n);
        worker.beginMethod(doCf);
        doCf.ret = ret = new BoxInteger();
        doCf.pc = 1;
        FibHfDist.FibSeq(worker, ret, n);
        if (worker.checkActivationFrameStolen()) {
            return -1;
        }
        worker.endMethodFast();
        return ret.v;
    }

    private static void DoSlow(Worker worker, DoActivationFrame doCf) throws SpawnFrameStolenException {
        int n = doCf.n;
        BoxInteger ret = doCf.ret;
        switch (doCf.pc) {
            case 1: {
                worker.endMethodSlow(ret.v);
            }
        }
    }

    public static void main(String[] args) {
        int numproc = 0;
        if (args.length >= 2 && args[0].equals("--nproc")) {
            try {
                numproc = Integer.parseInt(args[1]);
                String[] restargs = new String[args.length - 2];
                System.arraycopy(args, 2, restargs, 0, restargs.length);
                args = restargs;
            }
            catch (NumberFormatException e) {
                numproc = 1;
            }
        } else {
            numproc = 2;
        }
        Runtime r = new Runtime(2, numproc, false, false);
        MainActivationFrame af = new MainActivationFrame(args);
        af.pc = 0;
        r.startWorkers(af);
    }

    public static final class MainActivationFrame
    extends ActivationFrame {
        String[] args;
        int ans;
        int n;

        public MainActivationFrame(String[] args) {
            this.args = args;
        }

        public void execute(Worker worker) throws SpawnFrameStolenException {
            FibHfDist.mainSlow(worker, this);
        }

        public void setReturnResult(Object v) {
            switch (this.pc) {
                case 1: {
                    this.ans = (Integer)v;
                    return;
                }
            }
            assert (false);
        }

        public String toString() {
            return "MainAf[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class DoActivationFrame
    extends ActivationFrame {
        int n;
        Object retObject;
        BoxInteger ret;

        public DoActivationFrame(int n) {
            this.n = n;
        }

        public void execute(Worker worker) throws SpawnFrameStolenException {
            FibHfDist.DoSlow(worker, this);
        }

        public void setReturnResult(Object v) {
            assert (v == null);
        }

        public String toString() {
            return "DoAF[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class FibBfAsyncFrame
    extends BfAsyncFrame {
        public BoxInteger res;
        public int n;

        FibBfAsyncFrame(FinishTreeNode finish, Place place, BoxInteger res, int n) {
            super(finish, place);
            this.res = res;
            this.n = n;
        }

        public void execute(Worker worker) throws SpawnFrameStolenException {
            FibHfDist.FibSeq(worker, this.res, this.n);
        }

        public String toString() {
            return "FibJob[n=" + this.n + "]";
        }
    }

    public static final class FibActivationFrame
    extends ActivationFrame {
        public BoxInteger res;
        public int n;
        public BoxInteger x;
        public BoxInteger y;

        FibActivationFrame(BoxInteger res, int n) {
            this.res = res;
            this.n = n;
        }

        public void execute(Worker worker) throws SpawnFrameStolenException {
            FibHfDist.FibSlow(worker, this);
        }

        public void setReturnResult(Object v) {
        }

        public String toString() {
            return "FibAF[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class BoxInteger {
        public int v;
    }
}

