/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.seqcallext;

import habanero.runtime.Configuration;
import habanero.runtime.seqcallext.ActivationFrame;
import habanero.runtime.seqcallext.Closure;
import habanero.runtime.seqcallext.Frame;
import habanero.runtime.seqcallext.Worker;
import x10.runtime.DefaultRuntime_c;

public class Runtime {
    private final Worker[] allWorkers;
    private final int numWorkers;
    public static int MIN_FRAME_BOTTOM;
    public static volatile boolean done;
    public final boolean reserveBottom;

    public Runtime(int numWorkers, boolean reserveBottom) {
        assert (numWorkers > 0);
        this.reserveBottom = reserveBottom;
        this.numWorkers = numWorkers;
        this.allWorkers = new Worker[numWorkers];
        this.startX10Runtime();
    }

    public Runtime(boolean reserveBottom) {
        this.reserveBottom = reserveBottom;
        this.numWorkers = Configuration.NUMBER_OF_WORKERS_PER_PLACE;
        this.allWorkers = new Worker[this.numWorkers];
        this.startX10Runtime();
    }

    public void startWorkers(ActivationFrame mainAF) {
        int i;
        Frame mainFrame = new Frame();
        mainFrame.head = mainAF;
        Closure initClosure = new Closure(mainFrame);
        for (i = 1; i < this.numWorkers; ++i) {
            this.allWorkers[i] = new Worker(i, this, null);
            this.allWorkers[i].start();
        }
        this.allWorkers[0] = new Worker(0, this, initClosure);
        this.allWorkers[0].run();
        System.out.println("Running with " + this.numWorkers + " workers");
        for (i = 1; i < this.numWorkers; ++i) {
            try {
                this.allWorkers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                --i;
            }
        }
        this.stopRuntime();
        if (Configuration.EXECUTION_STATS) {
            this.dumpStatistics();
        }
    }

    private void startX10Runtime() {
        x10.runtime.Configuration.NUMBER_OF_LOCAL_PLACES = 1;
        x10.lang.Runtime.runtime = new DefaultRuntime_c();
        x10.lang.Runtime.factory = x10.lang.Runtime.runtime.getFactory();
        x10.lang.Runtime.runtime.prepareForBoot();
    }

    private void stopRuntime() {
        x10.lang.Runtime.runtime.shutdown();
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public Worker getWorker(int i) {
        return this.allWorkers[i];
    }

    public int getStealCounts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sum += this.allWorkers[i].getNumSteals();
        }
        return sum;
    }

    public int getStealAttempts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sum += this.allWorkers[i].getNumStealAttempts();
        }
        return sum;
    }

    private void dumpStatistics() {
        int sumSteals = 0;
        int sumStealAttempts = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sumSteals += this.allWorkers[i].getNumSteals();
            sumStealAttempts += this.allWorkers[i].getNumStealAttempts();
        }
        System.out.println("StealAttempts=" + sumStealAttempts + "\t NumSteals=" + sumSteals);
    }

    static {
        done = false;
    }
}

