/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.seqcallext;

import habanero.runtime.Trace;
import habanero.runtime.seqcallext.ActivationFrame;
import habanero.runtime.seqcallext.Closure;
import habanero.runtime.seqcallext.Deque;
import habanero.runtime.seqcallext.DequeLeak;
import habanero.runtime.seqcallext.DequeReserveBottomLeak;
import habanero.runtime.seqcallext.FinishTreeNode;
import habanero.runtime.seqcallext.Frame;
import habanero.runtime.seqcallext.FrameStolenException;
import habanero.runtime.seqcallext.Runtime;
import java.util.Random;

public class Worker
extends Thread {
    private final int id;
    public int status;
    public static final int STATUS_READYTOGO = 0;
    public static final int STATUS_STEALING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_SUSPENDED = 3;
    private Deque deque;
    private final Runtime runtime;
    private Closure closure;
    private int numSteals = 0;
    private int numStealAttempts = 0;
    private Closure provablyGoodSteal;

    public Worker(int id, Runtime rt, Closure c) {
        this.id = id;
        this.runtime = rt;
        this.closure = c;
        this.deque = rt.reserveBottom ? new DequeReserveBottomLeak() : new DequeLeak();
    }

    public void run() {
        Random rand = new Random(System.currentTimeMillis() + (long)this.id);
        Closure c = this.closure;
        int victimId = this.id;
        int numWorkers = this.runtime.getNumWorkers();
        while (!Runtime.done) {
            Trace.line(1, this + " begins stealing");
            if (c == null) {
                this.status = 1;
            }
            Worker victim = null;
            while (c == null && !Runtime.done) {
                do {
                    if ((victimId = (int)(rand.nextDouble() * (double)numWorkers)) == this.id) continue;
                    victim = this.runtime.getWorker(victimId);
                } while (victim == null);
                c = super.steal();
            }
            Trace.line(1, this + " steals " + c + " from " + victim);
            if (Runtime.done) break;
            this.status = 0;
            c = this.startWork(c);
        }
    }

    private Closure startWork(Closure c) {
        Trace.line(1, this + " starts working on " + c);
        this.closure = c;
        this.provablyGoodSteal = null;
        this.status = 2;
        c.head.executeSlow(this);
        this.closureTerminating();
        return this.provablyGoodSteal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closureTerminating() {
        if (this.status != 3) {
            FinishTreeNode finish;
            if (this.closure.getCurrentFinishScope() == null) {
                Runtime.done = true;
                return;
            }
            FinishTreeNode finishTreeNode = finish = this.closure.getCurrentFinishScope();
            synchronized (finishTreeNode) {
                if (finish.decNumLiveChildren() == 0) {
                    this.provablyGoodSteal = finish.getSuspendedClosure();
                }
            }
            Trace.line(1, this + " is terminated because the parant frame is stolen. parent finish = " + finish + " p.g.s = " + this.provablyGoodSteal);
        } else {
            Trace.line(1, this + " is Suspended");
            assert (this.provablyGoodSteal == null);
        }
    }

    private Closure steal() {
        Object o = this.deque.steal();
        ++this.numStealAttempts;
        if (o == Deque.Empty || o == Deque.Abort) {
            return null;
        }
        ++this.numSteals;
        Closure c = (Closure)o;
        return c;
    }

    public void startFinish() {
        FinishTreeNode newFinish;
        Closure c = this.closure;
        c.finish = newFinish = new FinishTreeNode(c.finish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopFinishSlow() {
        Closure c = this.closure;
        FinishTreeNode finish = c.finish;
        FinishTreeNode parent = finish.getParent();
        c.setCurrentFinishScope(parent);
        FinishTreeNode finishTreeNode = finish;
        synchronized (finishTreeNode) {
            if (finish.getNumLiveChildren() > 0) {
                this.status = 3;
                finish.setSuspendedClosure(c);
                Trace.line(1, this + " hangs closure " + c + " on " + finish);
                return false;
            }
        }
        Trace.line(1, this + " passes finish" + finish + ".");
        return true;
    }

    public void stopFinishFast() {
        Closure c = this.closure;
        c.finish = c.finish.getParent();
    }

    public void pushFrame() {
        Frame f = this.closure.getFrame();
        assert (f != null);
        f.head = this.closure.head;
        f.finish = this.closure.finish;
        this.closure.head = null;
        this.deque.pushBottom(f);
    }

    public Frame popFrame() {
        Frame f = (Frame)this.deque.popBottom();
        if (f == null) {
            return null;
        }
        this.closure.head = f.head;
        return f;
    }

    public boolean checkStolen() {
        return this.deque.isEmpty();
    }

    public void popFrameOrAbort() throws FrameStolenException {
        Frame f = (Frame)this.deque.popBottom();
        if (f == null) {
            throw new FrameStolenException();
        }
        this.closure.head = f.head;
    }

    public boolean checkActivationFrameStolen() {
        return this.closure.head == null;
    }

    public void beginMethod(ActivationFrame af) {
        Frame f = new Frame(this.closure.getCurrentFinishScope());
        af.next = this.closure.head;
        this.closure.head = af;
        this.closure.setFrame(f);
    }

    public void endMethodFast() {
        this.closure.head = this.closure.head.next;
    }

    public void endMethodSlow() {
        this.closure.head = this.closure.head.next;
        if (this.closure.head != null) {
            this.closure.head.executeSlow(this);
        }
    }

    public void endMethodSlow(Object retObject) {
        this.closure.head = this.closure.head.next;
        if (this.closure.head != null) {
            if (retObject != null) {
                this.closure.head.setReturnResult(retObject);
            }
            this.closure.head.executeSlow(this);
        } else assert (retObject == null);
    }

    public int getNumSteals() {
        return this.numSteals;
    }

    public int getNumStealAttempts() {
        return this.numStealAttempts;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public ActivationFrame getCurrentActivationFrame() {
        return this.closure.head;
    }

    public String toString() {
        return "Worker " + this.id;
    }
}

