/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.seqcallext.example;

import habanero.runtime.Trace;
import habanero.runtime.seqcallext.ActivationFrame;
import habanero.runtime.seqcallext.Runtime;
import habanero.runtime.seqcallext.Worker;

public class Fib {
    public static final int[] fibsol = new int[]{0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368, 75025, 121393, 196418, 317811, 514229, 832040, 1346269, 2178309, 3524578, 5702887, 0x8CCCC9, 14930352, 24157817, 39088169, 63245986, 102334155, 165580141, 267914296, 433494437, 701408733, 1134903170};

    Fib() {
    }

    void fibFast(Worker worker, BoxInteger ret, int n) {
        FibActivationFrame af = new FibActivationFrame(n, ret);
        BoxInteger X = new BoxInteger();
        BoxInteger Y = new BoxInteger();
        if (n < 2) {
            ret.v = n;
            return;
        }
        worker.beginMethod(af);
        worker.startFinish();
        af.X = X;
        af.pc = 1;
        worker.pushFrame();
        this.fibFast(worker, X, n - 1);
        if (worker.popFrame() == null) {
            return;
        }
        af.pc = 2;
        af.Y = Y;
        worker.pushFrame();
        this.fibFast(worker, Y, n - 2);
        if (worker.popFrame() == null) {
            return;
        }
        worker.stopFinishFast();
        ret.v = X.v + Y.v;
        assert (ret.v == fibsol[n]);
        worker.endMethodFast();
    }

    void fibSlow(Worker worker) {
        FibActivationFrame af = (FibActivationFrame)worker.getCurrentActivationFrame();
        Trace.line(1, worker + " starts slow version with frame = " + af);
        switch (af.pc) {
            case 1: {
                BoxInteger Y = new BoxInteger();
                af.pc = 2;
                af.Y = Y;
                worker.pushFrame();
                this.fibFast(worker, Y, af.n - 2);
                if (worker.popFrame() == null) {
                    return;
                }
            }
            case 2: {
                af.pc = 3;
                if (!worker.stopFinishSlow()) {
                    return;
                }
            }
            case 3: {
                ((FibActivationFrame)af).res.v = ((FibActivationFrame)af).Y.v + ((FibActivationFrame)af).X.v;
                if (((FibActivationFrame)af).res.v != fibsol[af.n]) {
                    Trace.line(1, worker + " ERROR: res=" + ((FibActivationFrame)af).res.v + "X=" + ((FibActivationFrame)af).X.v + " Y=" + ((FibActivationFrame)af).Y.v + ",frame=" + af);
                }
                worker.endMethodSlow();
            }
        }
    }

    static void mainSlow(Worker worker) {
        MainActivationFrame af = (MainActivationFrame)worker.getCurrentActivationFrame();
        switch (af.pc) {
            case 0: {
                if (af.args.length != 1) {
                    System.err.println("Usage: Fib <n>\n");
                    System.exit(0);
                }
                af.n = Integer.parseInt(af.args[0]);
                worker.startFinish();
                BoxInteger ret = new BoxInteger();
                af.pc = 1;
                af.ret = ret;
                af.fibObject = new Fib();
                worker.pushFrame();
                af.fibObject.fibFast(worker, af.ret, af.n);
                if (worker.popFrame() == null) {
                    return;
                }
            }
            case 1: {
                af.pc = 2;
                if (!worker.stopFinishSlow()) {
                    return;
                }
            }
            case 2: {
                System.out.println(((MainActivationFrame)af).ret.v + " " + fibsol[af.n] + " " + (((MainActivationFrame)af).ret.v == fibsol[af.n] ? "SUCCESS" : "FAILURE"));
                worker.endMethodSlow();
            }
        }
    }

    public static void main(String[] argv) {
        int numproc = 0;
        if (argv.length >= 2 && argv[0].equals("--nproc")) {
            try {
                numproc = Integer.parseInt(argv[1]);
                String[] restargs = new String[argv.length - 2];
                System.arraycopy(argv, 2, restargs, 0, restargs.length);
                argv = restargs;
            }
            catch (NumberFormatException e) {
                numproc = 1;
            }
        } else {
            numproc = 1;
        }
        Runtime r = new Runtime(numproc, false);
        MainActivationFrame af = new MainActivationFrame(argv);
        af.pc = 0;
        r.startWorkers(af);
    }

    private static class MainActivationFrame
    extends ActivationFrame {
        private String[] args;
        private int n;
        private Fib fibObject;
        private BoxInteger ret;

        public MainActivationFrame(String[] args) {
            this.args = args;
        }

        public void executeSlow(Worker worker) {
            Fib.mainSlow(worker);
        }

        protected void setReturnResult(Object v) {
        }
    }

    static class BoxInteger {
        public int v;

        BoxInteger() {
        }

        public String toString() {
            return this.v + "";
        }
    }

    private class FibActivationFrame
    extends ActivationFrame {
        private int n;
        private BoxInteger X;
        private BoxInteger Y;
        private BoxInteger res;

        public FibActivationFrame(int n, BoxInteger res) {
            this.n = n;
            this.res = res;
        }

        public void executeSlow(Worker worker) {
            Fib.this.fibSlow(worker);
        }

        public String toString() {
            return "FibFrame(pc=" + this.pc + ",n=" + this.n + ",X=" + this.X + ",Y=" + this.Y + ",R=" + this.res + ") hash=" + this.hashCode();
        }

        protected void setReturnResult(Object v) {
        }
    }
}

