/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.seqcallext.example;

import habanero.runtime.seqcallext.ActivationFrame;
import habanero.runtime.seqcallext.Runtime;
import habanero.runtime.seqcallext.Worker;

public final class FibWfMix {
    public static final int[] fibsol = new int[]{0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144, 233, 377, 610, 987, 1597, 2584, 4181, 6765, 10946, 17711, 28657, 46368, 75025, 121393, 196418, 317811, 514229, 832040, 1346269, 2178309, 3524578, 5702887, 0x8CCCC9, 14930352, 24157817, 39088169, 63245986, 102334155, 165580141, 267914296, 433494437, 701408733, 1134903170};

    private static void FibFast(Worker worker, BoxInteger res, int n) {
        BoxInteger y;
        BoxInteger x;
        if (n < 2) {
            res.v = n;
            return;
        }
        FibActivationFrame fibAf = new FibActivationFrame(res, n);
        worker.beginMethod(fibAf);
        worker.startFinish();
        fibAf.x = x = new BoxInteger();
        fibAf.pc = 1;
        worker.pushFrame();
        FibWfMix.FibFast(worker, x, n - 1);
        if (worker.popFrame() == null) {
            return;
        }
        fibAf.y = y = new BoxInteger();
        fibAf.pc = 2;
        FibWfMix.FibFast(worker, y, n - 2);
        if (worker.checkActivationFrameStolen()) {
            return;
        }
        worker.stopFinishFast();
        res.v = x.v + y.v;
        worker.endMethodFast();
    }

    private static void FibSlow(Worker worker, FibActivationFrame af) {
        BoxInteger res = af.res;
        int n = af.n;
        BoxInteger x = af.x;
        BoxInteger y = af.y;
        switch (af.pc) {
            case 1: {
                af.y = y = new BoxInteger();
                af.pc = 2;
                FibWfMix.FibFast(worker, y, n - 2);
                if (worker.checkActivationFrameStolen()) {
                    return;
                }
            }
            case 2: {
                af.pc = 3;
                if (!worker.stopFinishSlow()) {
                    return;
                }
            }
            case 3: {
                res.v = x.v + y.v;
                assert (res.v == fibsol[n]);
                worker.endMethodSlow();
            }
        }
    }

    private static void mainSlow(Worker worker, MainActivationFrame mainAf) {
        int n = mainAf.n;
        int ans = mainAf.ans;
        String[] args = mainAf.args;
        switch (mainAf.pc) {
            case 0: {
                n = Integer.parseInt(args[0]);
                mainAf.pc = 1;
                mainAf.n = n;
                ans = FibWfMix.DoFast(worker, n);
                if (worker.checkActivationFrameStolen()) {
                    return;
                }
            }
            case 1: {
                System.out.println("Fib(" + n + ") = " + ans + " " + (ans == fibsol[n] ? "OK" : "FAILURE"));
                worker.endMethodSlow();
            }
        }
    }

    private static int DoFast(Worker worker, int n) {
        BoxInteger ret;
        DoActivationFrame doCf = new DoActivationFrame(n);
        worker.beginMethod(doCf);
        doCf.ret = ret = new BoxInteger();
        doCf.pc = 1;
        FibWfMix.FibFast(worker, ret, n);
        if (worker.checkActivationFrameStolen()) {
            return -1;
        }
        worker.endMethodFast();
        return ret.v;
    }

    private static void DoSlow(Worker worker, DoActivationFrame doCf) {
        int n = doCf.n;
        BoxInteger ret = doCf.ret;
        switch (doCf.pc) {
            case 1: {
                worker.endMethodSlow(ret.v);
            }
        }
    }

    public static void main(String[] args) {
        int numproc = 0;
        if (args.length >= 2 && args[0].equals("--nproc")) {
            try {
                numproc = Integer.parseInt(args[1]);
                String[] restargs = new String[args.length - 2];
                System.arraycopy(args, 2, restargs, 0, restargs.length);
                args = restargs;
            }
            catch (NumberFormatException e) {
                numproc = 1;
            }
        } else {
            numproc = 2;
        }
        Runtime r = new Runtime(numproc, false);
        MainActivationFrame af = new MainActivationFrame(args);
        af.pc = 0;
        r.startWorkers(af);
    }

    public static final class MainActivationFrame
    extends ActivationFrame {
        String[] args;
        int ans;
        int n;

        public MainActivationFrame(String[] args) {
            this.args = args;
        }

        public void executeSlow(Worker worker) {
            FibWfMix.mainSlow(worker, this);
        }

        public void setReturnResult(Object v) {
            switch (this.pc) {
                case 1: {
                    this.ans = (Integer)v;
                    return;
                }
            }
            assert (false);
        }

        public String toString() {
            return "MainAf[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class DoActivationFrame
    extends ActivationFrame {
        int n;
        Object retObject;
        BoxInteger ret;

        public DoActivationFrame(int n) {
            this.n = n;
        }

        public void executeSlow(Worker worker) {
            FibWfMix.DoSlow(worker, this);
        }

        public void setReturnResult(Object v) {
            assert (v == null);
        }

        public String toString() {
            return "DoAF[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class FibActivationFrame
    extends ActivationFrame {
        public BoxInteger res;
        public int n;
        public BoxInteger x;
        public BoxInteger y;

        FibActivationFrame(BoxInteger res, int n) {
            this.res = res;
            this.n = n;
        }

        public void executeSlow(Worker worker) {
            FibWfMix.FibSlow(worker, this);
        }

        public void setReturnResult(Object v) {
        }

        public String toString() {
            return "FibAF[n=" + this.n + " pc=" + this.pc + "]";
        }
    }

    public static final class BoxInteger {
        public int v;
    }
}

