/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.seqcallext.example;

import habanero.runtime.seqcallext.ActivationFrame;
import habanero.runtime.seqcallext.Runtime;
import habanero.runtime.seqcallext.Worker;
import java.util.LinkedList;

public class QueensAll {
    public static final int[] queenssol = new int[]{0, 1, 0, 0, 2, 10, 4, 40, 92, 352, 724, 2680, 14200, 73712, 365596, 2279184, 14772512};
    private final int n;

    public QueensAll(int n) {
        this.n = n;
    }

    void nqueensFast(int[] config, Worker worker, BoxInteger ret) {
        int row = config.length;
        int q = 0;
        boolean attacked = false;
        int i = 0;
        int p = 0;
        int[] nconfig = null;
        boolean k = false;
        if (row >= this.n) {
            ret.v = 1;
            return;
        }
        QActivationFrame frame = new QActivationFrame(config, ret, row);
        worker.beginMethod(frame);
        LinkedList<BoxInteger> retValues = new LinkedList<BoxInteger>();
        worker.startFinish();
        frame.pc = 1;
        frame.retValues = retValues;
        for (q = 0; q < this.n; ++q) {
            attacked = false;
            for (i = 0; i < row && !attacked; ++i) {
                p = config[i];
                attacked = q == p || q == p - (row - i) || q == p + (row - i);
            }
            if (attacked) continue;
            nconfig = new int[row + 1];
            System.arraycopy(config, 0, nconfig, 0, row);
            nconfig[row] = q;
            BoxInteger res = new BoxInteger();
            retValues.add(res);
            frame.q = q;
            worker.pushFrame();
            this.nqueensFast(nconfig, worker, res);
            if (worker.popFrame() != null) continue;
            return;
        }
        worker.stopFinishFast();
        ret.v = 0;
        for (i = 0; i < retValues.size(); ++i) {
            ret.v += ((BoxInteger)retValues.get((int)i)).v;
        }
        worker.endMethodFast();
    }

    void nqueensSlow(Worker worker, QActivationFrame af) {
        LinkedList<BoxInteger> retValues = af.retValues;
        switch (af.pc) {
            case 1: {
                int i;
                int row = af.row;
                int[] config = af.config;
                int q = af.q;
                ++q;
                while (q < this.n) {
                    boolean attacked = false;
                    for (i = 0; i < row && !attacked; ++i) {
                        int p = config[i];
                        attacked = q == p || q == p - (row - i) || q == p + (row - i);
                    }
                    if (!attacked) {
                        int[] nconfig = new int[row + 1];
                        for (int k = 0; k < row; ++k) {
                            nconfig[k] = config[k];
                        }
                        nconfig[row] = q;
                        BoxInteger res = new BoxInteger();
                        retValues.add(res);
                        af.q = q;
                        worker.pushFrame();
                        this.nqueensFast(nconfig, worker, res);
                        if (worker.popFrame() == null) {
                            return;
                        }
                    }
                    ++q;
                }
                af.pc = 2;
                if (!worker.stopFinishSlow()) {
                    return;
                }
            }
            case 2: {
                int i;
                BoxInteger ret = af.ret;
                ret.v = 0;
                for (i = 0; i < retValues.size(); ++i) {
                    ret.v += retValues.get((int)i).v;
                }
                worker.endMethodSlow();
            }
        }
    }

    static void mainSlow(Worker worker) {
        MainActivationFrame af = (MainActivationFrame)worker.getCurrentActivationFrame();
        switch (af.pc) {
            case 0: {
                if (af.args.length != 1) {
                    System.err.println("Usage: QueensAll <n>\n");
                    System.exit(0);
                }
                af.n = Integer.parseInt(af.args[0]);
                worker.startFinish();
                BoxInteger ret = new BoxInteger();
                af.pc = 1;
                af.ret = ret;
                af.queenObject = new QueensAll(af.n);
                worker.pushFrame();
                af.queenObject.nqueensFast(new int[0], worker, af.ret);
                if (worker.popFrame() == null) {
                    return;
                }
            }
            case 1: {
                af.pc = 2;
                if (!worker.stopFinishSlow()) {
                    return;
                }
            }
            case 2: {
                System.out.println(((MainActivationFrame)af).ret.v + " " + queenssol[af.n] + " " + (((MainActivationFrame)af).ret.v == queenssol[af.n] ? "SUCCESS" : "FAILURE"));
            }
        }
    }

    public static void main(String[] argv) {
        int numproc = 0;
        if (argv.length >= 2 && argv[0].equals("--nproc")) {
            try {
                numproc = Integer.parseInt(argv[1]);
                String[] restargs = new String[argv.length - 2];
                System.arraycopy(argv, 2, restargs, 0, restargs.length);
                argv = restargs;
            }
            catch (NumberFormatException e) {
                numproc = 1;
            }
        } else {
            numproc = 1;
        }
        Runtime r = new Runtime(numproc, false);
        MainActivationFrame af = new MainActivationFrame(argv);
        af.pc = 0;
        r.startWorkers(af);
    }

    private static class MainActivationFrame
    extends ActivationFrame {
        private String[] args;
        private int n;
        private QueensAll queenObject;
        private BoxInteger ret;

        public MainActivationFrame(String[] args) {
            this.args = args;
        }

        public void executeSlow(Worker worker) {
            QueensAll.mainSlow(worker);
        }

        protected void setReturnResult(Object v) {
        }
    }

    private class QActivationFrame
    extends ActivationFrame {
        public int row;
        public int q;
        public int[] config;
        public BoxInteger ret;
        public LinkedList<BoxInteger> retValues;

        public QActivationFrame(int[] config, BoxInteger ret, int row) {
            this.config = config;
            this.ret = ret;
            this.row = row;
        }

        public void executeSlow(Worker worker) {
            QueensAll.this.nqueensSlow(worker, this);
        }

        protected void setReturnResult(Object v) {
        }
    }

    public static class BoxInteger {
        public int v;
    }
}

