/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.ws;

import habanero.runtime.ws.Continuation;
import java.util.concurrent.atomic.AtomicInteger;

public class FinishTreeNode {
    private static AtomicInteger ctr = new AtomicInteger(0);
    private int id;
    public static final FinishTreeNode mainFinishScope = new FinishTreeNode(null);
    public AtomicInteger numActiveWorkers = new AtomicInteger(1);
    public FinishTreeNode parent;
    public Continuation suspendedContinuation = null;
    private AtomicInteger[] localWorkloadCounter = null;

    FinishTreeNode(FinishTreeNode parent) {
        this.parent = parent;
        this.id = ctr.incrementAndGet();
    }

    public AtomicInteger getLocalWorkloadCounter(int index) {
        if (this.localWorkloadCounter == null) {
            this.localWorkloadCounter = new AtomicInteger[16];
        }
        if (this.localWorkloadCounter[index] == null) {
            this.localWorkloadCounter[index] = new AtomicInteger(0);
        }
        return this.localWorkloadCounter[index];
    }

    public String toString() {
        String s = this == mainFinishScope ? "MainFinish#" : "Finish#";
        s = s + this.id;
        s = s + "(active:" + this.numActiveWorkers + ", local:[";
        for (int i = 0; i < 1; ++i) {
            s = this.localWorkloadCounter == null ? s + "0," : (this.localWorkloadCounter[i * 16] == null ? s + "0," : s + this.localWorkloadCounter[i * 16].get() + ",");
        }
        s = s + "])";
        return s;
    }

    public boolean hasCompletedLocalWork(int index) {
        if (this.localWorkloadCounter == null) {
            return true;
        }
        if (this.localWorkloadCounter[index] == null) {
            return true;
        }
        return this.localWorkloadCounter[index].get() == 0;
    }

    public void reset() {
        this.numActiveWorkers.set(1);
        if (this.localWorkloadCounter != null) {
            for (int i = 0; i < this.localWorkloadCounter.length; ++i) {
                if (this.localWorkloadCounter[i] == null) continue;
                this.localWorkloadCounter[i].set(0);
            }
        }
        this.suspendedContinuation = null;
    }
}

