/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.ws;

import habanero.runtime.Configuration;
import habanero.runtime.ws.FinishTreeNode;
import habanero.runtime.ws.JobWrapper;
import habanero.runtime.ws.Worker;
import x10.runtime.DefaultRuntime_c;

public class Runtime {
    private final Worker[] allWorkers;
    private final int numWorkers;
    public static volatile boolean done = false;
    final boolean reserveBottom;
    private long intervalTimer;

    public Runtime(int numWorkers, boolean reserveBottom) {
        assert (numWorkers > 0);
        Configuration.NUMBER_OF_WORKERS = numWorkers;
        this.reserveBottom = reserveBottom;
        this.numWorkers = numWorkers;
        this.allWorkers = new Worker[numWorkers];
        done = false;
        this.startX10Runtime();
    }

    public Runtime(boolean reserveBottom) {
        this(Configuration.NUMBER_OF_WORKERS, reserveBottom);
    }

    public void startWorkers(JobWrapper mainJobWrapper) {
        int i;
        assert (mainJobWrapper.finish == FinishTreeNode.mainFinishScope);
        this.allWorkers[0] = new Worker(0, this, mainJobWrapper);
        for (i = 1; i < this.numWorkers; ++i) {
            this.allWorkers[i] = new Worker(i, this, null);
        }
        for (i = 0; i < this.numWorkers; ++i) {
            this.allWorkers[i].start();
        }
        for (i = 0; i < this.numWorkers; ++i) {
            try {
                this.allWorkers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                --i;
            }
        }
        this.stopRuntime();
        if (Configuration.EXECUTION_STATS) {
            this.dumpStatistics();
        }
    }

    private void startX10Runtime() {
        x10.runtime.Configuration.NUMBER_OF_LOCAL_PLACES = 1;
        x10.lang.Runtime.runtime = new DefaultRuntime_c();
        x10.lang.Runtime.factory = x10.lang.Runtime.runtime.getFactory();
        x10.lang.Runtime.runtime.prepareForBoot();
    }

    private void stopRuntime() {
        x10.lang.Runtime.runtime.shutdown();
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public Worker getWorker(int i) {
        return this.allWorkers[i];
    }

    public int getStealCounts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sum += this.allWorkers[i].getNumSteals();
        }
        return sum;
    }

    public int getStealAttempts() {
        assert (done);
        int sum = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sum += this.allWorkers[i].getNumStealAttempts();
        }
        return sum;
    }

    public void dumpStatistics() {
        int sumSteals = 0;
        int sumStealAttempts = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            sumSteals += this.allWorkers[i].getNumSteals();
            sumStealAttempts += this.allWorkers[i].getNumStealAttempts();
        }
        System.out.println("StealAttempts=" + sumStealAttempts + "\t NumSteals=" + sumSteals);
    }

    public void startTimer() {
        this.intervalTimer = -System.nanoTime();
    }

    public void stopTimer() {
        this.intervalTimer += System.nanoTime();
    }

    public long getTimer() {
        return this.intervalTimer;
    }
}

