/*
 * Decompiled with CFR 0.152.
 */
package habanero.runtime.ws;

import habanero.runtime.ws.Continuation;
import habanero.runtime.ws.ContinuationFrame;
import habanero.runtime.ws.Deque;
import habanero.runtime.ws.FinishTreeNode;
import habanero.runtime.ws.HelpFirstDeque;
import habanero.runtime.ws.JobWrapper;
import habanero.runtime.ws.Runtime;
import habanero.runtime.ws.VictimAbortException;
import habanero.runtime.ws.WorkFirstDeque;
import habanero.runtime.ws.WorkFirstDequeReserveBottom;
import habanero.runtime.ws.WorkerExecutable;
import java.util.Random;

public class Worker
extends Thread {
    private final int id;
    final int index;
    int status;
    public static final int STATUS_READYTOGO = 0;
    public static final int STATUS_STEALING = 1;
    public static final int STATUS_RUNNING = 2;
    public static final int STATUS_SUSPENDED = 3;
    private WorkFirstDeque wfDeque;
    private HelpFirstDeque hfDeque;
    private final Runtime runtime;
    Continuation continuation;
    private int numSteals = 0;
    private int numStealAttempts = 0;
    private JobWrapper nextLocalWork;
    public FinishTreeNode callerFinishScope;
    private WorkerExecutable startup;

    Worker(int id, Runtime rt, WorkerExecutable c) {
        this.id = id;
        this.index = id * 16;
        this.runtime = rt;
        this.startup = c;
        this.continuation = null;
        this.wfDeque = rt.reserveBottom ? new WorkFirstDequeReserveBottom(this) : new WorkFirstDeque(this);
        this.hfDeque = new HelpFirstDeque(this);
    }

    public void run() {
        Random rand = new Random(System.currentTimeMillis() + (long)this.id);
        WorkerExecutable c = this.startup;
        int victimId = this.id;
        int numWorkers = this.runtime.getNumWorkers();
        Worker victim = null;
        while (!Runtime.done) {
            if (c == null) {
                this.status = 1;
            }
            while (c == null && !Runtime.done) {
                do {
                    if ((victimId = (int)(rand.nextDouble() * (double)numWorkers)) == this.id) continue;
                    victim = this.runtime.getWorker(victimId);
                } while (victim == null);
                c = super.steal();
            }
            if (Runtime.done) break;
            this.status = 0;
            c = this.startWork(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerExecutable startWork(WorkerExecutable c) {
        this.nextLocalWork = null;
        this.status = 2;
        this.callerFinishScope = c.getFinishScope();
        this.continuation = null;
        assert (this.callerFinishScope != null);
        try {
            c.execute(this);
        }
        catch (VictimAbortException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            c = this.closureTerminating();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerExecutable closureTerminating() {
        JobWrapper job;
        if (Runtime.done) {
            return null;
        }
        if (this.status != 3) {
            FinishTreeNode finish = this.continuation == null ? this.callerFinishScope : this.continuation.finish;
            if (finish == null) {
                Runtime.done = true;
                return null;
            }
            job = this.getMoreLocalWork(finish);
            if (job == null) {
                finish.numActiveWorkers.decrementAndGet();
                if (finish.hasCompletedLocalWork(this.index) && finish.numActiveWorkers.get() == 0) {
                    FinishTreeNode finishTreeNode = finish;
                    synchronized (finishTreeNode) {
                        if (finish.parent == null) {
                            Runtime.done = true;
                            return null;
                        }
                        if (finish.numActiveWorkers.compareAndSet(0, -1)) {
                            Continuation c = finish.suspendedContinuation;
                            if (c == null) {
                                System.out.println(finish);
                            }
                            assert (c != null);
                            return c;
                        }
                    }
                }
            } else {
                this.nextLocalWork = job;
            }
        }
        if (this.nextLocalWork == null) {
            Object o = this.hfDeque.popBottom();
            if (o == Deque.Empty) {
                return null;
            }
            this.nextLocalWork = (JobWrapper)o;
        }
        job = this.nextLocalWork;
        job.finish.getLocalWorkloadCounter(this.index).decrementAndGet();
        return job;
    }

    private WorkerExecutable steal() {
        ++this.numStealAttempts;
        Object o = this.wfDeque.steal();
        if (o == Deque.Empty || o == Deque.StealAbort) {
            o = this.hfDeque.steal();
            if (o == Deque.Empty || o == Deque.StealAbort) {
                return null;
            }
            ++this.numSteals;
            return (JobWrapper)o;
        }
        ++this.numSteals;
        return (Continuation)o;
    }

    public void startFinish() {
        this.continuation.finish = new FinishTreeNode(this.continuation.finish);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopFinishSlow() {
        Continuation c = this.continuation;
        FinishTreeNode finish = c.finish;
        c.finish = finish.parent;
        finish.suspendedContinuation = c;
        assert (c != null);
        JobWrapper f = this.getMoreLocalWork(finish);
        if (f == null) {
            finish.numActiveWorkers.decrementAndGet();
            if (finish.hasCompletedLocalWork(this.index) && finish.numActiveWorkers.get() == 0) {
                FinishTreeNode finishTreeNode = finish;
                synchronized (finishTreeNode) {
                    if (finish.numActiveWorkers.compareAndSet(0, -1)) {
                        return true;
                    }
                }
            }
        }
        this.status = 3;
        this.nextLocalWork = f;
        return false;
    }

    public void stopFinishFast() {
        this.continuation.finish = this.continuation.finish.parent;
    }

    public void submitJob(JobWrapper job) {
        assert (job.finish != null);
        job.finish.getLocalWorkloadCounter(this.index).incrementAndGet();
        this.hfDeque.pushBottom(job);
    }

    public void pushContinuationAndPrepare() {
        Continuation c = this.continuation;
        this.callerFinishScope = c.finish;
        this.continuation = null;
        this.wfDeque.pushBottom(c);
    }

    public void popContinuationAndCheck() throws VictimAbortException {
        Object o = this.wfDeque.popBottom();
        if (o == Deque.Empty) {
            throw new VictimAbortException();
        }
        this.continuation = (Continuation)o;
    }

    public void checkAndAbort() throws VictimAbortException {
        if (this.wfDeque.isEmpty()) {
            throw new VictimAbortException();
        }
    }

    public int getNumSteals() {
        return this.numSteals;
    }

    public int getNumStealAttempts() {
        return this.numStealAttempts;
    }

    public String toString() {
        return "Worker " + this.id;
    }

    public void registerContinuationFrame(ContinuationFrame cf) {
        cf.next = this.continuation.head;
        this.continuation.head = cf;
    }

    public void endMethodFast() {
        this.continuation.head = this.continuation.head.next;
    }

    public void endMethodSlow(Object retObject) throws VictimAbortException {
        this.continuation.head = this.continuation.head.next;
        if (this.continuation.head != null) {
            if (retObject != null) {
                this.continuation.head.setReturnResult(retObject);
            }
            this.continuation.execute(this);
        } else assert (retObject == null);
    }

    public void endMethodSlow() throws VictimAbortException {
        this.endMethodSlow(null);
    }

    private JobWrapper getMoreLocalWork(FinishTreeNode finish) {
        Object o = this.hfDeque.popBottom();
        if (o == Deque.Empty) {
            return null;
        }
        JobWrapper f = (JobWrapper)o;
        if (f.finish != finish) {
            this.hfDeque.pushBottom(o);
            return null;
        }
        return f;
    }

    public int getLocalQueueSize() {
        return this.hfDeque.bottom - this.hfDeque.top.get();
    }
}

