/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.Body;
import soot.JastAddJ.Constant;
import soot.JastAddJ.Expr;
import soot.JastAddJ.IntegerLiteral;
import soot.JastAddJ.LongLiteral;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Unary;
import soot.Value;
import soot.jimple.Jimple;

public class MinusExpr
extends Unary
implements Cloneable {
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    public MinusExpr clone() throws CloneNotSupportedException {
        MinusExpr node = (MinusExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public MinusExpr copy() {
        try {
            MinusExpr node = this.clone();
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Error: Could not clone node of type " + this.getClass().getName() + "!");
            return null;
        }
    }

    public MinusExpr fullCopy() {
        MinusExpr res = this.copy();
        for (int i = 0; i < this.getNumChildNoTransform(); ++i) {
            Object node = this.getChildNoTransform(i);
            if (node != null) {
                node = ((ASTNode)node).fullCopy();
            }
            res.setChild(node, i);
        }
        return res;
    }

    public void typeCheck() {
        if (!this.getOperand().type().isNumericType()) {
            this.error("unary minus only operates on numeric types");
        }
    }

    public Value eval(Body b) {
        return Jimple.v().newNegExpr(this.asImmediate(b, this.getOperand().eval(b)));
    }

    public MinusExpr() {
    }

    public MinusExpr(Expr p0) {
        this.setChild(p0, 0);
    }

    protected int numChildren() {
        return 1;
    }

    public boolean mayHaveRewrite() {
        return true;
    }

    public void setOperand(Expr node) {
        this.setChild(node, 0);
    }

    public Expr getOperand() {
        return (Expr)this.getChild(0);
    }

    public Expr getOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    public Constant constant() {
        Constant constant_value = this.constant_compute();
        return constant_value;
    }

    private Constant constant_compute() {
        return this.type().minus(this.getOperand().constant());
    }

    public boolean isConstant() {
        boolean isConstant_value = this.isConstant_compute();
        return isConstant_value;
    }

    private boolean isConstant_compute() {
        return this.getOperand().isConstant();
    }

    public String printPreOp() {
        String printPreOp_value = this.printPreOp_compute();
        return printPreOp_value;
    }

    private String printPreOp_compute() {
        return "-";
    }

    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        int num = boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        return this.getOperand().type().unaryNumericPromotion();
    }

    public ASTNode rewriteTo() {
        if (this.getOperand() instanceof IntegerLiteral && ((IntegerLiteral)this.getOperand()).isDecimal() && this.getOperand().isPositive()) {
            ++duringConstantExpression;
            IntegerLiteral result = this.rewriteRule0();
            --duringConstantExpression;
            return result;
        }
        if (this.getOperand() instanceof LongLiteral && ((LongLiteral)this.getOperand()).isDecimal() && this.getOperand().isPositive()) {
            ++duringConstantExpression;
            LongLiteral result = this.rewriteRule1();
            --duringConstantExpression;
            return result;
        }
        return super.rewriteTo();
    }

    private IntegerLiteral rewriteRule0() {
        return new IntegerLiteral("-" + ((IntegerLiteral)this.getOperand()).getLITERAL());
    }

    private LongLiteral rewriteRule1() {
        return new LongLiteral("-" + ((LongLiteral)this.getOperand()).getLITERAL());
    }
}

