/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import soot.jbco.gui.JBCOViewer;

public class RunnerThread
implements Runnable {
    public boolean stopRun = false;
    private JBCOViewer viewer = null;
    private String[] cmdarray = null;
    private String wdir = null;

    public RunnerThread(String[] argv, JBCOViewer jv, String workingdir) {
        this.cmdarray = argv;
        this.viewer = jv;
        this.wdir = workingdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        JMenuItem jMenuItem = this.viewer.newFileMenuItem;
        synchronized (jMenuItem) {
            this.viewer.newFileMenuItem.setEnabled(false);
        }
        jMenuItem = this.viewer.openFileMenuItem;
        synchronized (jMenuItem) {
            this.viewer.openFileMenuItem.setEnabled(true);
        }
        try {
            File f = null;
            if (this.wdir != null) {
                f = new File(this.wdir);
                if (!f.exists()) throw new Exception(f + " does not appear to be a proper working directory.");
                if (!f.isDirectory()) {
                    throw new Exception(f + " does not appear to be a proper working directory.");
                }
            }
            Process p = Runtime.getRuntime().exec(this.cmdarray, null, f);
            BufferedReader br_in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader br_er = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String line_in = "";
            try {
                while ((line_in = br_in.readLine()) != null || (line_in = br_er.readLine()) != null) {
                    JTextArea jTextArea;
                    if (this.stopRun) {
                        p.destroy();
                        jTextArea = this.viewer.TextAreaOutput;
                        synchronized (jTextArea) {
                            this.viewer.TextAreaOutput.append("\n\n*** Execution STOPPED ***");
                            this.viewer.TextAreaOutput.setCaretPosition(this.viewer.TextAreaOutput.getDocument().getLength());
                            break;
                        }
                    }
                    jTextArea = this.viewer.TextAreaOutput;
                    synchronized (jTextArea) {
                        JScrollBar vbar;
                        boolean autoScroll = false;
                        JScrollBar jScrollBar = vbar = this.viewer.jScrollPane1.getVerticalScrollBar();
                        synchronized (jScrollBar) {
                            autoScroll = vbar.getValue() + vbar.getVisibleAmount() == vbar.getMaximum();
                        }
                        this.viewer.TextAreaOutput.append("\n" + line_in);
                        if (autoScroll) {
                            this.viewer.TextAreaOutput.setCaretPosition(this.viewer.TextAreaOutput.getDocument().getLength());
                        }
                    }
                }
            }
            catch (Exception exc) {
                throw exc;
            }
            finally {
                br_in.close();
                br_er.close();
            }
        }
        catch (Exception exc) {
            JTextArea jTextArea = this.viewer.TextAreaOutput;
            synchronized (jTextArea) {
                this.viewer.TextAreaOutput.append("\n\n" + exc.toString());
                this.viewer.TextAreaOutput.setCaretPosition(this.viewer.TextAreaOutput.getDocument().getLength());
            }
        }
        jMenuItem = this.viewer.newFileMenuItem;
        synchronized (jMenuItem) {
            this.viewer.newFileMenuItem.setEnabled(true);
        }
        jMenuItem = this.viewer.openFileMenuItem;
        synchronized (jMenuItem) {
            this.viewer.openFileMenuItem.setEnabled(false);
            return;
        }
    }
}

