/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import soot.G;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.spark.solver.Propagator;
import soot.jimple.spark.solver.TopoSorter;
import soot.util.HashMultiMap;
import soot.util.LargeNumberedMap;
import soot.util.MultiMap;
import soot.util.queue.QueueReader;

public final class PropAlias
extends Propagator {
    protected final Set<VarNode> varNodeWorkList = new TreeSet<VarNode>();
    protected Set<VarNode> aliasWorkList;
    protected Set<FieldRefNode> fieldRefWorkList = new HashSet<FieldRefNode>();
    protected Set<FieldRefNode> outFieldRefWorkList = new HashSet<FieldRefNode>();
    protected PAG pag;
    protected MultiMap fieldToBase = new HashMultiMap();
    protected MultiMap aliasEdges = new HashMultiMap();
    protected LargeNumberedMap loadSets;
    protected OnFlyCallGraph ofcg;

    public PropAlias(PAG pag) {
        this.pag = pag;
        this.loadSets = new LargeNumberedMap(pag.getFieldRefNodeNumberer());
    }

    public final void propagate() {
        this.ofcg = this.pag.getOnFlyCallGraph();
        new TopoSorter(this.pag, false).sort();
        for (Object object : this.pag.loadSources()) {
            FieldRefNode fieldRefNode = (FieldRefNode)object;
            this.fieldToBase.put(fieldRefNode.getField(), fieldRefNode.getBase());
        }
        for (Object object : this.pag.storeInvSources()) {
            FieldRefNode fieldRefNode = (FieldRefNode)object;
            this.fieldToBase.put(fieldRefNode.getField(), fieldRefNode.getBase());
        }
        for (Object object : this.pag.allocSources()) {
            this.handleAllocNode((AllocNode)object);
        }
        boolean verbose = this.pag.getOpts().verbose();
        do {
            if (verbose) {
                G.v().out.println("Worklist has " + this.varNodeWorkList.size() + " nodes.");
            }
            this.aliasWorkList = new HashSet<VarNode>();
            while (!this.varNodeWorkList.isEmpty()) {
                VarNode src = this.varNodeWorkList.iterator().next();
                this.varNodeWorkList.remove(src);
                this.aliasWorkList.add(src);
                this.handleVarNode(src);
            }
            if (verbose) {
                G.v().out.println("Now handling field references");
            }
            for (VarNode varNode : this.aliasWorkList) {
                for (FieldRefNode srcFr : varNode.getAllFieldRefs()) {
                    SparkField field = srcFr.getField();
                    for (VarNode dst : this.fieldToBase.get(field)) {
                        if (!varNode.getP2Set().hasNonEmptyIntersection(dst.getP2Set())) continue;
                        FieldRefNode dstFr = dst.dot(field);
                        this.aliasEdges.put(srcFr, dstFr);
                        this.aliasEdges.put(dstFr, srcFr);
                        this.fieldRefWorkList.add(srcFr);
                        this.fieldRefWorkList.add(dstFr);
                        if (this.makeP2Set(dstFr).addAll(srcFr.getP2Set().getOldSet(), null)) {
                            this.outFieldRefWorkList.add(dstFr);
                        }
                        if (!this.makeP2Set(srcFr).addAll(dstFr.getP2Set().getOldSet(), null)) continue;
                        this.outFieldRefWorkList.add(srcFr);
                    }
                }
            }
            for (FieldRefNode fieldRefNode : this.fieldRefWorkList) {
                for (FieldRefNode dst : this.aliasEdges.get(fieldRefNode)) {
                    if (!this.makeP2Set(dst).addAll(fieldRefNode.getP2Set().getNewSet(), null)) continue;
                    this.outFieldRefWorkList.add(dst);
                }
                fieldRefNode.getP2Set().flushNew();
            }
            this.fieldRefWorkList = new HashSet<FieldRefNode>();
            for (FieldRefNode fieldRefNode : this.outFieldRefWorkList) {
                Node[] targets;
                PointsToSetInternal set = this.getP2Set(fieldRefNode).getNewSet();
                if (set.isEmpty()) continue;
                for (Node element0 : targets = this.pag.loadLookup(fieldRefNode)) {
                    VarNode target = (VarNode)element0;
                    if (!target.makeP2Set().addAll(set, null)) continue;
                    this.addToWorklist(target);
                }
                this.getP2Set(fieldRefNode).flushNew();
            }
            this.outFieldRefWorkList = new HashSet<FieldRefNode>();
        } while (!this.varNodeWorkList.isEmpty());
    }

    protected final boolean handleAllocNode(AllocNode src) {
        Node[] targets;
        boolean ret = false;
        for (Node element : targets = this.pag.allocLookup(src)) {
            if (!element.makeP2Set().add(src)) continue;
            this.addToWorklist((VarNode)element);
            ret = true;
        }
        return ret;
    }

    protected final boolean handleVarNode(VarNode src) {
        Node[] storeTargets;
        Node[] simpleTargets;
        boolean ret = false;
        if (src.getReplacement() != src) {
            throw new RuntimeException("Got bad node " + src + " with rep " + src.getReplacement());
        }
        PointsToSetInternal newP2Set = src.getP2Set().getNewSet();
        if (newP2Set.isEmpty()) {
            return false;
        }
        if (this.ofcg != null) {
            QueueReader addedEdges = this.pag.edgeReader();
            this.ofcg.updatedNode(src);
            this.ofcg.build();
            while (addedEdges.hasNext()) {
                VarNode edgeTgt;
                Node edgeSrc;
                Node addedSrc = (Node)addedEdges.next();
                Node addedTgt = (Node)addedEdges.next();
                ret = true;
                if (addedSrc instanceof VarNode) {
                    if (addedTgt instanceof VarNode) {
                        edgeSrc = (VarNode)addedSrc;
                        edgeTgt = (VarNode)addedTgt;
                        if (edgeTgt.makeP2Set().addAll(edgeSrc.getP2Set(), null)) {
                            this.addToWorklist(edgeTgt);
                        }
                    }
                } else if (addedSrc instanceof AllocNode) {
                    edgeSrc = (AllocNode)addedSrc;
                    edgeTgt = (VarNode)addedTgt;
                    if (edgeTgt.makeP2Set().add(edgeSrc)) {
                        this.addToWorklist(edgeTgt);
                    }
                }
                FieldRefNode frn = null;
                if (addedSrc instanceof FieldRefNode) {
                    frn = (FieldRefNode)addedSrc;
                }
                if (addedTgt instanceof FieldRefNode) {
                    frn = (FieldRefNode)addedTgt;
                }
                if (frn == null) continue;
                VarNode base = frn.getBase();
                if (!this.fieldToBase.put(frn.getField(), base)) continue;
                this.aliasWorkList.add(base);
            }
        }
        for (Node element : simpleTargets = this.pag.simpleLookup(src)) {
            if (!element.makeP2Set().addAll(newP2Set, null)) continue;
            this.addToWorklist((VarNode)element);
            ret = true;
        }
        for (Node element : storeTargets = this.pag.storeLookup(src)) {
            FieldRefNode fr = (FieldRefNode)element;
            if (!fr.makeP2Set().addAll(newP2Set, null)) continue;
            this.fieldRefWorkList.add(fr);
            ret = true;
        }
        src.getP2Set().flushNew();
        return ret;
    }

    protected final PointsToSetInternal makeP2Set(FieldRefNode n) {
        PointsToSetInternal ret = (PointsToSetInternal)this.loadSets.get(n);
        if (ret == null) {
            ret = this.pag.getSetFactory().newSet(null, this.pag);
            this.loadSets.put(n, ret);
        }
        return ret;
    }

    protected final PointsToSetInternal getP2Set(FieldRefNode n) {
        PointsToSetInternal ret = (PointsToSetInternal)this.loadSets.get(n);
        if (ret == null) {
            return EmptyPointsToSet.v();
        }
        return ret;
    }

    private boolean addToWorklist(VarNode n) {
        if (n.getReplacement() != n) {
            throw new RuntimeException("Adding bad node " + n + " with rep " + n.getReplacement());
        }
        return this.varNodeWorkList.add(n);
    }
}

