/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ILexStream;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import lpg.runtime.RuleAction;
import lpg.runtime.UnavailableParserInformationException;

public class LexParser {
    private boolean taking_actions = false;
    private int START_STATE;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private int START_SYMBOL;
    private int NUM_RULES;
    private ILexStream tokStream;
    private ParseTable prs;
    private RuleAction ra;
    private IntTuple action = null;
    private int STACK_INCREMENT = 1024;
    private int stateStackTop;
    private int stackLength = 0;
    private int[] stack;
    private int[] locationStack;
    private int lastToken;
    private int currentAction;
    private int curtok;
    private int starttok;
    private int current_kind;

    public void reset(ILexStream tokStream) {
        this.tokStream = tokStream;
    }

    public void reset(ILexStream tokStream, ParseTable prs, RuleAction ra) {
        this.tokStream = tokStream;
        this.prs = prs;
        this.ra = ra;
        this.START_STATE = prs.getStartState();
        this.LA_STATE_OFFSET = prs.getLaStateOffset();
        this.EOFT_SYMBOL = prs.getEoftSymbol();
        this.ACCEPT_ACTION = prs.getAcceptAction();
        this.ERROR_ACTION = prs.getErrorAction();
        this.START_SYMBOL = prs.getStartSymbol();
        this.NUM_RULES = prs.getNumRules();
    }

    public LexParser() {
    }

    public LexParser(ILexStream tokStream, ParseTable prs, RuleAction ra) {
        this.reset(tokStream, prs, ra);
    }

    private void reallocateStacks() {
        int old_stack_length = this.stack == null ? 0 : this.stackLength;
        this.stackLength += this.STACK_INCREMENT;
        if (old_stack_length == 0) {
            this.stack = new int[this.stackLength];
            this.locationStack = new int[this.stackLength];
        } else {
            this.stack = new int[this.stackLength];
            System.arraycopy(this.stack, 0, this.stack, 0, old_stack_length);
            this.locationStack = new int[this.stackLength];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, old_stack_length);
        }
    }

    public final int getFirstToken(int i) {
        return this.getToken(i);
    }

    public final int getLastToken(int i) {
        if (this.taking_actions) {
            return i >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokStream.getPrevious(this.getToken(i + 1));
        }
        throw new UnavailableParserInformationException();
    }

    public final int getCurrentRule() {
        if (this.taking_actions) {
            return this.currentAction;
        }
        throw new UnavailableParserInformationException();
    }

    public final int getToken(int i) {
        if (this.taking_actions) {
            return this.locationStack[this.stateStackTop + (i - 1)];
        }
        throw new UnavailableParserInformationException();
    }

    public final void setSym1(int i) {
    }

    public final int getSym(int i) {
        return this.getLastToken(i);
    }

    public final int getFirstToken() {
        return this.starttok;
    }

    public final int getLastToken() {
        return this.lastToken;
    }

    public void resetTokenStream(int i) {
        this.tokStream.reset(i > this.tokStream.getStreamLength() ? this.tokStream.getStreamLength() : i);
        this.curtok = this.tokStream.getToken();
        this.current_kind = this.tokStream.getKind(this.curtok);
        if (this.stack == null) {
            this.reallocateStacks();
        }
        if (this.action == null) {
            this.action = new IntTuple(1024);
        }
    }

    public void parseCharacters(int start_offset, int end_offset) {
        this.parseCharacters(null, start_offset, end_offset);
    }

    public void parseCharacters(Monitor monitor, int start_offset, int end_offset) {
        this.resetTokenStream(start_offset);
        while (this.curtok <= end_offset) {
            if (monitor != null && monitor.isCancelled()) {
                return;
            }
            this.lexNextToken(end_offset);
        }
    }

    public void parseCharacters() {
        this.parseCharacters(null);
    }

    public void parseCharacters(Monitor monitor) {
        this.taking_actions = true;
        this.resetTokenStream(0);
        this.lastToken = this.tokStream.getPrevious(this.curtok);
        block2: while (this.current_kind != this.EOFT_SYMBOL) {
            if (monitor != null && monitor.isCancelled()) break;
            this.stateStackTop = -1;
            this.currentAction = this.START_STATE;
            this.starttok = this.curtok;
            block3: while (true) {
                try {
                    this.stack[++this.stateStackTop] = this.currentAction;
                }
                catch (IndexOutOfBoundsException e) {
                    this.reallocateStacks();
                    this.stack[this.stateStackTop] = this.currentAction;
                }
                this.locationStack[this.stateStackTop] = this.curtok;
                this.currentAction = this.tAction(this.currentAction, this.current_kind);
                if (this.currentAction <= this.NUM_RULES) {
                    --this.stateStackTop;
                    do {
                        this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                        this.ra.ruleAction(this.currentAction);
                        int lhs_symbol = this.prs.lhs(this.currentAction);
                        if (lhs_symbol == this.START_SYMBOL) {
                            if (this.starttok != this.curtok) continue block2;
                            break block3;
                        }
                        this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                    } while (this.currentAction <= this.NUM_RULES);
                    continue;
                }
                if (this.currentAction > this.ERROR_ACTION) {
                    this.lastToken = this.curtok;
                    this.curtok = this.tokStream.getToken();
                    this.current_kind = this.tokStream.getKind(this.curtok);
                    this.currentAction -= this.ERROR_ACTION;
                    do {
                        this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                        this.ra.ruleAction(this.currentAction);
                        int lhs_symbol = this.prs.lhs(this.currentAction);
                        if (lhs_symbol == this.START_SYMBOL) continue block2;
                        this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                    } while (this.currentAction <= this.NUM_RULES);
                    continue;
                }
                if (this.currentAction >= this.ACCEPT_ACTION) break;
                this.lastToken = this.curtok;
                this.curtok = this.tokStream.getToken();
                this.current_kind = this.tokStream.getKind(this.curtok);
            }
            if (this.starttok == this.curtok) {
                if (this.current_kind == this.EOFT_SYMBOL) break;
                this.tokStream.reportLexicalError(this.starttok, this.curtok);
                this.lastToken = this.curtok;
                this.curtok = this.tokStream.getToken();
                this.current_kind = this.tokStream.getKind(this.curtok);
                continue;
            }
            this.tokStream.reportLexicalError(this.starttok, this.lastToken);
        }
        this.taking_actions = false;
    }

    private int lookahead(int act, int token) {
        return (act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(token))) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.getNext(token)) : act;
    }

    private int tAction(int act, int sym) {
        return (act = this.prs.tAction(act, sym)) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.peek()) : act;
    }

    public boolean scanNextToken() {
        return this.lexNextToken(this.tokStream.getStreamLength());
    }

    public boolean scanNextToken(int start_offset) {
        this.resetTokenStream(start_offset);
        return this.lexNextToken(this.tokStream.getStreamLength());
    }

    private boolean lexNextToken(int end_offset) {
        this.taking_actions = false;
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        this.starttok = this.curtok;
        this.action.reset();
        block2: while (true) {
            try {
                this.stack[++this.stateStackTop] = this.currentAction;
            }
            catch (IndexOutOfBoundsException e) {
                this.reallocateStacks();
                this.stack[this.stateStackTop] = this.currentAction;
            }
            this.currentAction = this.tAction(this.currentAction, this.current_kind);
            this.action.add(this.currentAction);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                do {
                    int lhs_symbol;
                    if ((lhs_symbol = this.prs.lhs(this.currentAction)) == this.START_SYMBOL) {
                        if (this.starttok == this.curtok) break block2;
                        this.parseActions();
                        return true;
                    }
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                } while (this.currentAction <= this.NUM_RULES);
                continue;
            }
            if (this.currentAction > this.ERROR_ACTION) {
                this.curtok = this.tokStream.getToken();
                if (this.curtok > end_offset) {
                    this.curtok = this.tokStream.getStreamLength();
                }
                this.current_kind = this.tokStream.getKind(this.curtok);
                this.currentAction -= this.ERROR_ACTION;
                do {
                    int lhs_symbol;
                    if ((lhs_symbol = this.prs.lhs(this.currentAction)) == this.START_SYMBOL) {
                        this.parseActions();
                        return true;
                    }
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                } while (this.currentAction <= this.NUM_RULES);
                continue;
            }
            if (this.currentAction >= this.ACCEPT_ACTION) break;
            this.curtok = this.tokStream.getToken();
            if (this.curtok > end_offset) {
                this.curtok = this.tokStream.getStreamLength();
            }
            this.current_kind = this.tokStream.getKind(this.curtok);
        }
        if (this.starttok == this.curtok) {
            if (this.current_kind == this.EOFT_SYMBOL) {
                this.action = null;
                return false;
            }
            this.lastToken = this.curtok;
            this.tokStream.reportLexicalError(this.starttok, this.curtok);
            this.curtok = this.tokStream.getToken();
            if (this.curtok > end_offset) {
                this.curtok = this.tokStream.getStreamLength();
            }
            this.current_kind = this.tokStream.getKind(this.curtok);
        } else {
            this.lastToken = this.tokStream.getPrevious(this.curtok);
            this.tokStream.reportLexicalError(this.starttok, this.lastToken);
        }
        return true;
    }

    private void parseActions() {
        this.taking_actions = true;
        this.curtok = this.starttok;
        this.lastToken = this.tokStream.getPrevious(this.curtok);
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        int i = 0;
        block0: while (i < this.action.size()) {
            int lhs_symbol;
            this.stack[++this.stateStackTop] = this.currentAction;
            this.locationStack[this.stateStackTop] = this.curtok;
            this.currentAction = this.action.get(i);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                do {
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.ra.ruleAction(this.currentAction);
                    lhs_symbol = this.prs.lhs(this.currentAction);
                    if (lhs_symbol == this.START_SYMBOL) break block0;
                    this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                } while (this.currentAction <= this.NUM_RULES);
            } else {
                this.lastToken = this.curtok;
                this.curtok = this.tokStream.getNext(this.curtok);
                if (this.currentAction > this.ERROR_ACTION) {
                    this.current_kind = this.tokStream.getKind(this.curtok);
                    this.currentAction -= this.ERROR_ACTION;
                    do {
                        this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                        this.ra.ruleAction(this.currentAction);
                        lhs_symbol = this.prs.lhs(this.currentAction);
                        if (lhs_symbol == this.START_SYMBOL) break block0;
                        this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], lhs_symbol);
                    } while (this.currentAction <= this.NUM_RULES);
                }
            }
            ++i;
        }
        this.taking_actions = false;
    }
}

