/* This file was generated by SableCC (http://www.sablecc.org/). */

package soot.jimple.parser.lexer;

import java.io.*;
import java.util.*;
import soot.jimple.parser.node.*;

public class Lexer
{
    protected Token token;
    protected State state = State.INITIAL;

    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();

    protected void filter() throws LexerException, IOException
    {
    }

    public Lexer(PushbackReader in)
    {
        this.in = in;

        if(gotoTable == null)
        {
            try
            {
                DataInputStream s = new DataInputStream(
                    new BufferedInputStream(
                    Lexer.class.getResourceAsStream("lexer.dat")));

                // read gotoTable
                int length = s.readInt();
                gotoTable = new int[length][][][];
                for(int i = 0; i < gotoTable.length; i++)
                {
                    length = s.readInt();
                    gotoTable[i] = new int[length][][];
                    for(int j = 0; j < gotoTable[i].length; j++)
                    {
                        length = s.readInt();
                        gotoTable[i][j] = new int[length][3];
                        for(int k = 0; k < gotoTable[i][j].length; k++)
                        {
                            for(int l = 0; l < 3; l++)
                            {
                                gotoTable[i][j][k][l] = s.readInt();
                            }
                        }
                    }
                }

                // read accept
                length = s.readInt();
                accept = new int[length][];
                for(int i = 0; i < accept.length; i++)
                {
                    length = s.readInt();
                    accept[i] = new int[length];
                    for(int j = 0; j < accept[i].length; j++)
                    {
                        accept[i][j] = s.readInt();
                    }
                }

                s.close();
            }
            catch(Exception e)
            {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        return token;
    }

    public Token next() throws LexerException, IOException
    {
        while(token == null)
        {
            token = getToken();
            filter();
        }

        Token result = token;
        token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException
    {
        int dfa_state = 0;

        int start_pos = pos;
        int start_line = line;

        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;

        int[][][] gotoTable = this.gotoTable[state.id()];
        int[] accept = this.accept[state.id()];
        text.setLength(0);

        while(true)
        {
            int c = getChar();

            if(c != -1)
            {
                switch(c)
                {
                case 10:
                    if(cr)
                    {
                        cr = false;
                    }
                    else
                    {
                        line++;
                        pos = 0;
                    }
                    break;
                case 13:
                    line++;
                    pos = 0;
                    cr = true;
                    break;
                default:
                    pos++;
                    cr = false;
                    break;
                };

                text.append((char) c);

                do
                {
                    int oldState = (dfa_state < -1) ? (-2 -dfa_state) : dfa_state;

                    dfa_state = -1;

                    int[][] tmp1 =  gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;

                    while(low <= high)
                    {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];

                        if(c < tmp2[0])
                        {
                            high = middle - 1;
                        }
                        else if(c > tmp2[1])
                        {
                            low = middle + 1;
                        }
                        else
                        {
                            dfa_state = tmp2[2];
                            break;
                        }
                    }
                }while(dfa_state < -1);
            }
            else
            {
                dfa_state = -1;
            }

            if(dfa_state >= 0)
            {
                if(accept[dfa_state] != -1)
                {
                    accept_state = dfa_state;
                    accept_token = accept[dfa_state];
                    accept_length = text.length();
                    accept_pos = pos;
                    accept_line = line;
                }
            }
            else
            {
                if(accept_state != -1)
                {
                    switch(accept_token)
                    {
                    case 0:
                        {
                            Token token = new0(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 1:
                        {
                            Token token = new1(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 2:
                        {
                            Token token = new2(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 3:
                        {
                            Token token = new3(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 4:
                        {
                            Token token = new4(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 5:
                        {
                            Token token = new5(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 6:
                        {
                            Token token = new6(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 7:
                        {
                            Token token = new7(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 8:
                        {
                            Token token = new8(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 9:
                        {
                            Token token = new9(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 10:
                        {
                            Token token = new10(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 11:
                        {
                            Token token = new11(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 12:
                        {
                            Token token = new12(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 13:
                        {
                            Token token = new13(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 14:
                        {
                            Token token = new14(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 15:
                        {
                            Token token = new15(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 16:
                        {
                            Token token = new16(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 17:
                        {
                            Token token = new17(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 18:
                        {
                            Token token = new18(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 19:
                        {
                            Token token = new19(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 20:
                        {
                            Token token = new20(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 21:
                        {
                            Token token = new21(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 22:
                        {
                            Token token = new22(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 23:
                        {
                            Token token = new23(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 24:
                        {
                            Token token = new24(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 25:
                        {
                            Token token = new25(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 26:
                        {
                            Token token = new26(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 27:
                        {
                            Token token = new27(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 28:
                        {
                            Token token = new28(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 29:
                        {
                            Token token = new29(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 30:
                        {
                            Token token = new30(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 31:
                        {
                            Token token = new31(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 32:
                        {
                            Token token = new32(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 33:
                        {
                            Token token = new33(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 34:
                        {
                            Token token = new34(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 35:
                        {
                            Token token = new35(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 36:
                        {
                            Token token = new36(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 37:
                        {
                            Token token = new37(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 38:
                        {
                            Token token = new38(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 39:
                        {
                            Token token = new39(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 40:
                        {
                            Token token = new40(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 41:
                        {
                            Token token = new41(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 42:
                        {
                            Token token = new42(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 43:
                        {
                            Token token = new43(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 44:
                        {
                            Token token = new44(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 45:
                        {
                            Token token = new45(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 46:
                        {
                            Token token = new46(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 47:
                        {
                            Token token = new47(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 48:
                        {
                            Token token = new48(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 49:
                        {
                            Token token = new49(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 50:
                        {
                            Token token = new50(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 51:
                        {
                            Token token = new51(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 52:
                        {
                            Token token = new52(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 53:
                        {
                            Token token = new53(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 54:
                        {
                            Token token = new54(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 55:
                        {
                            Token token = new55(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 56:
                        {
                            Token token = new56(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 57:
                        {
                            Token token = new57(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 58:
                        {
                            Token token = new58(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 59:
                        {
                            Token token = new59(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 60:
                        {
                            Token token = new60(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 61:
                        {
                            Token token = new61(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 62:
                        {
                            Token token = new62(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 63:
                        {
                            Token token = new63(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 64:
                        {
                            Token token = new64(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 65:
                        {
                            Token token = new65(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 66:
                        {
                            Token token = new66(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 67:
                        {
                            Token token = new67(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 68:
                        {
                            Token token = new68(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 69:
                        {
                            Token token = new69(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 70:
                        {
                            Token token = new70(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 71:
                        {
                            Token token = new71(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 72:
                        {
                            Token token = new72(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 73:
                        {
                            Token token = new73(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 74:
                        {
                            Token token = new74(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 75:
                        {
                            Token token = new75(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 76:
                        {
                            Token token = new76(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 77:
                        {
                            Token token = new77(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 78:
                        {
                            Token token = new78(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 79:
                        {
                            Token token = new79(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 80:
                        {
                            Token token = new80(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 81:
                        {
                            Token token = new81(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 82:
                        {
                            Token token = new82(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 83:
                        {
                            Token token = new83(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 84:
                        {
                            Token token = new84(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 85:
                        {
                            Token token = new85(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 86:
                        {
                            Token token = new86(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 87:
                        {
                            Token token = new87(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 88:
                        {
                            Token token = new88(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 89:
                        {
                            Token token = new89(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 90:
                        {
                            Token token = new90(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 91:
                        {
                            Token token = new91(
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 92:
                        {
                            Token token = new92(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 93:
                        {
                            Token token = new93(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 94:
                        {
                            Token token = new94(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 95:
                        {
                            Token token = new95(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 96:
                        {
                            Token token = new96(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 97:
                        {
                            Token token = new97(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 98:
                        {
                            Token token = new98(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    case 99:
                        {
                            Token token = new99(
                                getText(accept_length),
                                start_line + 1,
                                start_pos + 1);
                            pushBack(accept_length);
                            pos = accept_pos;
                            line = accept_line;
                            return token;
                        }
                    }
                }
                else
                {
                    if(text.length() > 0)
                    {
                        throw new LexerException(
                            "[" + (start_line + 1) + "," + (start_pos + 1) + "]" +
                            " Unknown token: " + text);
                    }
                    else
                    {
                        EOF token = new EOF(
                            start_line + 1,
                            start_pos + 1);
                        return token;
                    }
                }
            }
        }
    }

    Token new0(String text, int line, int pos) { return new TIgnored(text, line, pos); }
    Token new1(int line, int pos) { return new TAbstract(line, pos); }
    Token new2(int line, int pos) { return new TFinal(line, pos); }
    Token new3(int line, int pos) { return new TNative(line, pos); }
    Token new4(int line, int pos) { return new TPublic(line, pos); }
    Token new5(int line, int pos) { return new TProtected(line, pos); }
    Token new6(int line, int pos) { return new TPrivate(line, pos); }
    Token new7(int line, int pos) { return new TStatic(line, pos); }
    Token new8(int line, int pos) { return new TSynchronized(line, pos); }
    Token new9(int line, int pos) { return new TTransient(line, pos); }
    Token new10(int line, int pos) { return new TVolatile(line, pos); }
    Token new11(int line, int pos) { return new TStrictfp(line, pos); }
    Token new12(int line, int pos) { return new TEnum(line, pos); }
    Token new13(int line, int pos) { return new TAnnotation(line, pos); }
    Token new14(int line, int pos) { return new TClass(line, pos); }
    Token new15(int line, int pos) { return new TInterface(line, pos); }
    Token new16(int line, int pos) { return new TVoid(line, pos); }
    Token new17(int line, int pos) { return new TBoolean(line, pos); }
    Token new18(int line, int pos) { return new TByte(line, pos); }
    Token new19(int line, int pos) { return new TShort(line, pos); }
    Token new20(int line, int pos) { return new TChar(line, pos); }
    Token new21(int line, int pos) { return new TInt(line, pos); }
    Token new22(int line, int pos) { return new TLong(line, pos); }
    Token new23(int line, int pos) { return new TFloat(line, pos); }
    Token new24(int line, int pos) { return new TDouble(line, pos); }
    Token new25(int line, int pos) { return new TNullType(line, pos); }
    Token new26(int line, int pos) { return new TUnknown(line, pos); }
    Token new27(int line, int pos) { return new TExtends(line, pos); }
    Token new28(int line, int pos) { return new TImplements(line, pos); }
    Token new29(int line, int pos) { return new TBreakpoint(line, pos); }
    Token new30(int line, int pos) { return new TCase(line, pos); }
    Token new31(int line, int pos) { return new TCatch(line, pos); }
    Token new32(int line, int pos) { return new TCmp(line, pos); }
    Token new33(int line, int pos) { return new TCmpg(line, pos); }
    Token new34(int line, int pos) { return new TCmpl(line, pos); }
    Token new35(int line, int pos) { return new TDefault(line, pos); }
    Token new36(int line, int pos) { return new TEntermonitor(line, pos); }
    Token new37(int line, int pos) { return new TExitmonitor(line, pos); }
    Token new38(int line, int pos) { return new TGoto(line, pos); }
    Token new39(int line, int pos) { return new TIf(line, pos); }
    Token new40(int line, int pos) { return new TInstanceof(line, pos); }
    Token new41(int line, int pos) { return new TInterfaceinvoke(line, pos); }
    Token new42(int line, int pos) { return new TLengthof(line, pos); }
    Token new43(int line, int pos) { return new TLookupswitch(line, pos); }
    Token new44(int line, int pos) { return new TNeg(line, pos); }
    Token new45(int line, int pos) { return new TNew(line, pos); }
    Token new46(int line, int pos) { return new TNewarray(line, pos); }
    Token new47(int line, int pos) { return new TNewmultiarray(line, pos); }
    Token new48(int line, int pos) { return new TNop(line, pos); }
    Token new49(int line, int pos) { return new TRet(line, pos); }
    Token new50(int line, int pos) { return new TReturn(line, pos); }
    Token new51(int line, int pos) { return new TSpecialinvoke(line, pos); }
    Token new52(int line, int pos) { return new TStaticinvoke(line, pos); }
    Token new53(int line, int pos) { return new TTableswitch(line, pos); }
    Token new54(int line, int pos) { return new TThrow(line, pos); }
    Token new55(int line, int pos) { return new TThrows(line, pos); }
    Token new56(int line, int pos) { return new TVirtualinvoke(line, pos); }
    Token new57(int line, int pos) { return new TNull(line, pos); }
    Token new58(int line, int pos) { return new TFrom(line, pos); }
    Token new59(int line, int pos) { return new TTo(line, pos); }
    Token new60(int line, int pos) { return new TWith(line, pos); }
    Token new61(int line, int pos) { return new TCls(line, pos); }
    Token new62(int line, int pos) { return new TComma(line, pos); }
    Token new63(int line, int pos) { return new TLBrace(line, pos); }
    Token new64(int line, int pos) { return new TRBrace(line, pos); }
    Token new65(int line, int pos) { return new TSemicolon(line, pos); }
    Token new66(int line, int pos) { return new TLBracket(line, pos); }
    Token new67(int line, int pos) { return new TRBracket(line, pos); }
    Token new68(int line, int pos) { return new TLParen(line, pos); }
    Token new69(int line, int pos) { return new TRParen(line, pos); }
    Token new70(int line, int pos) { return new TColon(line, pos); }
    Token new71(int line, int pos) { return new TDot(line, pos); }
    Token new72(int line, int pos) { return new TQuote(line, pos); }
    Token new73(int line, int pos) { return new TColonEquals(line, pos); }
    Token new74(int line, int pos) { return new TEquals(line, pos); }
    Token new75(int line, int pos) { return new TAnd(line, pos); }
    Token new76(int line, int pos) { return new TOr(line, pos); }
    Token new77(int line, int pos) { return new TXor(line, pos); }
    Token new78(int line, int pos) { return new TMod(line, pos); }
    Token new79(int line, int pos) { return new TCmpeq(line, pos); }
    Token new80(int line, int pos) { return new TCmpne(line, pos); }
    Token new81(int line, int pos) { return new TCmpgt(line, pos); }
    Token new82(int line, int pos) { return new TCmpge(line, pos); }
    Token new83(int line, int pos) { return new TCmplt(line, pos); }
    Token new84(int line, int pos) { return new TCmple(line, pos); }
    Token new85(int line, int pos) { return new TShl(line, pos); }
    Token new86(int line, int pos) { return new TShr(line, pos); }
    Token new87(int line, int pos) { return new TUshr(line, pos); }
    Token new88(int line, int pos) { return new TPlus(line, pos); }
    Token new89(int line, int pos) { return new TMinus(line, pos); }
    Token new90(int line, int pos) { return new TMult(line, pos); }
    Token new91(int line, int pos) { return new TDiv(line, pos); }
    Token new92(String text, int line, int pos) { return new TFullIdentifier(text, line, pos); }
    Token new93(String text, int line, int pos) { return new TQuotedName(text, line, pos); }
    Token new94(String text, int line, int pos) { return new TIdentifier(text, line, pos); }
    Token new95(String text, int line, int pos) { return new TAtIdentifier(text, line, pos); }
    Token new96(String text, int line, int pos) { return new TBoolConstant(text, line, pos); }
    Token new97(String text, int line, int pos) { return new TIntegerConstant(text, line, pos); }
    Token new98(String text, int line, int pos) { return new TFloatConstant(text, line, pos); }
    Token new99(String text, int line, int pos) { return new TStringConstant(text, line, pos); }

    private int getChar() throws IOException
    {
        if(eof)
        {
            return -1;
        }

        int result = in.read();

        if(result == -1)
        {
            eof = true;
        }

        return result;
    }

    private void pushBack(int acceptLength) throws IOException
    {
        int length = text.length();
        for(int i = length - 1; i >= acceptLength; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException
    {
        String text = token.getText();
        int length = text.length();

        for(int i = length - 1; i >= 0; i--)
        {
            eof = false;

            in.unread(text.charAt(i));
        }

        pos = token.getPos() - 1;
        line = token.getLine() - 1;
    }

    private String getText(int acceptLength)
    {
        StringBuffer s = new StringBuffer(acceptLength);
        for(int i = 0; i < acceptLength; i++)
        {
            s.append(text.charAt(i));
        }

        return s.toString();
    }

    private static int[][][][] gotoTable;
/*  {
        { // INITIAL
            {{9, 9, 1}, {10, 10, 2}, {13, 13, 3}, {32, 32, 4}, {33, 33, 5}, {34, 34, 6}, {35, 35, 7}, {36, 36, 8}, {37, 37, 9}, {38, 38, 10}, {39, 39, 11}, {40, 40, 12}, {41, 41, 13}, {42, 42, 14}, {43, 43, 15}, {44, 44, 16}, {45, 45, 17}, {46, 46, 18}, {47, 47, 19}, {48, 48, 20}, {49, 57, 21}, {58, 58, 22}, {59, 59, 23}, {60, 60, 24}, {61, 61, 25}, {62, 62, 26}, {64, 64, 27}, {65, 90, 28}, {91, 91, 29}, {92, 92, 30}, {93, 93, 31}, {94, 94, 32}, {95, 95, 33}, {97, 97, 34}, {98, 98, 35}, {99, 99, 36}, {100, 100, 37}, {101, 101, 38}, {102, 102, 39}, {103, 103, 40}, {104, 104, 41}, {105, 105, 42}, {106, 107, 41}, {108, 108, 43}, {109, 109, 41}, {110, 110, 44}, {111, 111, 41}, {112, 112, 45}, {113, 113, 41}, {114, 114, 46}, {115, 115, 47}, {116, 116, 48}, {117, 117, 49}, {118, 118, 50}, {119, 119, 51}, {120, 122, 41}, {123, 123, 52}, {124, 124, 53}, {125, 125, 54}, },
            {{9, 32, -2}, {47, 47, 55}, },
            {{9, 47, -3}, },
            {{9, 47, -3}, },
            {{9, 47, -3}, },
            {{61, 61, 56}, },
            {{0, 33, 57}, {34, 34, 58}, {35, 91, 59}, {92, 92, 60}, {93, 127, 61}, },
            {{45, 45, 62}, {73, 73, 63}, {78, 78, 64}, },
            {{36, 36, 65}, {46, 46, 66}, {48, 57, 67}, {65, 90, 68}, {92, 92, 69}, {95, 95, 70}, {97, 122, 71}, },
            {},
            {},
            {{0, 9, 72}, {11, 12, 72}, {14, 38, 72}, {40, 65535, 72}, },
            {},
            {},
            {},
            {},
            {},
            {},
            {},
            {{42, 42, 73}, {47, 47, 74}, },
            {{46, 46, 75}, {48, 55, 76}, {56, 57, 21}, {76, 76, 77}, {88, 88, 78}, {120, 120, 79}, },
            {{46, 46, 75}, {48, 57, 21}, {76, 76, 77}, },
            {{61, 61, 80}, },
            {},
            {{60, 60, 81}, {61, 61, 82}, {99, 99, 83}, {105, 105, 84}, },
            {{61, 61, 85}, },
            {{61, 61, 86}, {62, 62, 87}, },
            {{99, 99, 88}, {112, 112, 89}, {116, 116, 90}, },
            {{36, 122, -10}, },
            {},
            {{32, 32, 91}, {34, 34, 92}, {35, 35, 93}, {39, 39, 94}, {46, 46, 95}, {92, 92, 96}, {98, 98, 97}, {102, 102, 98}, {110, 110, 99}, {114, 114, 100}, {116, 116, 101}, {117, 117, 102}, },
            {},
            {},
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 71}, {98, 98, 103}, {99, 109, 71}, {110, 110, 104}, {111, 122, 71}, },
            {{36, 95, -10}, {97, 110, 71}, {111, 111, 105}, {112, 113, 71}, {114, 114, 106}, {115, 120, 71}, {121, 121, 107}, {122, 122, 71}, },
            {{36, 95, -10}, {97, 97, 108}, {98, 103, 71}, {104, 104, 109}, {105, 107, 71}, {108, 108, 110}, {109, 109, 111}, {110, 122, 71}, },
            {{36, 95, -10}, {97, 100, 71}, {101, 101, 112}, {102, 110, 71}, {111, 111, 113}, {112, 122, 71}, },
            {{36, 95, -10}, {97, 109, 71}, {110, 110, 114}, {111, 119, 71}, {120, 120, 115}, {121, 122, 71}, },
            {{36, 95, -10}, {97, 97, 116}, {98, 104, 71}, {105, 105, 117}, {106, 107, 71}, {108, 108, 118}, {109, 113, 71}, {114, 114, 119}, {115, 122, 71}, },
            {{36, 110, -37}, {111, 111, 120}, {112, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 101, 71}, {102, 102, 121}, {103, 108, 71}, {109, 109, 122}, {110, 110, 123}, {111, 122, 71}, },
            {{36, 100, -39}, {101, 101, 124}, {102, 110, 71}, {111, 111, 125}, {112, 122, 71}, },
            {{36, 95, -10}, {97, 97, 126}, {98, 100, 71}, {101, 101, 127}, {102, 110, 71}, {111, 111, 128}, {112, 116, 71}, {117, 117, 129}, {118, 122, 71}, },
            {{36, 95, -10}, {97, 113, 71}, {114, 114, 130}, {115, 116, 71}, {117, 117, 131}, {118, 122, 71}, },
            {{36, 100, -39}, {101, 101, 132}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 103, 71}, {104, 104, 133}, {105, 111, 71}, {112, 112, 134}, {113, 115, 71}, {116, 116, 135}, {117, 120, 71}, {121, 121, 136}, {122, 122, 71}, },
            {{36, 95, -10}, {97, 97, 137}, {98, 103, 71}, {104, 104, 138}, {105, 110, 71}, {111, 111, 139}, {112, 113, 71}, {114, 114, 140}, {115, 122, 71}, },
            {{36, 109, -40}, {110, 110, 141}, {111, 122, 71}, },
            {{36, 95, -10}, {97, 104, 71}, {105, 105, 142}, {106, 110, 71}, {111, 111, 143}, {112, 122, 71}, },
            {{36, 104, -52}, {105, 105, 144}, {106, 122, 71}, },
            {},
            {},
            {},
            {{42, 47, -21}, },
            {},
            {{0, 127, -8}, },
            {},
            {{0, 127, -8}, },
            {{32, 32, 145}, {34, 34, 146}, {35, 35, 147}, {39, 39, 148}, {46, 46, 149}, {92, 92, 150}, {98, 98, 151}, {102, 102, 152}, {110, 110, 153}, {114, 114, 154}, {116, 116, 155}, {117, 117, 156}, },
            {{0, 127, -8}, },
            {{73, 73, 63}, },
            {{110, 110, 157}, },
            {{97, 97, 158}, },
            {{36, 122, -10}, },
            {{36, 36, 159}, {65, 90, 160}, {92, 92, 161}, {95, 95, 162}, {97, 122, 163}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{32, 32, 164}, {34, 34, 165}, {35, 35, 166}, {39, 39, 167}, {46, 46, 168}, {92, 92, 169}, {98, 98, 170}, {102, 102, 171}, {110, 110, 172}, {114, 114, 173}, {116, 116, 174}, {117, 117, 175}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{0, 38, -13}, {39, 39, 176}, {40, 65535, 72}, },
            {{0, 41, 177}, {42, 42, 178}, {43, 65535, 177}, },
            {{0, 8, 179}, {9, 9, 180}, {10, 10, 2}, {11, 12, 179}, {13, 13, 3}, {14, 31, 179}, {32, 32, 181}, {33, 46, 179}, {47, 47, 182}, {48, 65535, 179}, },
            {{48, 57, 183}, },
            {{46, 76, -22}, },
            {},
            {{48, 57, 184}, {65, 70, 185}, {97, 102, 186}, },
            {{48, 102, -80}, },
            {},
            {},
            {},
            {{108, 108, 187}, },
            {{110, 110, 188}, },
            {},
            {},
            {{62, 62, 189}, },
            {{97, 97, 190}, },
            {{97, 97, 191}, },
            {{104, 104, 192}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{48, 57, 193}, {65, 70, 194}, {97, 102, 195}, },
            {{36, 95, -10}, {97, 114, 71}, {115, 115, 196}, {116, 122, 71}, },
            {{36, 109, -40}, {110, 110, 197}, {111, 122, 71}, },
            {{36, 110, -37}, {111, 111, 198}, {112, 122, 71}, },
            {{36, 100, -39}, {101, 101, 199}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 115, 71}, {116, 116, 200}, {117, 122, 71}, },
            {{36, 114, -105}, {115, 115, 201}, {116, 116, 202}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 97, 203}, {98, 122, 71}, },
            {{36, 95, -10}, {97, 97, 204}, {98, 114, 71}, {115, 115, 205}, {116, 122, 71}, },
            {{36, 95, -10}, {97, 111, 71}, {112, 112, 206}, {113, 122, 71}, },
            {{36, 101, -44}, {102, 102, 207}, {103, 122, 71}, },
            {{36, 95, -10}, {97, 116, 71}, {117, 117, 208}, {118, 122, 71}, },
            {{36, 115, -109}, {116, 116, 209}, {117, 117, 210}, {118, 122, 71}, },
            {{36, 104, -52}, {105, 105, 211}, {106, 115, 71}, {116, 116, 212}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 107, 71}, {108, 108, 213}, {109, 122, 71}, },
            {{36, 109, -40}, {110, 110, 214}, {111, 122, 71}, },
            {{36, 110, -37}, {111, 111, 215}, {112, 122, 71}, },
            {{36, 110, -37}, {111, 111, 216}, {112, 122, 71}, },
            {{36, 115, -109}, {116, 116, 217}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 111, -113}, {112, 112, 218}, {113, 122, 71}, },
            {{36, 114, -105}, {115, 115, 219}, {116, 116, 220}, {117, 122, 71}, },
            {{36, 109, -40}, {110, 110, 221}, {111, 122, 71}, },
            {{36, 109, -40}, {110, 110, 222}, {111, 111, 223}, {112, 122, 71}, },
            {{36, 115, -109}, {116, 116, 224}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 102, 71}, {103, 103, 225}, {104, 118, 71}, {119, 119, 226}, {120, 122, 71}, },
            {{36, 111, -113}, {112, 112, 227}, {113, 122, 71}, },
            {{36, 107, -118}, {108, 108, 228}, {109, 122, 71}, },
            {{36, 104, -52}, {105, 105, 229}, {106, 110, 71}, {111, 111, 230}, {112, 122, 71}, },
            {{36, 97, -36}, {98, 98, 231}, {99, 122, 71}, },
            {{36, 115, -109}, {116, 116, 232}, {117, 122, 71}, },
            {{36, 110, -37}, {111, 111, 233}, {112, 122, 71}, },
            {{36, 100, -39}, {101, 101, 234}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 97, 235}, {98, 113, 71}, {114, 114, 236}, {115, 122, 71}, },
            {{36, 109, -40}, {110, 110, 237}, {111, 122, 71}, },
            {{36, 97, -36}, {98, 98, 238}, {99, 122, 71}, },
            {{36, 113, -47}, {114, 114, 239}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 240}, {98, 116, 71}, {117, 117, 241}, {118, 122, 71}, },
            {{36, 95, -10}, {97, 106, 71}, {107, 107, 242}, {108, 122, 71}, },
            {{36, 113, -47}, {114, 114, 243}, {115, 122, 71}, },
            {{36, 104, -52}, {105, 105, 244}, {106, 107, 71}, {108, 108, 245}, {109, 122, 71}, },
            {{36, 115, -109}, {116, 116, 246}, {117, 122, 71}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{48, 57, 247}, {65, 70, 248}, {97, 102, 249}, },
            {{102, 102, 250}, },
            {{78, 78, 251}, },
            {{36, 36, 252}, {46, 46, 66}, {48, 57, 253}, {65, 90, 254}, {92, 92, 255}, {95, 95, 256}, {97, 122, 257}, },
            {{36, 122, -161}, },
            {{32, 32, 258}, {34, 34, 259}, {35, 35, 260}, {39, 39, 261}, {46, 46, 262}, {92, 92, 263}, {98, 98, 264}, {102, 102, 265}, {110, 110, 266}, {114, 114, 267}, {116, 116, 268}, {117, 117, 269}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{48, 57, 270}, {65, 70, 271}, {97, 102, 272}, },
            {},
            {{0, 65535, -75}, },
            {{0, 41, 273}, {42, 42, 178}, {43, 46, 273}, {47, 47, 274}, {48, 65535, 273}, },
            {{0, 65535, -76}, },
            {{0, 65535, -76}, },
            {{0, 65535, -76}, },
            {{0, 32, -76}, {33, 41, 179}, {42, 42, 275}, {43, 46, 179}, {47, 47, 276}, {48, 65535, 179}, },
            {{48, 57, 183}, {69, 69, 277}, {70, 70, 278}, {101, 101, 279}, {102, 102, 280}, },
            {{48, 70, -80}, {76, 76, 77}, {97, 102, 186}, },
            {{48, 102, -186}, },
            {{48, 102, -186}, },
            {{105, 105, 281}, },
            {{105, 105, 282}, },
            {},
            {{117, 117, 283}, },
            {{114, 114, 284}, },
            {{105, 105, 285}, },
            {{48, 57, 286}, {65, 70, 287}, {97, 102, 288}, },
            {{48, 102, -195}, },
            {{48, 102, -195}, },
            {{36, 115, -109}, {116, 116, 289}, {117, 122, 71}, },
            {{36, 110, -37}, {111, 111, 290}, {112, 122, 71}, },
            {{36, 107, -118}, {108, 108, 291}, {109, 122, 71}, },
            {{36, 95, -10}, {97, 97, 292}, {98, 122, 71}, },
            {{36, 100, -39}, {101, 101, 293}, {102, 122, 71}, },
            {{36, 100, -39}, {101, 101, 294}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 98, 71}, {99, 99, 295}, {100, 122, 71}, },
            {{36, 113, -47}, {114, 114, 296}, {115, 122, 71}, },
            {{36, 114, -105}, {115, 115, 297}, {116, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 102, -129}, {103, 103, 298}, {104, 107, 71}, {108, 108, 299}, {109, 122, 71}, },
            {{36, 95, -10}, {97, 97, 300}, {98, 122, 71}, },
            {{36, 97, -36}, {98, 98, 301}, {99, 122, 71}, },
            {{36, 100, -39}, {101, 101, 302}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 108, 71}, {109, 109, 303}, {110, 122, 71}, },
            {{36, 115, -109}, {116, 116, 304}, {117, 122, 71}, },
            {{36, 100, -39}, {101, 101, 305}, {102, 122, 71}, },
            {{36, 114, -105}, {115, 115, 306}, {116, 122, 71}, },
            {{36, 95, -10}, {97, 97, 307}, {98, 122, 71}, },
            {{36, 95, -10}, {97, 97, 308}, {98, 122, 71}, },
            {{36, 108, -212}, {109, 109, 309}, {110, 122, 71}, },
            {{36, 110, -37}, {111, 111, 310}, {112, 122, 71}, },
            {{36, 107, -118}, {108, 108, 311}, {109, 122, 71}, },
            {{36, 115, -109}, {116, 116, 312}, {117, 122, 71}, },
            {{36, 100, -39}, {101, 101, 313}, {102, 122, 71}, },
            {{36, 102, -129}, {103, 103, 314}, {104, 122, 71}, },
            {{36, 102, -129}, {103, 103, 315}, {104, 122, 71}, },
            {{36, 106, -143}, {107, 107, 316}, {108, 122, 71}, },
            {{36, 104, -52}, {105, 105, 317}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 318}, {98, 108, 71}, {109, 109, 319}, {110, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 107, -118}, {108, 108, 320}, {109, 122, 71}, },
            {{36, 95, -10}, {97, 117, 71}, {118, 118, 321}, {119, 122, 71}, },
            {{36, 115, -109}, {116, 116, 322}, {117, 122, 71}, },
            {{36, 107, -118}, {108, 108, 323}, {109, 122, 71}, },
            {{36, 116, -115}, {117, 117, 324}, {118, 122, 71}, },
            {{36, 113, -47}, {114, 114, 325}, {115, 122, 71}, },
            {{36, 98, -204}, {99, 99, 326}, {100, 122, 71}, },
            {{36, 115, -109}, {116, 116, 327}, {117, 122, 71}, },
            {{36, 104, -52}, {105, 105, 328}, {106, 122, 71}, },
            {{36, 98, -204}, {99, 99, 329}, {100, 122, 71}, },
            {{36, 107, -118}, {108, 108, 330}, {109, 122, 71}, },
            {{36, 110, -37}, {111, 111, 331}, {112, 122, 71}, },
            {{36, 109, -40}, {110, 110, 332}, {111, 122, 71}, },
            {{36, 100, -39}, {101, 101, 333}, {102, 122, 71}, },
            {{36, 109, -40}, {110, 110, 334}, {111, 122, 71}, },
            {{36, 115, -109}, {116, 116, 335}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 99, 71}, {100, 100, 336}, {101, 122, 71}, },
            {{36, 95, -10}, {97, 97, 337}, {98, 122, 71}, },
            {{36, 103, -49}, {104, 104, 338}, {105, 122, 71}, },
            {{48, 57, 339}, {65, 70, 340}, {97, 102, 341}, },
            {{48, 102, -249}, },
            {{48, 102, -249}, },
            {{105, 105, 342}, },
            {{70, 70, 343}, {102, 102, 344}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{32, 32, 345}, {34, 34, 346}, {35, 35, 347}, {39, 39, 348}, {46, 46, 349}, {92, 92, 350}, {98, 98, 351}, {102, 102, 352}, {110, 110, 353}, {114, 114, 354}, {116, 116, 355}, {117, 117, 356}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{48, 57, 357}, {65, 70, 358}, {97, 102, 359}, },
            {{48, 57, 360}, {65, 70, 361}, {97, 102, 362}, },
            {{48, 102, -272}, },
            {{48, 102, -272}, },
            {{0, 41, 363}, {42, 42, 364}, {43, 65535, 363}, },
            {{9, 47, -3}, },
            {{0, 8, 365}, {9, 9, 366}, {10, 10, 367}, {11, 12, 365}, {13, 13, 368}, {14, 31, 365}, {32, 32, 369}, {33, 41, 365}, {42, 42, 370}, {43, 46, 365}, {47, 47, 371}, {48, 65535, 365}, },
            {{0, 65535, -184}, },
            {{43, 43, 372}, {45, 45, 373}, {48, 57, 374}, },
            {},
            {{43, 57, -279}, },
            {},
            {{110, 110, 375}, },
            {{116, 116, 376}, },
            {{103, 103, 377}, },
            {{97, 97, 378}, },
            {{115, 115, 379}, },
            {{48, 57, 380}, {65, 70, 381}, {97, 102, 382}, },
            {{48, 102, -288}, },
            {{48, 102, -288}, },
            {{36, 113, -47}, {114, 114, 383}, {115, 122, 71}, },
            {{36, 115, -109}, {116, 116, 384}, {117, 122, 71}, },
            {{36, 100, -39}, {101, 101, 385}, {102, 122, 71}, },
            {{36, 106, -143}, {107, 107, 386}, {108, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 103, -49}, {104, 104, 387}, {105, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 114, -105}, {115, 115, 388}, {116, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 116, -115}, {117, 117, 389}, {118, 122, 71}, },
            {{36, 107, -118}, {108, 108, 390}, {109, 122, 71}, },
            {{36, 113, -47}, {114, 114, 391}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 108, -212}, {109, 109, 392}, {110, 122, 71}, },
            {{36, 109, -40}, {110, 110, 393}, {111, 122, 71}, },
            {{36, 100, -39}, {101, 101, 394}, {102, 122, 71}, },
            {{36, 107, -118}, {108, 108, 395}, {109, 122, 71}, },
            {{36, 115, -109}, {116, 116, 396}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 397}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 97, 398}, {98, 122, 71}, },
            {{36, 113, -47}, {114, 114, 399}, {115, 122, 71}, },
            {{36, 115, -109}, {116, 116, 400}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 116, -115}, {117, 117, 401}, {118, 122, 71}, },
            {{36, 117, -231}, {118, 118, 402}, {119, 122, 71}, },
            {{36, 113, -47}, {114, 114, 403}, {115, 122, 71}, },
            {{36, 116, -115}, {117, 117, 404}, {118, 122, 71}, },
            {{36, 92, -10}, {95, 95, 405}, {97, 122, 71}, },
            {{36, 95, -10}, {97, 97, 406}, {98, 122, 71}, },
            {{36, 100, -39}, {101, 101, 407}, {102, 122, 71}, },
            {{36, 104, -52}, {105, 105, 408}, {106, 122, 71}, },
            {{36, 113, -47}, {114, 114, 409}, {115, 122, 71}, },
            {{36, 115, -109}, {116, 116, 410}, {117, 122, 71}, },
            {{36, 104, -52}, {105, 105, 411}, {106, 122, 71}, },
            {{36, 104, -52}, {105, 105, 412}, {106, 122, 71}, },
            {{36, 98, -204}, {99, 99, 413}, {100, 122, 71}, },
            {{36, 103, -49}, {104, 104, 414}, {105, 122, 71}, },
            {{36, 100, -39}, {101, 101, 415}, {102, 122, 71}, },
            {{36, 95, -10}, {97, 118, 71}, {119, 119, 416}, {120, 122, 71}, },
            {{36, 114, -105}, {115, 115, 417}, {116, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 418}, {112, 122, 71}, },
            {{36, 116, -115}, {117, 117, 419}, {118, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 115, -109}, {116, 116, 420}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{48, 57, 421}, {65, 70, 422}, {97, 102, 423}, },
            {{48, 102, -341}, },
            {{48, 102, -341}, },
            {{110, 110, 424}, },
            {},
            {},
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{48, 57, 425}, {65, 70, 426}, {97, 102, 427}, },
            {{48, 57, 428}, {65, 70, 429}, {97, 102, 430}, },
            {{48, 102, -359}, },
            {{48, 102, -359}, },
            {{48, 57, 431}, {65, 70, 432}, {97, 102, 433}, },
            {{48, 102, -362}, },
            {{48, 102, -362}, },
            {{0, 65535, -275}, },
            {{0, 41, 273}, {42, 42, 364}, {43, 65535, -180}, },
            {{0, 65535, -277}, },
            {{0, 65535, -277}, },
            {{0, 8, 177}, {9, 9, 434}, {10, 10, 367}, {11, 12, 177}, {13, 13, 368}, {14, 31, 177}, {32, 32, 435}, {33, 41, 177}, {42, 42, 178}, {43, 46, 177}, {47, 47, 436}, {48, 65535, 177}, },
            {{0, 65535, -369}, },
            {{0, 65535, -277}, },
            {{0, 8, 437}, {9, 9, 438}, {10, 10, 439}, {11, 12, 437}, {13, 13, 440}, {14, 31, 437}, {32, 32, 441}, {33, 41, 437}, {42, 42, 370}, {43, 46, 437}, {47, 47, 442}, {48, 65535, 437}, },
            {{0, 41, -277}, {42, 42, 443}, {43, 46, 365}, {47, 47, 444}, {48, 65535, 365}, },
            {{48, 57, 374}, },
            {{48, 57, 374}, },
            {{48, 57, 374}, {70, 70, 278}, {102, 102, 280}, },
            {{105, 105, 445}, },
            {{62, 62, 446}, },
            {{104, 104, 447}, },
            {{109, 109, 448}, },
            {{58, 58, 449}, },
            {{48, 57, 450}, {65, 70, 451}, {97, 102, 452}, },
            {{48, 102, -382}, },
            {{48, 102, -382}, },
            {{36, 95, -10}, {97, 97, 453}, {98, 122, 71}, },
            {{36, 95, -10}, {97, 97, 454}, {98, 122, 71}, },
            {{36, 95, -10}, {97, 97, 455}, {98, 122, 71}, },
            {{36, 111, -113}, {112, 112, 456}, {113, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 107, -118}, {108, 108, 457}, {109, 122, 71}, },
            {{36, 100, -39}, {101, 101, 458}, {102, 122, 71}, },
            {{36, 108, -212}, {109, 109, 459}, {110, 122, 71}, },
            {{36, 110, -37}, {111, 111, 460}, {112, 122, 71}, },
            {{36, 99, -246}, {100, 100, 461}, {101, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 108, -212}, {109, 109, 462}, {110, 122, 71}, },
            {{36, 109, -40}, {110, 110, 463}, {111, 122, 71}, },
            {{36, 101, -44}, {102, 102, 464}, {103, 122, 71}, },
            {{36, 103, -49}, {104, 104, 465}, {105, 122, 71}, },
            {{36, 111, -113}, {112, 112, 466}, {113, 122, 71}, },
            {{36, 100, -39}, {101, 101, 467}, {102, 122, 71}, },
            {{36, 113, -47}, {114, 114, 468}, {115, 122, 71}, },
            {{36, 107, -118}, {108, 108, 469}, {109, 122, 71}, },
            {{36, 115, -109}, {116, 116, 470}, {117, 122, 71}, },
            {{36, 115, -109}, {116, 116, 471}, {117, 122, 71}, },
            {{36, 98, -204}, {99, 99, 472}, {100, 122, 71}, },
            {{36, 98, -204}, {99, 99, 473}, {100, 122, 71}, },
            {{36, 109, -40}, {110, 110, 474}, {111, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 475}, {98, 122, 71}, },
            {{36, 98, -204}, {99, 99, 476}, {100, 122, 71}, },
            {{36, 115, -109}, {116, 116, 477}, {117, 122, 71}, },
            {{36, 113, -47}, {114, 114, 478}, {115, 122, 71}, },
            {{36, 114, -105}, {115, 115, 479}, {116, 122, 71}, },
            {{36, 114, -105}, {115, 115, 480}, {116, 122, 71}, },
            {{36, 104, -52}, {105, 105, 481}, {106, 122, 71}, },
            {{36, 118, -333}, {119, 119, 482}, {120, 122, 71}, },
            {{36, 95, -10}, {97, 97, 483}, {98, 122, 71}, },
            {{36, 104, -52}, {105, 105, 484}, {106, 122, 71}, },
            {{48, 57, 485}, {65, 70, 486}, {97, 102, 487}, },
            {{48, 102, -423}, },
            {{48, 102, -423}, },
            {{105, 105, 488}, },
            {{48, 57, 489}, {65, 70, 490}, {97, 102, 491}, },
            {{48, 102, -427}, },
            {{48, 102, -427}, },
            {{48, 57, 492}, {65, 70, 493}, {97, 102, 494}, },
            {{48, 102, -430}, },
            {{48, 102, -430}, },
            {{48, 57, 495}, {65, 70, 496}, {97, 102, 497}, },
            {{48, 102, -433}, },
            {{48, 102, -433}, },
            {{0, 65535, -369}, },
            {{0, 65535, -369}, },
            {{0, 41, 177}, {42, 42, 498}, {43, 46, 177}, {47, 47, 499}, {48, 65535, 177}, },
            {{0, 8, 500}, {9, 9, 501}, {10, 10, 502}, {11, 12, 500}, {13, 13, 503}, {14, 31, 500}, {32, 32, 504}, {33, 41, 500}, {42, 42, 505}, {43, 46, 500}, {47, 47, 506}, {48, 65535, 500}, },
            {{0, 65535, -439}, },
            {{0, 8, 363}, {9, 9, 507}, {10, 10, 502}, {11, 12, 363}, {13, 13, 503}, {14, 31, 363}, {32, 32, 508}, {33, 41, 363}, {42, 42, 364}, {43, 46, 363}, {47, 47, 509}, {48, 65535, 363}, },
            {{0, 65535, -441}, },
            {{0, 65535, -439}, },
            {{0, 65535, -184}, },
            {{0, 8, 510}, {9, 9, 511}, {10, 10, 512}, {11, 12, 510}, {13, 13, 513}, {14, 31, 510}, {32, 32, 514}, {33, 41, 510}, {42, 42, 370}, {43, 46, 510}, {47, 47, 515}, {48, 65535, 510}, },
            {{0, 65535, -373}, },
            {{116, 116, 516}, },
            {},
            {{116, 116, 517}, },
            {{101, 101, 518}, },
            {},
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 98, -204}, {99, 99, 519}, {100, 122, 71}, },
            {{36, 115, -109}, {116, 116, 520}, {117, 122, 71}, },
            {{36, 109, -40}, {110, 110, 521}, {111, 122, 71}, },
            {{36, 110, -37}, {111, 111, 522}, {112, 122, 71}, },
            {{36, 115, -109}, {116, 116, 523}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 524}, {112, 122, 71}, },
            {{36, 109, -40}, {110, 110, 525}, {111, 122, 71}, },
            {{36, 114, -105}, {115, 115, 526}, {116, 122, 71}, },
            {{36, 100, -39}, {101, 101, 527}, {102, 122, 71}, },
            {{36, 98, -204}, {99, 99, 528}, {100, 122, 71}, },
            {{36, 95, -10}, {97, 97, 529}, {98, 122, 71}, },
            {{36, 110, -37}, {111, 111, 530}, {112, 122, 71}, },
            {{36, 114, -105}, {115, 115, 531}, {116, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 532}, {98, 122, 71}, },
            {{36, 115, -109}, {116, 116, 533}, {117, 122, 71}, },
            {{36, 95, -10}, {97, 120, 71}, {121, 121, 534}, {122, 122, 71}, },
            {{36, 100, -39}, {101, 101, 535}, {102, 122, 71}, },
            {{36, 115, -109}, {116, 116, 536}, {117, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 107, -118}, {108, 108, 537}, {109, 122, 71}, },
            {{36, 104, -52}, {105, 105, 538}, {106, 122, 71}, },
            {{36, 101, -44}, {102, 102, 539}, {103, 122, 71}, },
            {{36, 110, -37}, {111, 111, 540}, {112, 122, 71}, },
            {{36, 118, -333}, {119, 119, 541}, {120, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 542}, {102, 122, 71}, },
            {{36, 109, -40}, {110, 110, 543}, {111, 122, 71}, },
            {{36, 107, -118}, {108, 108, 544}, {109, 122, 71}, },
            {{36, 107, -118}, {108, 108, 545}, {109, 122, 71}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{0, 127, -8}, },
            {{116, 116, 546}, },
            {{48, 57, 547}, {65, 70, 548}, {97, 102, 549}, },
            {{48, 102, -491}, },
            {{48, 102, -491}, },
            {{48, 57, 550}, {65, 70, 551}, {97, 102, 552}, },
            {{48, 102, -494}, },
            {{48, 102, -494}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{0, 41, 553}, {42, 42, 178}, {43, 46, 553}, {47, 47, 554}, {48, 65535, 553}, },
            {{0, 65535, -277}, },
            {{0, 65535, -439}, },
            {{0, 65535, -439}, },
            {{0, 65535, -441}, },
            {{0, 65535, -441}, },
            {{0, 65535, -439}, },
            {{0, 41, -372}, {42, 42, 505}, {43, 65535, -372}, },
            {{0, 41, -439}, {42, 42, 555}, {43, 46, 500}, {47, 47, 556}, {48, 65535, 500}, },
            {{0, 65535, -441}, },
            {{0, 65535, -441}, },
            {{0, 41, 363}, {42, 42, 557}, {43, 46, 363}, {47, 47, 558}, {48, 65535, 363}, },
            {{0, 8, 559}, {9, 9, 560}, {10, 10, 561}, {11, 12, 559}, {13, 13, 562}, {14, 31, 559}, {32, 32, 563}, {33, 41, 559}, {42, 42, 564}, {43, 46, 559}, {47, 47, 565}, {48, 65535, 559}, },
            {{0, 65535, -512}, },
            {{0, 8, 566}, {9, 9, 567}, {10, 10, 561}, {11, 12, 566}, {13, 13, 562}, {14, 31, 566}, {32, 32, 568}, {33, 41, 566}, {42, 42, 569}, {43, 46, 566}, {47, 47, 570}, {48, 65535, 566}, },
            {{0, 65535, -514}, },
            {{0, 65535, -512}, },
            {{0, 65535, -373}, },
            {{62, 62, 571}, },
            {{101, 101, 572}, },
            {{116, 116, 573}, },
            {{36, 115, -109}, {116, 116, 574}, {117, 122, 71}, },
            {{36, 104, -52}, {105, 105, 575}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 576}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 109, -40}, {110, 110, 577}, {111, 122, 71}, },
            {{36, 104, -52}, {105, 105, 578}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 109, -40}, {110, 110, 579}, {111, 122, 71}, },
            {{36, 100, -39}, {101, 101, 580}, {102, 122, 71}, },
            {{36, 98, -204}, {99, 99, 581}, {100, 122, 71}, },
            {{36, 101, -44}, {102, 102, 582}, {103, 122, 71}, },
            {{36, 118, -333}, {119, 119, 583}, {120, 122, 71}, },
            {{36, 120, -472}, {121, 121, 584}, {122, 122, 71}, },
            {{36, 104, -52}, {105, 105, 585}, {106, 122, 71}, },
            {{36, 111, -113}, {112, 112, 586}, {113, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 587}, {102, 122, 71}, },
            {{36, 104, -52}, {105, 105, 588}, {106, 122, 71}, },
            {{36, 109, -40}, {110, 110, 589}, {111, 122, 71}, },
            {{36, 111, -113}, {112, 112, 590}, {113, 122, 71}, },
            {{36, 109, -40}, {110, 110, 591}, {111, 122, 71}, },
            {{36, 104, -52}, {105, 105, 592}, {106, 122, 71}, },
            {{36, 109, -40}, {110, 110, 593}, {111, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 594}, {106, 122, 71}, },
            {{36, 100, -39}, {101, 101, 595}, {102, 122, 71}, },
            {{121, 121, 596}, },
            {{48, 57, 597}, {65, 70, 598}, {97, 102, 599}, },
            {{48, 102, -549}, },
            {{48, 102, -549}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{0, 41, 566}, {42, 42, 569}, {43, 65535, 566}, },
            {{0, 65535, -369}, },
            {{0, 41, -445}, {42, 42, 564}, {43, 65535, -445}, },
            {{0, 65535, -508}, },
            {{0, 41, 553}, {42, 42, 569}, {43, 65535, -500}, },
            {{0, 65535, -439}, },
            {{0, 65535, -512}, },
            {{0, 65535, -512}, },
            {{0, 65535, -514}, },
            {{0, 65535, -514}, },
            {{0, 65535, -512}, },
            {{0, 41, -372}, {42, 42, 564}, {43, 65535, -372}, },
            {{0, 41, -512}, {42, 42, 600}, {43, 46, 559}, {47, 47, 601}, {48, 65535, 559}, },
            {{0, 65535, -555}, },
            {{0, 65535, -514}, },
            {{0, 65535, -514}, },
            {{0, 41, 273}, {42, 42, 569}, {43, 65535, -180}, },
            {{0, 41, 566}, {42, 42, 602}, {43, 46, 566}, {47, 47, 603}, {48, 65535, 566}, },
            {},
            {{120, 120, 604}, },
            {{101, 101, 605}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 606}, {112, 122, 71}, },
            {{36, 109, -40}, {110, 110, 607}, {111, 122, 71}, },
            {{36, 104, -52}, {105, 105, 608}, {106, 122, 71}, },
            {{36, 115, -109}, {116, 116, 609}, {117, 122, 71}, },
            {{36, 115, -109}, {116, 116, 610}, {117, 122, 71}, },
            {{36, 110, -37}, {111, 111, 611}, {112, 122, 71}, },
            {{36, 100, -39}, {101, 101, 612}, {102, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 613}, {106, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 95, -10}, {97, 97, 614}, {98, 122, 71}, },
            {{36, 100, -39}, {101, 101, 615}, {102, 122, 71}, },
            {{36, 99, -246}, {100, 100, 616}, {101, 122, 71}, },
            {{36, 109, -40}, {110, 110, 617}, {111, 122, 71}, },
            {{36, 117, -231}, {118, 118, 618}, {119, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 104, -52}, {105, 105, 619}, {106, 122, 71}, },
            {{36, 115, -109}, {116, 116, 620}, {117, 122, 71}, },
            {{36, 115, -109}, {116, 116, 621}, {117, 122, 71}, },
            {{36, 109, -40}, {110, 110, 622}, {111, 122, 71}, },
            {{36, 122, -10}, },
            {{70, 102, -253}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{36, 122, -161}, },
            {{0, 65535, -557}, },
            {{0, 65535, -567}, },
            {{0, 65535, -559}, },
            {{0, 65535, -512}, },
            {{99, 99, 623}, },
            {{114, 114, 624}, },
            {{36, 109, -40}, {110, 110, 625}, {111, 122, 71}, },
            {{36, 115, -109}, {116, 116, 626}, {117, 122, 71}, },
            {{36, 115, -109}, {116, 116, 627}, {117, 122, 71}, },
            {{36, 110, -37}, {111, 111, 628}, {112, 122, 71}, },
            {{36, 114, -105}, {115, 115, 629}, {116, 122, 71}, },
            {{36, 101, -44}, {102, 102, 630}, {103, 122, 71}, },
            {{36, 104, -52}, {105, 105, 631}, {106, 122, 71}, },
            {{36, 115, -109}, {116, 116, 632}, {117, 122, 71}, },
            {{36, 113, -47}, {114, 114, 633}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 117, -231}, {118, 118, 634}, {119, 122, 71}, },
            {{36, 110, -37}, {111, 111, 635}, {112, 122, 71}, },
            {{36, 95, -10}, {97, 121, 71}, {122, 122, 636}, },
            {{36, 98, -204}, {99, 99, 637}, {100, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 117, -231}, {118, 118, 638}, {119, 122, 71}, },
            {{101, 101, 639}, },
            {{48, 57, 640}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 641}, {112, 122, 71}, },
            {{36, 113, -47}, {114, 114, 642}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 109, -40}, {110, 110, 643}, {111, 122, 71}, },
            {{36, 98, -204}, {99, 99, 644}, {100, 122, 71}, },
            {{36, 113, -47}, {114, 114, 645}, {115, 122, 71}, },
            {{36, 110, -37}, {111, 111, 646}, {112, 122, 71}, },
            {{36, 106, -143}, {107, 107, 647}, {108, 122, 71}, },
            {{36, 100, -39}, {101, 101, 648}, {102, 122, 71}, },
            {{36, 103, -49}, {104, 104, 649}, {105, 122, 71}, },
            {{36, 110, -37}, {111, 111, 650}, {112, 122, 71}, },
            {{112, 112, 651}, },
            {{48, 57, 640}, {58, 58, 652}, },
            {{36, 113, -47}, {114, 114, 653}, {115, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 117, -231}, {118, 118, 654}, {119, 122, 71}, },
            {{36, 103, -49}, {104, 104, 655}, {105, 122, 71}, },
            {{36, 95, -10}, {97, 97, 656}, {98, 122, 71}, },
            {{36, 106, -143}, {107, 107, 657}, {108, 122, 71}, },
            {{36, 100, -39}, {101, 101, 658}, {102, 122, 71}, },
            {{36, 99, -246}, {100, 100, 659}, {101, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 106, -143}, {107, 107, 660}, {108, 122, 71}, },
            {{116, 116, 661}, },
            {},
            {{36, 122, -10}, },
            {{36, 110, -37}, {111, 111, 662}, {112, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 120, -472}, {121, 121, 663}, {122, 122, 71}, },
            {{36, 100, -39}, {101, 101, 664}, {102, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 100, -39}, {101, 101, 665}, {102, 122, 71}, },
            {{105, 105, 666}, },
            {{36, 106, -143}, {107, 107, 667}, {108, 122, 71}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{36, 122, -10}, },
            {{111, 111, 668}, },
            {{36, 100, -39}, {101, 101, 669}, {102, 122, 71}, },
            {{110, 110, 670}, },
            {{36, 122, -10}, },
            {},
        }
    };*/

    private static int[][] accept;
/*  {
        // INITIAL
        {-1, 0, 0, 0, 0, -1, -1, -1, 94, 78, 75, 72, 68, 69, 90, 88, 62, 89, 71, 91, 97, 97, 70, 65, 83, 74, 81, -1, 94, 66, -1, 67, 77, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 63, 76, 64, -1, 80, -1, 99, -1, -1, -1, -1, -1, -1, 94, -1, 94, 94, -1, 94, 94, -1, -1, 0, -1, 97, 97, -1, -1, 73, 85, 84, -1, -1, 79, 82, 86, -1, -1, -1, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, -1, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 39, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 59, 94, 94, 94, 94, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 92, 92, -1, 92, 92, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, -1, 93, -1, -1, 0, 0, 0, 0, 98, 97, 97, 97, -1, -1, 87, -1, -1, -1, -1, -1, -1, 94, 94, 94, 94, 94, 94, 94, 94, 94, 61, 32, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 21, 94, 94, 94, 94, 44, 45, 48, 94, 94, 94, 94, 49, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, -1, -1, -1, -1, 98, 92, 92, 92, -1, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, -1, -1, -1, -1, -1, 0, 0, 0, -1, 98, -1, 98, -1, -1, -1, -1, -1, -1, -1, -1, 94, 94, 94, 94, 18, 30, 94, 20, 94, 33, 34, 94, 94, 94, 12, 94, 94, 94, 94, 94, 58, 38, 94, 94, 94, 94, 22, 94, 94, 94, 94, 57, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 16, 94, 60, -1, -1, -1, -1, 98, 98, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, 92, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, 98, -1, -1, -1, -1, -1, -1, -1, -1, 94, 94, 94, 94, 31, 14, 94, 94, 94, 94, 94, 94, 2, 23, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 94, 19, 94, 94, 94, 94, 94, 54, 94, 94, 94, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 94, -1, -1, 95, 94, 94, 94, 94, 94, 94, 94, 94, 24, 94, 94, 94, 94, 94, 94, 94, 94, 3, 94, 94, 94, 94, 94, 4, 50, 94, 7, 94, 94, 94, 55, 94, 94, 94, 94, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 94, 94, 94, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, 94, 94, 17, 94, 35, 94, 94, 27, 94, 94, 94, 94, 94, 94, 94, 94, 6, 94, 94, 94, 94, 94, 94, 94, 26, 94, 94, -1, -1, -1, -1, 92, 92, 92, -1, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, -1, -1, 94, -1, -1, 1, 94, 94, 94, 94, 94, 94, 94, 42, 94, 46, 94, 94, 94, 94, 94, 11, 94, 94, 94, 94, 10, 98, 92, 92, 92, 0, 0, -1, 0, -1, -1, 94, 94, 94, 94, 94, 94, 15, 94, 94, 25, 5, 94, 94, 94, 94, 9, 94, -1, -1, 13, 29, 94, 94, 28, 40, 94, 94, 94, 94, 94, 94, 94, 94, -1, -1, 94, 37, 94, 94, 94, 94, 94, 94, 53, 94, -1, 95, 36, 94, 43, 94, 94, 52, 8, 94, -1, 94, 47, 51, 56, -1, 94, -1, 41, 95, },

    };*/

    public static class State
    {
        public final static State INITIAL = new State(0);

        private int id;

        private State(int id)
        {
            this.id = id;
        }

        public int id()
        {
            return id;
        }
    }
}
