/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.Atomic;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class Atomic_c
extends Stmt_c
implements Atomic {
    public Stmt body;
    public Expr place;

    public Atomic_c(Position p, Expr place, Stmt body) {
        super(p);
        this.place = place;
        this.body = body;
    }

    public Atomic_c(Position p) {
        super(p);
    }

    public Stmt body() {
        return this.body;
    }

    public Atomic body(Stmt body) {
        Atomic_c n = (Atomic_c)this.copy();
        n.body = body;
        return n;
    }

    public Expr place() {
        return this.place;
    }

    public Atomic place(Expr place) {
        this.place = place;
        return this;
    }

    protected Atomic reconstruct(Expr place, Stmt body) {
        if (place != this.place || body != this.body) {
            Atomic_c n = (Atomic_c)this.copy();
            n.place = place;
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr place = (Expr)this.visitChild((Node)this.place, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(place, body);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        return this;
    }

    public Context enterScope(Context c) {
        HjContext cc = (HjContext)super.enterScope(c);
        cc = cc.pushAtomicBlock();
        return cc;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        HjTypeSystem ts = (HjTypeSystem)av.typeSystem();
        if (child == this.place) {
            return ts.place();
        }
        return child.type();
    }

    public String toString() {
        return "atomic (" + this.place + ") { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("atomic (");
        this.printBlock((Node)this.place, w, tr);
        w.write(") ");
        this.printSubStmt(this.body, w, tr);
    }

    public Term entry() {
        return this.place.entry();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG((Term)this.place, this.body.entry());
        v.push((Stmt)this).visitCFG((Term)this.body, (Term)this);
        return succs;
    }
}

