/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import hj.lang.dist;
import hj.lang.place;
import hj.lang.region;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Binary;
import polyglot.ast.Binary_c;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.If;
import polyglot.ast.Local;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ast.Unary;
import polyglot.ext.hj.Configuration;
import polyglot.ext.hj.ast.Here;
import polyglot.ext.hj.ast.HjBinary;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.TypeTranslator;
import polyglot.ext.hj.visit.ExprFlattener;
import polyglot.ext.hj.visit.TypeElaborator;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class HjBinary_c
extends Binary_c
implements HjBinary {
    public HjBinary_c(Position pos, Expr left, Binary.Operator op, Expr right) {
        super(pos, left, op, right);
    }

    public Precedence precedence() {
        HjType l = (HjType)this.left.type();
        HjTypeSystem xts = (HjTypeSystem)l.typeSystem();
        if (xts.isPoint(l) || xts.isPlace(l) || xts.isDistribution(l) || xts.isRegion(l) || xts.isPrimitiveTypeArray(l) || xts.isDistributedArray(l)) {
            return Precedence.LITERAL;
        }
        return super.precedence();
    }

    public boolean isConstant() {
        if (super.isConstant()) {
            return true;
        }
        HjType lt = (HjType)this.left.type();
        HjType rt = (HjType)this.right.type();
        if (lt == null || rt == null) {
            return false;
        }
        if (Configuration.NULLABLE_OBJECT_DEFAULT) {
            return false;
        }
        HjTypeSystem xts = (HjTypeSystem)lt.typeSystem();
        return lt.isNull() && !xts.isNullable(rt) || !xts.isNullable(lt) && rt.isNull();
    }

    public boolean isDisambiguated() {
        boolean val = !(!super.isDisambiguated() || this.left != null && !this.left.isDisambiguated() || this.right != null && !this.right.isDisambiguated());
        return val;
    }

    public Object constantValue() {
        Object result = super.constantValue();
        if (result != null) {
            return result;
        }
        if (!this.isConstant()) {
            return null;
        }
        Object lv = this.left.constantValue();
        Object rv = this.right.constantValue();
        HjType lt = (HjType)this.left.type();
        HjType rt = (HjType)this.right.type();
        HjTypeSystem xts = (HjTypeSystem)lt.typeSystem();
        assert (this.op != EQ && this.op != NE || lt.isNull() && !xts.isNullable(rt) || !xts.isNullable(lt) && rt.isNull());
        if (this.op == EQ) {
            return Boolean.FALSE;
        }
        if (this.op == NE) {
            return Boolean.TRUE;
        }
        try {
            dist l;
            if (xts.isDistribution(lt)) {
                l = (dist)lv;
                if (xts.isDistribution(rt) && this.op == COND_OR) {
                    return l.union((dist)rv);
                }
                if (xts.isPlace(rt) && this.op == BIT_OR) {
                    return l.restriction((place)rv);
                }
                if (xts.isRegion(rt)) {
                    if (this.op == BIT_OR) {
                        return l.restriction((region)rv);
                    }
                    if (this.op == SUB) {
                        return l.difference((region)rv);
                    }
                }
            }
            if (xts.isRegion(lt)) {
                l = (region)lv;
                if (xts.isRegion(rt)) {
                    region r = (region)rv;
                    if (this.op == SUB) {
                        return l.difference(r);
                    }
                    if (this.op == COND_OR) {
                        return l.union(r);
                    }
                    if (this.op == COND_AND) {
                        return l.intersection(r);
                    }
                }
            }
        }
        catch (ArithmeticException e) {
            // empty catch block
        }
        return null;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tc.typeSystem();
        HjType l = (HjType)this.left.type();
        HjType r = (HjType)this.right.type();
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        if (this.op == EQ || this.op == NE) {
            if (!ts.isCastValid(l = l.makeNoClauseVariant(), r = r.makeNoClauseVariant()) && !ts.isCastValid(r, l)) {
                throw new SemanticException("The " + this.op + " operator must have operands of similar type.", this.position());
            }
            return this.type((Type)ts.Boolean());
        }
        if (tc instanceof TypeElaborator) {
            if (this.op == COND_AND) {
                if (!ts.isSubtype(l, (Type)ts.Boolean()) || !ts.isSubtype(r, (Type)ts.Boolean())) {
                    throw new SemanticException("The " + this.op + " operator must have operands of similar type.", this.position());
                }
                return this.type((Type)ts.Boolean());
            }
            return this;
        }
        if ((this.op == GT || this.op == LT || this.op == GE || this.op == LE) && (xts.isPoint(l) || xts.isPlace(l))) {
            if (xts.isPlace(l) && !xts.isPlace(r)) {
                throw new SemanticException("The " + this.op + " operator instance must have a place operand.", this.right.position());
            }
            if (xts.isPoint(l) && !xts.isPoint(r)) {
                throw new SemanticException("The " + this.op + " operator instance must have a point operand.", this.right.position());
            }
            return this.type((Type)ts.Boolean());
        }
        if (this.op == COND_OR && xts.isDistributedArray(l)) {
            if (!(l = l.makeNoClauseVariant()).equals(r = r.makeNoClauseVariant())) {
                throw new SemanticException("The operands of " + this.op + " have base types " + l + " and " + r + "; these must " + "be similar. ", this.right.position());
            }
            return this.type(l);
        }
        if (this.op == COND_OR && xts.isRegion(l)) {
            if (!xts.isRegion(r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a region operand.", this.right.position());
            }
            return this.type(this.checkRanks(l, r, (HjParsedClassType)ts.region()));
        }
        if (this.op == COND_OR && xts.isDistribution(l)) {
            if (!xts.isDistribution(r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a distribution operand.", this.right.position());
            }
            return this.type(this.checkRanks(l, r, (HjParsedClassType)ts.distribution()));
        }
        if (this.op == COND_AND && xts.isRegion(l)) {
            if (!xts.isRegion(r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a region operand.", this.right.position());
            }
            return this.type(this.checkRanks(l, r, (HjParsedClassType)ts.region()));
        }
        if (this.op == COND_AND && xts.isDistribution(l)) {
            if (!xts.isDistribution(r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a distribution operand.", this.right.position());
            }
            return this.type(this.checkRanks(l, r, (HjParsedClassType)ts.distribution()));
        }
        if (this.op == BIT_OR && xts.isDistributedArray(l)) {
            if (!(xts.isDistribution(r) || xts.isRegion(r) || xts.isPlace(r))) {
                throw new SemanticException("This " + this.op + " operator instance must have a distribution operand.", this.right.position());
            }
            HjParsedClassType lType = (HjParsedClassType)l;
            HjParsedClassType type = lType.makeVariant();
            C_Var rank = lType.rank();
            if (rank != null) {
                type.setRank(rank);
            }
            if (xts.isPlace(r) && r instanceof Here) {
                type.setOnePlace(xts.here());
            }
            if (TypeTranslator.isPureTerm((Term)this.right)) {
                type.setDistribution((C_Var)TypeTranslator.translate((Receiver)this.right, xts));
            }
            Expr result = this.type(type);
            return result;
        }
        if (this.op == BIT_OR && xts.isDistribution(l)) {
            if (!xts.isPlace(r) && !xts.isRegion(r)) {
                throw new SemanticException("This " + this.op + " operator instance must have a place or region operand.", this.right.position());
            }
            HjParsedClassType lType = (HjParsedClassType)l;
            HjParsedClassType type = ((HjParsedClassType)ts.distribution()).makeVariant();
            C_Var rank = lType.rank();
            if (rank != null) {
                type.setRank(rank);
            }
            if (xts.isPlace(r) && r instanceof Here) {
                type.setOnePlace(xts.here());
            }
            Expr result = this.type(type);
            return result;
        }
        if (this.op == SUB && xts.isDistribution(l)) {
            if (!xts.isRegion(r) && !xts.isDistribution(r)) {
                throw new SemanticException("The " + this.op + " operator must have a region or distribution operand.", this.right.position());
            }
            return this.type(this.checkRanks(l, r, (HjParsedClassType)ts.distribution()));
        }
        if (this.op == SUB && xts.isRegion(l)) {
            if (!xts.isRegion(r)) {
                throw new SemanticException("The " + this.op + " operator must have a region operands.", this.right.position());
            }
            return this.type(this.checkRanks(l, r, (HjParsedClassType)ts.region()));
        }
        if ((this.op == SUB || this.op == ADD || this.op == MUL || this.op == DIV) && xts.isPrimitiveTypeArray(l)) {
            if (!xts.equalsWithoutClause(l, r)) {
                throw new SemanticException("The types of operands to " + this.op + " are " + l + " and " + r + "; these types should be equal.", this.right.position());
            }
            this.checkDistributions(l, r, (HjParsedClassType)ts.distribution());
            return this.type(l);
        }
        if ((this.op == SUB || this.op == ADD || this.op == MUL || this.op == DIV) && xts.isPoint(l) && !ts.isSubtype(r, (Type)ts.String())) {
            if (!xts.isPoint(r) && !r.isIntOrLess()) {
                throw new SemanticException("The " + this.op + " operator instance must have a point or integer operand.", this.right.position());
            }
            return this.type(l);
        }
        if ((this.op == SUB || this.op == ADD || this.op == MUL || this.op == DIV) && xts.isPoint(r) && !ts.isSubtype(l, (Type)ts.String())) {
            if (!l.isIntOrLess()) {
                throw new SemanticException("The " + this.op + " operator instance must have a point or integer operand.", this.left.position());
            }
            return this.type(r);
        }
        return super.typeCheck(tc);
    }

    public HjType checkRanks(HjType l, HjType r, HjParsedClassType result) throws SemanticException {
        result = result.makeVariant();
        HjParsedClassType lType = (HjParsedClassType)l;
        HjParsedClassType rType = (HjParsedClassType)r;
        C_Var lRank = lType.rank();
        C_Var rRank = rType.rank();
        if (lRank == null || !lRank.equals(rRank)) {
            throw new SemanticException("The argument " + this.left + " (of type " + l + " " + l.getClass() + ") has rank " + lRank + " and " + this.right + " (of type " + r + ") has rank " + rRank + "; these must be equal.");
        }
        result.setRank(lRank);
        return result;
    }

    public HjType checkDistributions(HjType l, HjType r, HjParsedClassType result) throws SemanticException {
        result = result.makeVariant();
        HjParsedClassType lType = (HjParsedClassType)l;
        HjParsedClassType rType = (HjParsedClassType)r;
        C_Var lDist = lType.distribution();
        C_Var rDist = rType.distribution();
        result.setRank(lDist);
        return result;
    }

    public Expr flatten(ExprFlattener.Flattener fc) {
        assert (this.op == Binary.COND_AND || this.op == Binary.COND_OR);
        HjContext xc = (HjContext)fc.context();
        NodeFactory nf = fc.nodeFactory();
        TypeSystem ts = fc.typeSystem();
        Position pos = this.position();
        Id resultVarName = nf.Id(pos, xc.getNewVarName());
        CanonicalTypeNode tn = nf.CanonicalTypeNode(pos, this.type);
        Flags flags = Flags.NONE;
        LocalInstance li = ts.localInstance(pos, flags, this.type, resultVarName.id());
        Expr nLeft = (Expr)this.left.visit((NodeVisitor)fc);
        LocalDecl ld = nf.LocalDecl(pos, flags, (TypeNode)tn, resultVarName, nLeft).localInstance(li);
        fc.add((Stmt)ld);
        Local ldRef = (Local)nf.Local(pos, resultVarName).localInstance(li).type(this.type);
        ExprFlattener.Flattener newVisitor = (ExprFlattener.Flattener)new ExprFlattener.Flattener(fc.job(), ts, nf, (Node)this).context(xc);
        Expr nRight = (Expr)this.right.visit((NodeVisitor)newVisitor);
        List condBody = newVisitor.stmtList();
        Expr assign = nf.Assign(pos, (Expr)ldRef, Assign.ASSIGN, nRight).type(this.type);
        Eval eval = nf.Eval(pos, assign);
        condBody.add(eval);
        Local ldRef2 = (Local)nf.Local(pos, resultVarName).localInstance(li).type(this.type);
        if (this.op == Binary.COND_AND) {
            If ifStm = nf.If(pos, (Expr)ldRef2, (Stmt)nf.Block(pos, condBody));
            fc.add((Stmt)ifStm);
        } else {
            Expr cond = nf.Unary(pos, (Expr)ldRef2, Unary.NOT).type(this.type);
            If ifStm = nf.If(pos, cond, (Stmt)nf.Block(pos, condBody));
            fc.add((Stmt)ifStm);
        }
        Local ldRef3 = (Local)nf.Local(pos, resultVarName).localInstance(li).type(this.type);
        return ldRef3;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.op == COND_OR && (this.left instanceof dist || this.left instanceof region) || this.op == COND_AND && this.left instanceof region) {
            v.visitCFG((Term)this.left, this.right.entry());
            v.visitCFG((Term)this.right, (Term)this);
            return succs;
        }
        return super.acceptCFG(v, succs);
    }
}

