/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.Expr;
import polyglot.ast.Local_c;
import polyglot.ast.MethodDecl;
import polyglot.ast.New_c;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.HjFormal;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjConstructorInstance;
import polyglot.ext.hj.types.HjLocalInstance;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_Local;
import polyglot.ext.hj.types.constr.C_Root;
import polyglot.ext.hj.types.constr.C_Special;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.types.constr.Promise;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjNew_c
extends New_c {
    public HjNew_c(Position pos, Expr qualifier, TypeNode tn, List arguments, ClassBody body) {
        super(pos, qualifier, tn, arguments, body);
    }

    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        HjNew_c n = (HjNew_c)super.typeCheckOverride(parent, tc);
        return n;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjNew_c n = this;
        HjNodeFactory xnf = (HjNodeFactory)tc.nodeFactory();
        HjTypeSystem xts = (HjTypeSystem)tc.typeSystem();
        TypeNode oType = n.objectType();
        String opName = null;
        if (n.body != null && n.qualifier == null && oType instanceof CanonicalTypeNode) {
            ClassType type = oType.type().toClass();
            ClassType outer = null;
            if (type.isNested() && (outer = type.container().toClass()) != null && xts.isHjArray((Type)outer)) {
                opName = type.name();
            }
        }
        if (opName != null) {
            CanonicalTypeNode t;
            Position nPos = oType.position();
            if (opName.equals("pointwiseOp")) {
                List members = n.body.members();
                MethodDecl apply = n.findMethod1Arg("apply", members);
                MethodInstance mi = apply.methodInstance();
                TypeNode appResultType = apply.returnType();
                List formals = apply.formals();
                assert (!formals.isEmpty());
                TypedList l1 = TypedList.copy((List)formals, HjFormal.class, (boolean)false);
                HjFormal firstArg = (HjFormal)formals.get(0);
                Position pos = firstArg.position();
                LocalInstance li = firstArg.localInstance();
                li = li.flags(Flags.FINAL).type(mi.returnType()).name("_");
                l1.add(xnf.Formal(pos, Flags.FINAL, appResultType, xnf.Id(pos, "_")).localInstance(li));
                ClassType tOperatorPointwise = xts.OperatorPointwise();
                TypedList l2 = TypedList.copy((List)mi.formalTypes(), Type.class, (boolean)false);
                l2.add(mi.returnType());
                mi = mi.container((ReferenceType)tOperatorPointwise).formalTypes((List)l2);
                MethodDecl decl = apply.formals((List)l1).methodInstance(mi);
                TypedList classDecl = new TypedList(new LinkedList(), MethodDecl.class, false);
                for (int i = 0; i < members.size(); ++i) {
                    Object m = members.get(i);
                    if (m != apply) {
                        classDecl.add(m);
                        continue;
                    }
                    classDecl.add(decl);
                }
                CanonicalTypeNode t2 = xnf.CanonicalTypeNode(nPos, (Type)tOperatorPointwise);
                ParsedClassType anon = n.anonType();
                anon.superType((Type)tOperatorPointwise);
                return n.objectType((TypeNode)t2).body(n.body().members((List)classDecl)).typeCheckOverride(null, tc);
            }
            if (opName.equals("binaryOp")) {
                t = xnf.CanonicalTypeNode(nPos, (Type)xts.OperatorBinary());
                return n.objectType((TypeNode)t).typeCheckOverride(null, tc);
            }
            if (opName.equals("unaryOp")) {
                t = xnf.CanonicalTypeNode(nPos, (Type)xts.OperatorUnary());
                return n.objectType((TypeNode)t).typeCheckOverride(null, tc);
            }
        }
        HjNew_c result = (HjNew_c)super.typeCheck(tc);
        result = result.adjustCI(tc);
        return result;
    }

    private MethodDecl findMethod1Arg(String name, List members) {
        for (MethodDecl m : members) {
            if (!m.name().equals(name)) continue;
            return m;
        }
        return null;
    }

    private HjNew_c adjustCI(TypeChecker tc) throws SemanticException {
        if (this.ci == null) {
            return this;
        }
        HjConstructorInstance xci = (HjConstructorInstance)this.ci;
        HjType type = xci.returnType();
        if (this.body != null) {
            HjParsedClassType anonType = (HjParsedClassType)this.anonType();
            type = anonType.makeDepVariant(type.depClause(), type.typeParameters());
        }
        HjType retType = HjNew_c.instantiateType(type, this.arguments);
        return (HjNew_c)this.type(retType);
    }

    public static HjType instantiateType(HjType formalReturnType, List<Expr> arguments) {
        return HjNew_c.instantiateType(formalReturnType, null, arguments);
    }

    public static HjType instantiateType(HjType formalReturnType, Receiver target, List<Expr> arguments) {
        HjType retType = formalReturnType;
        Constraint rc = formalReturnType.realClause();
        if (rc == null) {
            return retType;
        }
        HashMap<C_Var, Promise> m = rc.roots();
        if (m == null) {
            return retType;
        }
        Set<C_Var> vars = m.keySet();
        HashMap<C_Root, C_Var> subs = new HashMap<C_Root, C_Var>();
        HashMap<LocalInstance, C_Var> renaming = new HashMap<LocalInstance, C_Var>();
        for (C_Root c_Root : vars) {
            Local_c actual;
            if (c_Root.equals(C_Special.This)) {
                if (target == null) continue;
                C_Var realThis = rc.selfVar((Expr)target, false);
                subs.put(c_Root, realThis);
                continue;
            }
            if (!(c_Root instanceof C_Local)) continue;
            HjLocalInstance li = ((C_Local)c_Root).localInstance();
            assert (li != null);
            int p = li.positionInArgList();
            if (p < 0) continue;
            Expr arg = arguments.get(p);
            C_Var realVar = null;
            if (arg instanceof Local_c && (realVar = (C_Var)renaming.get((actual = (Local_c)arg).localInstance())) == null) {
                realVar = rc.selfVar(arg, false);
                renaming.put(actual.localInstance(), realVar);
            }
            if (realVar == null) {
                realVar = rc.selfVar(arg, false);
            }
            subs.put(c_Root, realVar);
        }
        if (!subs.isEmpty()) {
            Constraint newRC = rc.substitute(subs);
            retType = formalReturnType.makeVariant(newRC, null);
        }
        return retType;
    }
}

