/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.dom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import polyglot.ext.hj.dom.HjDom;
import polyglot.util.Copy;
import polyglot.util.IdentityKey;
import polyglot.util.InternalCompilerError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomGenerator
implements Copy {
    Element root;
    Element types;
    Element parent;
    Map<IdentityKey, String> typesMap;
    Document scratchPad;

    public DomGenerator() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            this.scratchPad = domImpl.createDocument(null, "hjml", null);
        }
        catch (FactoryConfigurationError e) {
            throw new InternalCompilerError("Could not configure factory.", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new InternalCompilerError("Could not configure parser.", (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalCompilerError((Throwable)e);
        }
        this.typesMap = new HashMap<IdentityKey, String>();
    }

    public Element gen(HjDom dom, polyglot.ast.Node n) {
        this.parent = this.root = this.createElement(null, "HjSource");
        this.types = this.createElement(this.root, "TypeSystem");
        dom.gen(this, "AbstractSyntaxTree", n);
        return this.root;
    }

    public Element get() {
        return this.parent;
    }

    public Object copy() {
        try {
            return (DomGenerator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalCompilerError("Java clone() weirdness");
        }
    }

    public Element createElement(Element parent, String tag) {
        Element e = this.scratchPad.createElement(tag);
        if (parent != null) {
            parent.appendChild(e);
        }
        return e;
    }

    public void createAttribute(Element parent, String tag, String value) {
        assert (parent != null);
        parent.setAttribute(tag, value);
    }

    public void createText(Element parent, String content) {
        assert (parent != null);
        Document doc = parent.getOwnerDocument();
        Text t = doc.createTextNode(content);
        parent.appendChild(t);
    }

    public void createPI(Element parent, String target, String content) {
        assert (parent != null);
        Document doc = parent.getOwnerDocument();
        ProcessingInstruction t = doc.createProcessingInstruction(target, content);
        parent.appendChild(t);
    }

    public void createComment(Element parent, String content) {
        assert (parent != null);
        Document doc = parent.getOwnerDocument();
        Comment t = doc.createComment(content);
        parent.appendChild(t);
    }

    public Element setAttribute(Element elem, String attrName, Object value) {
        elem.setAttribute(attrName, value.toString());
        return elem;
    }

    public void appendChild(Element elem, Node newChild) {
        elem.appendChild(elem.getOwnerDocument().importNode(newChild, true));
    }

    public void appendChildren(Element elem, Object newTextChild) {
        elem.appendChild(this.scratchPad.createTextNode(newTextChild.toString()));
    }

    public void appendChildren(Element elem, List list) {
        Document d = elem.getOwnerDocument();
        for (Node n : list) {
            elem.appendChild(d.importNode(n, true));
        }
    }

    public void insertBefore(Element parent, Element ref, Element newChild) {
        parent.insertBefore(newChild, ref);
    }

    public void insertAfter(Element parent, Element ref, Element newChild) {
        Node next = ref.getNextSibling();
        if (next == null) {
            parent.appendChild(newChild);
        } else {
            parent.insertBefore(newChild, next);
        }
    }

    public void appendChildren(Element elem, Element[] newChildren) {
        for (int i = 0; i < newChildren.length; ++i) {
            elem.appendChild(newChildren[i]);
        }
    }

    public DomGenerator tag(String tag) {
        DomGenerator v = (DomGenerator)this.copy();
        v.parent = this.createElement(this.parent, tag);
        return v;
    }

    public <T> DomGenerator gen(String tag, T n, HjDom.Lens<T> lens) {
        DomGenerator v = this.tag(tag);
        lens.toXML(v, n);
        return this;
    }
}

