/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.extension;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import polyglot.ast.Block;
import polyglot.ast.Block_c;
import polyglot.ast.Call;
import polyglot.ast.Call_c;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody_c;
import polyglot.ast.Expr;
import polyglot.ast.Formal_c;
import polyglot.ast.Local;
import polyglot.ast.MethodDecl;
import polyglot.ast.MethodDecl_c;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.extension.HjExt_c;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.frontend.ExtensionInfo;
import polyglot.types.ClassType;
import polyglot.types.ClassType_c;
import polyglot.types.MethodInstance;
import polyglot.types.PrimitiveType;
import polyglot.types.Type;
import polyglot.util.Position;

public class HjClassBodyExt_c
extends HjExt_c {
    private BufferedWriter wrapperFile;
    HjTypeSystem typeSystem;
    private final String KgetBackingArrayMethod = "getBackingArray";
    private final String KgetDescriptorMethod = "getDescriptor";
    private final String KdescriptorNameSuffix = "_hjDeScRiPtOr";
    private final String KPtrNameSuffix = "_hjPoInTeR";
    String[] wrapperPrologue = new String[]{"/*Automatically generated -- DO NOT EDIT THIS FILE */\n", "#include <sys/types.h>\n", "#include <jni.h>\n", "#ifdef __cplusplus\n", "extern \"C\" {\n", "#endif\n", ""};
    String[] wrapperEpilogue = new String[]{"\n", "#ifdef __cplusplus\n", "}\n", "#endif\n"};
    private static final String zeros = "0000";
    private static final String JNI_PREFIX = "Java_";
    private static int containingClassDepth = 0;

    private void generateWrapperPrologue() {
        try {
            for (int i = 0; i < this.wrapperPrologue.length; ++i) {
                this.wrapperFile.write(this.wrapperPrologue[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Problems writing to " + this.wrapperFile);
        }
    }

    private void generateWrapperEpilogue() {
        try {
            for (int i = 0; i < this.wrapperEpilogue.length; ++i) {
                this.wrapperFile.write(this.wrapperEpilogue[i]);
            }
            this.wrapperFile.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Problems with " + this.wrapperFile);
        }
    }

    private void createWrapperFile(String containingClassName, File output_dir) {
        String fileName = containingClassName + "_hjstub.c";
        Date timeStamp = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat();
        try {
            this.wrapperFile = new BufferedWriter(new FileWriter(new File(output_dir, fileName)));
            this.wrapperFile.write("/*\n * Filename:" + fileName + "\n * Generated: " + formatter.format(timeStamp) + " */\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Problems writing to " + this.wrapperFile);
        }
    }

    private String typeToCType(Type theType) {
        if (theType.isPrimitive()) {
            return this.typeToCString(theType);
        }
        if (theType.isArray()) {
            return this.typeToCType(theType.toArray().base()) + "*";
        }
        if (this.typeSystem.isHjArray(theType)) {
            Type base = this.typeSystem.baseType(theType);
            if (!base.isPrimitive()) {
                return "jobject*";
            }
            return this.typeToCString(base) + "*";
        }
        return "jobject";
    }

    private String typeToCString(Type theType) {
        if (theType.isPrimitive()) {
            if (theType.isInt()) {
                return "signed int";
            }
            if (theType.isChar()) {
                return "signed short";
            }
            if (theType.isBoolean()) {
                return "unsigned char";
            }
            if (theType.isByte()) {
                return "signed char";
            }
            if (theType.isShort()) {
                return "signed short";
            }
            if (theType.isLong()) {
                return "jlong";
            }
            if (theType.isFloat()) {
                return "float";
            }
            if (theType.isDouble()) {
                return "double";
            }
            if (theType.isVoid()) {
                return "void";
            }
            throw new Error("Unexpected type" + theType.toString());
        }
        if (!theType.isArray()) {
            throw new Error("Unexpected type" + theType.toString());
        }
        Type baseType = theType.toArray().base();
        if (!baseType.isPrimitive()) {
            throw new Error("Only primitive arrays are supported, not " + theType.toString());
        }
        return this.typeToCString(baseType) + "Array";
    }

    private String typeToJavaSigString(Type theType) {
        if (theType.isPrimitive()) {
            if (theType.isInt()) {
                return "I";
            }
            if (theType.isChar()) {
                return "J";
            }
            if (theType.isBoolean()) {
                return "Z";
            }
            if (theType.isByte()) {
                return "B";
            }
            if (theType.isShort()) {
                return "S";
            }
            if (theType.isLong()) {
                return "J";
            }
            if (theType.isFloat()) {
                return "F";
            }
            if (theType.isDouble()) {
                return "D";
            }
            if (theType.isVoid()) {
                return "V";
            }
            throw new Error("Unexpected type" + theType.toString());
        }
        if (!theType.isArray()) {
            throw new Error("Only java arrays are supported, not " + theType.toString());
        }
        Type baseType = theType.toArray().base();
        if (!baseType.isPrimitive()) {
            throw new Error("Only primitive arrays are supported, not " + theType.toString());
        }
        return "[" + this.typeToJavaSigString(baseType);
    }

    private String generateJavaSignature(MethodDecl_c method) {
        MethodInstance mi = method.methodInstance();
        String signature = "";
        ListIterator i = method.formals().listIterator();
        while (i.hasNext()) {
            Formal_c parameter = (Formal_c)i.next();
            if (parameter.declType().isPrimitive() || parameter.declType().isArray()) {
                signature = signature + this.typeToJavaSigString(parameter.declType());
                continue;
            }
            ClassType_c ct = (ClassType_c)parameter.declType().toClass();
            MethodInstance backingMethod = this.findMethod(ct, "getBackingArray");
            if (null == backingMethod) {
                throw new Error("Could not find getBackingArray in class " + ct);
            }
            signature = signature + this.typeToJavaSigString(backingMethod.returnType());
            signature = signature + this.typeToJavaSigString((Type)this.typeSystem.arrayOf(parameter.position(), (Type)this.typeSystem.Int()));
        }
        return signature;
    }

    private String JNImangle(String inName) {
        char[] charName = inName.toCharArray();
        StringBuffer buffer = new StringBuffer(inName.length());
        boolean seenForwardSlash = false;
        boolean inCommentMode = false;
        boolean lastCharAsterix = false;
        int lastChar = 97;
        for (int i = 0; i < inName.length(); ++i) {
            char ch = inName.charAt(i);
            if (inCommentMode) {
                if (ch == '/' && lastChar == 42) {
                    inCommentMode = false;
                }
            } else {
                switch (ch) {
                    case '/': {
                        break;
                    }
                    case '*': {
                        if (lastChar != 47) break;
                        inCommentMode = true;
                        break;
                    }
                    case '_': {
                        buffer.append("_1");
                        break;
                    }
                    case ';': {
                        buffer.append("_2");
                        break;
                    }
                    case '[': {
                        buffer.append("_3");
                        break;
                    }
                    case '.': {
                        buffer.append("_");
                        break;
                    }
                    default: {
                        if (Character.isLetterOrDigit(ch)) {
                            buffer.append(ch);
                            break;
                        }
                        String hex = Integer.toHexString(ch);
                        hex = zeros.substring(hex.length()) + hex;
                        buffer.append("_0").append(hex);
                    }
                }
            }
            lastChar = ch;
        }
        return buffer.toString();
    }

    private String generateJNIName(MethodDecl_c method, boolean isOverloaded) {
        String name = JNI_PREFIX + this.JNImangle(this.canonicalTypeString((Type)method.methodInstance().container())) + "_" + this.JNImangle(this.generateHjNativeName(method));
        if (isOverloaded) {
            name = name + "__" + this.JNImangle(this.generateJavaSignature(method));
        }
        return name;
    }

    private String generateJNIAlias(MethodDecl_c method, boolean isOverloaded) {
        String name = JNI_PREFIX + this.JNImangle(method.methodInstance().container().toString()) + "_" + this.JNImangle(this.generateHjAliasName(method));
        if (isOverloaded) {
            name = name + "__" + this.JNImangle(this.generateJavaSignature(method));
        }
        return name;
    }

    private String canonicalTypeString(Type t) {
        String s = "";
        ClassType cl = t.toClass();
        while (cl.isNested()) {
            if (cl.isAnonymous()) {
                throw new RuntimeException("Anonymous inner classes not supported yet");
            }
            s = "$" + cl.name() + s;
            cl = cl.outer();
        }
        return cl.fullName() + s;
    }

    private String generateHjNativeName(MethodDecl_c method) {
        return this.JNImangle(this.canonicalTypeString((Type)method.methodInstance().container())) + "_" + method.name();
    }

    private String generateHjAliasName(MethodDecl_c method) {
        return this.JNImangle(method.methodInstance().container().toString()) + "_" + method.name();
    }

    private MethodDecl_c createNewNative(MethodDecl_c nativeMethod, NodeFactory nf) {
        MethodInstance mi = nativeMethod.methodInstance();
        String nativeName = this.generateHjNativeName(nativeMethod);
        MethodDecl_c newNative = (MethodDecl_c)nativeMethod.name(nativeName);
        ArrayList<Object> newFormals = new ArrayList<Object>();
        CanonicalTypeNode longType = nf.CanonicalTypeNode(nativeMethod.position(), (Type)this.typeSystem.Long());
        CanonicalTypeNode arrayOfIntType = nf.CanonicalTypeNode(nativeMethod.position(), (Type)this.typeSystem.arrayOf(nativeMethod.position(), (Type)this.typeSystem.Int()));
        boolean seenNonPrimitive = false;
        ListIterator i = nativeMethod.formals().listIterator();
        while (i.hasNext()) {
            Formal_c parameter = (Formal_c)i.next();
            if (parameter.declType().isPrimitive()) {
                newFormals.add(parameter);
                continue;
            }
            seenNonPrimitive = true;
            ClassType_c ct = (ClassType_c)parameter.declType().toClass();
            MethodInstance backingMethod = this.findMethod(ct, "getBackingArray");
            if (null == backingMethod) {
                throw new Error("Could not find getBackingArray in class " + ct);
            }
            CanonicalTypeNode theReturnType = nf.CanonicalTypeNode(nativeMethod.position(), backingMethod.returnType());
            newFormals.add(parameter.type((TypeNode)theReturnType));
            Formal_c paramDescriptor = (Formal_c)parameter.name(parameter.name() + "_hjDeScRiPtOr");
            newFormals.add(paramDescriptor.type((TypeNode)arrayOfIntType));
        }
        if (seenNonPrimitive) {
            newNative = (MethodDecl_c)newNative.formals(newFormals);
        }
        return newNative;
    }

    private MethodInstance findMethod(ClassType_c theClass, String targetName) {
        ListIterator j;
        ClassType_c currentClass;
        Object targetMI = null;
        MethodInstance memberMI = null;
        boolean trace = false;
        for (currentClass = theClass; currentClass != null; currentClass = (ClassType_c)currentClass.superType()) {
            List methods = currentClass.methods();
            j = methods.listIterator();
            while (j.hasNext()) {
                memberMI = (MethodInstance)j.next();
                if (!memberMI.name().equals(targetName)) continue;
                return memberMI;
            }
        }
        for (currentClass = theClass; currentClass != null; currentClass = (ClassType_c)currentClass.superType()) {
            List interfaceMethods = currentClass.interfaces();
            j = interfaceMethods.listIterator();
            while (j.hasNext()) {
                ClassType_c implementationClass = (ClassType_c)j.next();
                List methods = implementationClass.methods();
                ListIterator k = methods.listIterator();
                while (k.hasNext()) {
                    memberMI = (MethodInstance)k.next();
                    if (!memberMI.name().equals(targetName)) continue;
                    return memberMI;
                }
            }
        }
        return null;
    }

    private MethodDecl_c createNativeWrapper(MethodDecl_c nativeMethod, NodeFactory nf) {
        boolean trace = false;
        nativeMethod = (MethodDecl_c)nativeMethod.flags(nativeMethod.flags().clearNative());
        MethodInstance mi = nativeMethod.methodInstance();
        Position pos = nativeMethod.position();
        MethodDecl_c nativeWrapper = nativeMethod;
        ArrayList newArgs = new ArrayList();
        String jniName = this.generateHjNativeName(nativeMethod);
        CanonicalTypeNode receiver = nf.CanonicalTypeNode(pos, (Type)mi.container());
        Call jniCall = nf.Call(pos, (Receiver)receiver, nf.Id(pos, jniName), newArgs);
        jniCall = (Call_c)jniCall.targetImplicit(true);
        jniCall = (Call_c)jniCall.methodInstance(mi);
        String descriptorName = "getDescriptor";
        ArrayList<Object> args = new ArrayList<Object>();
        ListIterator i = nativeMethod.formals().listIterator();
        while (i.hasNext()) {
            Formal_c parameter = (Formal_c)i.next();
            if (parameter.declType().isPrimitive()) {
                Local arg = nf.Local(pos, nf.Id(pos, parameter.name()));
                arg = (Local)arg.type(parameter.declType());
                arg = arg.localInstance(this.typeSystem.localInstance(pos, parameter.flags(), arg.type(), arg.name()));
                args.add(arg);
                continue;
            }
            ClassType_c ct = (ClassType_c)parameter.declType().toClass();
            if (null == ct) {
                throw new Error("Problems with array " + parameter.name());
            }
            if (trace) {
                System.out.println("Processing " + parameter.name() + "::" + parameter);
            }
            MethodInstance memberMI = null;
            MethodInstance arrayDescriptorMI = null;
            MethodInstance backingArrayMI = null;
            boolean doneSearch = false;
            for (ClassType_c currentClass = ct; currentClass != null && !doneSearch; currentClass = (ClassType_c)currentClass.superType()) {
                List interfaceMethods = currentClass.interfaces();
                ListIterator j = interfaceMethods.listIterator();
                block2: while (j.hasNext()) {
                    ClassType_c implementationClass = (ClassType_c)j.next();
                    if (trace) {
                        System.out.println("looking at interface " + implementationClass);
                    }
                    List methods = implementationClass.methods();
                    ListIterator k = methods.listIterator();
                    while (k.hasNext()) {
                        memberMI = (MethodInstance)k.next();
                        if (trace) {
                            System.out.println("inspecting interface member:" + memberMI.name());
                        }
                        if (memberMI.name().equals(descriptorName)) {
                            arrayDescriptorMI = memberMI;
                        }
                        if (memberMI.name().equals("getBackingArray")) {
                            backingArrayMI = memberMI;
                        }
                        if (arrayDescriptorMI == null) continue;
                        continue block2;
                    }
                }
                if (backingArrayMI == null) {
                    backingArrayMI = this.findMethod(currentClass, "getBackingArray");
                }
                if (arrayDescriptorMI == null || backingArrayMI == null) continue;
                doneSearch = true;
            }
            if (null == arrayDescriptorMI) {
                throw new Error("Could not find " + descriptorName + " in class " + ct.fullName());
            }
            if (null == backingArrayMI) {
                throw new Error("Could not find getBackingArray in class " + ct.fullName());
            }
            Local getAddrTarget = nf.Local(pos, nf.Id(pos, parameter.name()));
            getAddrTarget = (Local)getAddrTarget.type(parameter.type().type());
            getAddrTarget = getAddrTarget.localInstance(this.typeSystem.localInstance(pos, parameter.flags(), getAddrTarget.type(), getAddrTarget.name()));
            Call getAddr = nf.Call(pos, (Receiver)getAddrTarget, nf.Id(pos, "getBackingArray"));
            getAddr = (Call_c)getAddr.methodInstance(backingArrayMI);
            getAddr = (Call)getAddr.type(backingArrayMI.returnType());
            args.add(getAddr);
            Call getDescriptor = nf.Call(pos, (Receiver)getAddrTarget, nf.Id(pos, descriptorName));
            getDescriptor = (Call_c)getDescriptor.methodInstance(arrayDescriptorMI);
            getDescriptor = (Call)getDescriptor.type(arrayDescriptorMI.returnType());
            args.add(getDescriptor);
        }
        jniCall = (Call_c)jniCall.arguments(args);
        jniCall = (Call)jniCall.type(nativeMethod.returnType().type());
        ArrayList<Object> newStmts = new ArrayList<Object>();
        if (nativeMethod.methodInstance().returnType().isVoid()) {
            newStmts.add(nf.Eval(pos, (Expr)jniCall));
        } else {
            newStmts.add(nf.Return(pos, (Expr)jniCall));
        }
        Block_c newBlock = (Block_c)nf.Block(pos, newStmts);
        nativeWrapper = (MethodDecl_c)nativeWrapper.body((Block)newBlock);
        return nativeWrapper;
    }

    private String maybeCast(String to, String from) {
        if (!to.equals(from)) {
            return "(" + to + ")";
        }
        return "";
    }

    private String maybeCast(Type theType) {
        return this.maybeCast(this.typeToCType(theType), this.typeToJNIString(theType));
    }

    private String maybeUncast(Type theType) {
        return this.maybeCast(this.typeToJNIString(theType), this.typeToCType(theType));
    }

    private String generateAcquireStmt(String arrayName, String ptrName) {
        String stmt = "#ifdef __cplusplus\n";
        stmt = stmt + "  void *" + ptrName + " = (env)->GetPrimitiveArrayCritical(" + arrayName + ",0);\n";
        stmt = stmt + "#else\n";
        stmt = stmt + "  void *" + ptrName + " = (*env)->GetPrimitiveArrayCritical(env," + arrayName + ",0);\n";
        stmt = stmt + "#endif\n";
        return stmt;
    }

    private String generateReleaseStmt(String arrayName, String ptrName) {
        String stmt = "#ifdef __cplusplus\n";
        stmt = stmt + "  (env)->ReleasePrimitiveArrayCritical(" + arrayName + "," + ptrName + ",0);\n";
        stmt = stmt + "#else\n";
        stmt = stmt + "  (*env)->ReleasePrimitiveArrayCritical(env," + arrayName + "," + ptrName + ",0);\n";
        stmt = stmt + "#endif\n";
        return stmt;
    }

    private void generateStub(MethodDecl_c nativeMethod, boolean isOverloaded) {
        String newName = this.generateHjNativeName(nativeMethod);
        if (isOverloaded) {
            newName = newName + "__" + this.JNImangle(this.generateJavaSignature(nativeMethod));
        }
        String saveTheValue = "";
        String wrapperCall = "  " + newName + "(";
        String wrapperDecl = "extern " + this.typeToCType(nativeMethod.methodInstance().returnType()) + " ";
        wrapperDecl = wrapperDecl + wrapperCall;
        newName = this.generateJNIName(nativeMethod, isOverloaded);
        String parm = nativeMethod.flags().isStatic() ? "jclass cls" : "jobject obj";
        String jniCall = "JNIEXPORT " + this.typeToJNIString(nativeMethod.methodInstance().returnType()) + " JNICALL\n" + newName + "(JNIEnv *env, " + parm;
        String returnedValue = "";
        if (!nativeMethod.methodInstance().returnType().isVoid()) {
            String tempName = "_hjReTuRnVaL";
            saveTheValue = this.typeToCType(nativeMethod.methodInstance().returnType()) + " " + tempName + "=" + this.maybeUncast(nativeMethod.methodInstance().returnType());
            returnedValue = "return " + tempName + ";\n";
        }
        String commaString = "";
        String releaseStmts = "";
        String acquireStmts = "";
        ListIterator i = nativeMethod.formals().listIterator();
        while (i.hasNext()) {
            Formal_c parameter = (Formal_c)i.next();
            if (parameter.declType().isPrimitive()) {
                jniCall = jniCall + ", " + this.typeToJNIString(parameter.declType()) + " " + parameter.name();
                wrapperDecl = wrapperDecl + commaString + this.typeToCType(parameter.declType()) + " " + parameter.name();
                wrapperCall = wrapperCall + commaString + this.maybeCast(parameter.declType()) + parameter.name();
            } else {
                String arrayPtr = parameter.name() + "_hjPoInTeR";
                acquireStmts = acquireStmts + this.generateAcquireStmt(parameter.name(), arrayPtr);
                releaseStmts = this.generateReleaseStmt(parameter.name(), arrayPtr) + releaseStmts;
                ClassType_c ct = (ClassType_c)parameter.declType().toClass();
                MethodInstance backingMethod = this.findMethod(ct, "getBackingArray");
                if (null == backingMethod) {
                    throw new Error("Could not find getBackingArray in class " + ct);
                }
                jniCall = jniCall + ", " + this.typeToJNIString(backingMethod.returnType()) + " " + parameter.name();
                wrapperDecl = wrapperDecl + commaString + this.typeToCType(backingMethod.returnType()) + " " + arrayPtr;
                wrapperCall = wrapperCall + commaString + this.maybeCast(backingMethod.returnType()) + arrayPtr;
            }
            if (!parameter.declType().isPrimitive()) {
                String descriptorName = parameter.name() + "_hjDeScRiPtOr";
                String descriptorPtrName = descriptorName + "_hjPoInTeR";
                jniCall = jniCall + ", jintArray " + descriptorName;
                acquireStmts = acquireStmts + this.generateAcquireStmt(descriptorName, descriptorPtrName);
                releaseStmts = this.generateReleaseStmt(descriptorName, descriptorPtrName) + releaseStmts;
                wrapperCall = wrapperCall + ", (int*) " + descriptorPtrName;
                wrapperDecl = wrapperDecl + ", int* " + descriptorName;
            }
            commaString = ", ";
        }
        jniCall = jniCall + ")";
        wrapperCall = wrapperCall + ")";
        wrapperDecl = wrapperDecl + ");";
        String jniAlias = "";
        if (nativeMethod.methodInstance().container().toClass().isNested()) {
            String aliasName = this.generateJNIAlias(nativeMethod, isOverloaded);
            jniAlias = "#ifndef __WIN32__\nextern JNIEXPORT __typeof(" + newName + ") JNICALL\n" + aliasName + "\n__attribute((alias(\"" + newName + "\")));\n#endif\n\n";
        }
        try {
            String getcrit = "/*call get critical section*/\n";
            this.wrapperFile.write("\n/* * * * * * * */\n" + wrapperDecl + "\n" + jniCall + " {\n" + acquireStmts + "\n" + "\n" + saveTheValue + wrapperCall + ";\n\n" + releaseStmts + returnedValue + "}\n" + jniAlias);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Problems writing file");
        }
    }

    private String typeToJNIString(Type theType) {
        if (theType.isPrimitive()) {
            if (theType.isInt()) {
                return "jint";
            }
            if (theType.isBoolean()) {
                return "jboolean";
            }
            if (theType.isByte()) {
                return "jbyte";
            }
            if (theType.isShort()) {
                return "jshort";
            }
            if (theType.isLong()) {
                return "jlong";
            }
            if (theType.isFloat()) {
                return "jfloat";
            }
            if (theType.isChar()) {
                return "jchar";
            }
            if (theType.isDouble()) {
                return "jdouble";
            }
            if (theType.isVoid()) {
                return "void";
            }
            throw new Error("Unhandled type:" + theType);
        }
        if (theType.isArray()) {
            return this.typeToJNIString(theType.toArray().base()) + "Array";
        }
        return "<unknown>";
    }

    public Node rewrite(HjTypeSystem ts, NodeFactory nf, ExtensionInfo info) {
        this.typeSystem = ts;
        PrimitiveType tt = ts.Long();
        boolean seenNativeMethodDecl = false;
        ClassBody_c cb = (ClassBody_c)this.node();
        List members = cb.members();
        Map methodHash = null;
        ArrayList newListOfMembers = new ArrayList();
        ListIterator i = members.listIterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof MethodDecl) {
                MethodDecl_c md = (MethodDecl_c)o;
                MethodInstance mi = md.methodInstance();
                if (!mi.flags().isNative()) {
                    newListOfMembers.add(o);
                    continue;
                }
                if (!seenNativeMethodDecl) {
                    methodHash = this.buildNativeMethodHash(members);
                    if (0 == containingClassDepth++) {
                        this.createWrapperFile(this.JNImangle(this.canonicalTypeString((Type)mi.container())), info.getOptions().output_directory);
                        this.generateWrapperPrologue();
                    }
                    seenNativeMethodDecl = true;
                }
                boolean isOverLoaded = null != methodHash.get(md.name());
                this.generateStub(md, isOverLoaded);
                newListOfMembers.add(this.createNewNative(md, nf));
                newListOfMembers.add(this.createNativeWrapper(md, nf));
                continue;
            }
            newListOfMembers.add(o);
        }
        if (seenNativeMethodDecl && 0 == --containingClassDepth) {
            this.generateWrapperEpilogue();
        }
        cb = (ClassBody_c)cb.members(newListOfMembers);
        return cb;
    }

    private Map buildNativeMethodHash(List members) {
        HashMap<String, MethodDecl_c> methodHash = new HashMap<String, MethodDecl_c>();
        ListIterator j = members.listIterator();
        while (j.hasNext()) {
            MethodDecl_c methodDecl;
            Object theObj = j.next();
            if (!(theObj instanceof MethodDecl) || !(methodDecl = (MethodDecl_c)theObj).methodInstance().flags().isNative()) continue;
            if (methodHash.containsKey(methodDecl.name())) {
                methodHash.put(methodDecl.name(), methodDecl);
                continue;
            }
            methodHash.put(methodDecl.name(), null);
        }
        return methodHash;
    }
}

