/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.types.constr;

import java.util.HashMap;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_Lit;
import polyglot.ext.hj.types.constr.C_Term;
import polyglot.ext.hj.types.constr.C_Term_c;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Failure;
import polyglot.ext.hj.types.constr.Path;
import polyglot.ext.hj.types.constr.Promise;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C_Lit_c
extends C_Term_c
implements C_Lit {
    Object val;

    public C_Lit_c(boolean b, TypeSystem ts) {
        super((Type)ts.Boolean());
        this.val = new Boolean(b);
    }

    public C_Lit_c(Object l, Type t) {
        super(t);
        this.val = l;
    }

    private C_Lit type(HjType t) {
        return new C_Lit_c(this.val, t);
    }

    @Override
    public Object val() {
        return this.val;
    }

    public String toString() {
        if (this.val == null) {
            return "null";
        }
        if (this.type().isLong()) {
            return this.val.toString() + "L";
        }
        if (this.type().isFloat()) {
            return this.val.toString() + "F";
        }
        return this.val.toString();
    }

    public int hashCode() {
        return this.val == null ? 0 : this.val.hashCode();
    }

    @Override
    public C_Lit not() {
        HjTypeSystem xts = (HjTypeSystem)this.type().typeSystem();
        assert (this.type().equals(xts.Boolean()));
        return this.equals(xts.TRUE()) ? xts.FALSE() : xts.TRUE();
    }

    @Override
    public C_Lit neg() {
        Type type;
        HjTypeSystem ts = (HjTypeSystem)this.type().typeSystem();
        if (ts.typeBaseEquals(type = this.type(), (Type)ts.Int())) {
            return new C_Lit_c(new Integer(-((Integer)this.val).intValue()), (Type)ts.Int());
        }
        if (ts.typeBaseEquals(type, (Type)ts.Long())) {
            return new C_Lit_c(new Long(-((Long)this.val).longValue()), (Type)ts.Long());
        }
        if (ts.typeBaseEquals(type, (Type)ts.Short())) {
            short s = (Short)this.val;
            return new C_Lit_c(new Short(-s), (Type)ts.Short());
        }
        if (ts.typeBaseEquals(type, (Type)ts.Float())) {
            return new C_Lit_c(new Float(-((Float)this.val).floatValue()), (Type)ts.Float());
        }
        if (ts.typeBaseEquals(type, (Type)ts.Double())) {
            return new C_Lit_c(new Double(-((Double)this.val).doubleValue()), (Type)ts.Double());
        }
        assert (false);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof C_Lit_c)) {
            return false;
        }
        C_Lit_c other = (C_Lit_c)o;
        return this.val == null ? o == null : this.val.equals(other.val);
    }

    @Override
    public Promise intern(C_Var[] vars, int index) {
        return this.intern(vars, index, null);
    }

    @Override
    public Promise intern(C_Var[] vars, int index, Promise last) {
        if (index != vars.length) {
            throw new InternalCompilerError("Cannot extend path " + vars + "index=" + index + " beyond the literal " + this + ".");
        }
        return this;
    }

    @Override
    public Promise lookup(C_Var[] vars, int index) {
        if (index != vars.length) {
            throw new InternalCompilerError("Cannot extend path " + vars + "index=" + index + " beyond the literal " + this + ".");
        }
        return this;
    }

    @Override
    public boolean prefixes(C_Term t) {
        return false;
    }

    @Override
    public Promise lookup(String s) {
        return null;
    }

    @Override
    public Promise lookup() {
        return this;
    }

    @Override
    public boolean forwarded() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean bind(Promise target) throws Failure {
        if (target.term().equals(this)) {
            return true;
        }
        if (target.term() instanceof C_Lit) {
            throw new Failure("Cannot bind literal " + this + " to " + target);
        }
        if (target.term() instanceof C_Var) {
            return target.bind(this);
        }
        if (!this.equals(target)) {
            throw new Failure("Cannot bind literal " + this + " to " + target);
        }
        return false;
    }

    @Override
    public boolean canReach(Promise other) {
        return this.equals(other);
    }

    @Override
    public C_Var term() {
        return this;
    }

    @Override
    public void dump(HashMap<C_Var, C_Var> result, C_Term prefix) {
    }

    @Override
    public void dump(HashMap<C_Var, C_Var> result, C_Term prefix, C_Var newSelf, C_Var newThis) {
    }

    @Override
    public void addIn(String s, Promise orphan) {
        throw new InternalCompilerError("Cannot add an " + s + " child " + orphan + " to a literal, " + this + ".");
    }

    @Override
    public boolean rootVarIsSelf() {
        return false;
    }

    @Override
    public boolean rootVarIsThis() {
        return false;
    }

    @Override
    public boolean isEQV() {
        return false;
    }

    @Override
    public void setTerm(C_Var term) {
    }

    @Override
    public String name() {
        return this.toString();
    }

    @Override
    public C_Var[] vars() {
        return new C_Var[0];
    }

    @Override
    public C_Var rootVar() {
        return this;
    }

    @Override
    public Path path() {
        return null;
    }

    @Override
    public void replaceDescendant(Promise y, Promise x) {
    }

    @Override
    public Promise value() {
        return null;
    }

    @Override
    public HashMap<String, Promise> fields() {
        return null;
    }

    @Override
    public Promise cloneRecursively(HashMap<Promise, Promise> env) {
        return this;
    }

    @Override
    public C_Var substitute(C_Var x, C_Var y) {
        return this;
    }
}

