/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.visit;

import java.util.List;
import polyglot.ast.ClassDecl;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.Import;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.PackageNode;
import polyglot.ast.SourceFile;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.AnnotationNode;
import polyglot.ext.hj.extension.HjExt;
import polyglot.ext.hj.types.HjClassType;
import polyglot.frontend.Job;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class AnnotationChecker
extends ContextVisitor {
    ClassType A;
    ClassType TA;
    ClassType EA;
    ClassType SA;
    ClassType MA;
    ClassType FA;
    ClassType CA;
    ClassType IA;
    ClassType PA;

    public AnnotationChecker(Job job, TypeSystem ts, NodeFactory nf) {
        super(job, ts, nf);
    }

    public Node leaveCall(Node parent, Node old, Node n, NodeVisitor v) throws SemanticException {
        if (!(n.ext() instanceof HjExt)) {
            return n;
        }
        this.init();
        List<AnnotationNode> annotations = ((HjExt)n.ext()).annotations();
        for (AnnotationNode a : annotations) {
            HjClassType at = a.annotationInterface();
            if (n instanceof TypeNode && !at.isSubtype((Type)this.TA)) {
                throw new SemanticException("Annotations on types must implement " + this.TA, n.position());
            }
            if (n instanceof Expr && !at.isSubtype((Type)this.EA)) {
                throw new SemanticException("Annotations on expressions must implement " + this.EA, n.position());
            }
            if (n instanceof Stmt && !at.isSubtype((Type)this.SA)) {
                throw new SemanticException("Annotations on statements must implement " + this.SA, n.position());
            }
            if (n instanceof MethodDecl && !at.isSubtype((Type)this.MA)) {
                throw new SemanticException("Annotations on method declarations must implement " + this.MA, n.position());
            }
            if (n instanceof FieldDecl && !at.isSubtype((Type)this.FA)) {
                throw new SemanticException("Annotations on field declarations must implement " + this.FA, n.position());
            }
            if (n instanceof ClassDecl && !at.isSubtype((Type)this.CA)) {
                throw new SemanticException("Annotations on class declarations must implement " + this.CA, n.position());
            }
            if (n instanceof PackageNode && parent instanceof SourceFile && !at.isSubtype((Type)this.PA)) {
                throw new SemanticException("Annotations on package declarations must implement " + this.PA, n.position());
            }
            if (n instanceof Import && !at.isSubtype((Type)this.IA)) {
                throw new SemanticException("Annotations on imports must implement " + this.IA, n.position());
            }
            if (at.isSubtype((Type)this.A)) continue;
            throw new SemanticException("Annotations must implement " + this.A, n.position());
        }
        return n;
    }

    public void init() throws SemanticException {
        if (this.A != null) {
            return;
        }
        this.TA = (ClassType)this.ts.systemResolver().find("hj.lang.annotations.TypeAnnotation");
        this.EA = (ClassType)this.ts.systemResolver().find("hj.lang.annotations.ExpressionAnnotation");
        this.SA = (ClassType)this.ts.systemResolver().find("hj.lang.annotations.StatementAnnotation");
        this.MA = (ClassType)this.ts.systemResolver().find("hj.lang.annotations.MethodAnnotation");
        this.FA = (ClassType)this.ts.systemResolver().find("hj.lang.annotations.FieldAnnotation");
        this.CA = (ClassType)this.ts.systemResolver().find("hj.lang.annotations.ClassAnnotation");
        this.IA = (ClassType)this.ts.systemResolver().find("hj.lang.annotations.ImportAnnotation");
        this.PA = (ClassType)this.ts.systemResolver().find("hj.lang.annotations.PackageAnnotation");
        this.A = (ClassType)this.ts.systemResolver().find("hj.lang.annotations.Annotation");
    }
}

