/*
 * Decompiled with CFR 0.152.
 */
package CnCParser;

import CnCParser.Ast.AbstractVisitor;
import CnCParser.Ast.Iinstance;
import CnCParser.Ast.Itag_type;
import CnCParser.Ast.StepExecution;
import CnCParser.Ast.StepPrescription;
import CnCParser.Ast.instanceList;
import CnCParser.Ast.item_instance;
import CnCParser.Ast.statementList;
import CnCParser.Ast.step_instance;
import CnCParser.Ast.step_instanceList;
import CnCParser.Ast.tag_definition;
import CnCParser.Ast.tag_instance;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class CncHjGenerator
extends AbstractVisitor {
    private static final String CNC_FILE_EXTENSION = ".cnc";
    Hashtable tag_map = new Hashtable();
    Hashtable tag_steps = new Hashtable();
    Hashtable item_collections = new Hashtable();
    String filename;
    String graphClass;
    Hashtable all_steps = new Hashtable();
    Hashtable all_steps_types = new Hashtable();

    public void unimplementedVisitor(String string) {
    }

    public CncHjGenerator(String string) {
        File file = new File(string);
        this.graphClass = this.filename = file.getName();
        if (this.graphClass.endsWith(CNC_FILE_EXTENSION)) {
            this.graphClass = this.filename.substring(0, this.filename.lastIndexOf(CNC_FILE_EXTENSION));
            this.graphClass = this.graphClass + "Graph";
        }
    }

    public boolean visit(StepPrescription stepPrescription) {
        ArrayList<String> arrayList;
        tag_instance tag_instance2 = stepPrescription.gettag_instance();
        step_instanceList step_instanceList2 = stepPrescription.getstep_instance_list();
        String string = tag_instance2.gettag_definition().getname().toString();
        tag_instance tag_instance3 = (tag_instance)this.tag_map.get(string);
        if (tag_instance3 == null) {
            this.tag_map.put(string, tag_instance2);
        }
        if ((arrayList = (ArrayList<String>)this.tag_steps.get(string)) == null) {
            arrayList = new ArrayList<String>();
        }
        for (int i = 0; i < step_instanceList2.size(); ++i) {
            step_instance step_instance2 = (step_instance)step_instanceList2.getstep_instanceAt(i);
            String string2 = step_instance2.getname().toString();
            arrayList.add(string2);
        }
        this.tag_steps.put(string, arrayList);
        return false;
    }

    public boolean visit(tag_definition tag_definition2) {
        Itag_type itag_type = tag_definition2.gettag_type();
        String string = itag_type != null ? itag_type + "" : "String";
        this.all_steps_types.put(tag_definition2.getname().toString(), string);
        return false;
    }

    public boolean visit(StepExecution stepExecution) {
        if (stepExecution.getstep_instance() instanceof step_instance) {
            item_instance item_instance2;
            String string;
            Iinstance iinstance;
            int n;
            step_instance step_instance2 = (step_instance)stepExecution.getstep_instance();
            instanceList instanceList2 = stepExecution.getinputList();
            instanceList instanceList3 = stepExecution.getoutputList();
            ArrayList<Argument> arrayList = (ArrayList<Argument>)this.all_steps.get(step_instance2.getname().toString());
            if (arrayList == null) {
                arrayList = new ArrayList<Argument>();
            }
            for (n = 0; n < instanceList2.size(); ++n) {
                iinstance = instanceList2.getinstanceAt(n);
                if (iinstance instanceof item_instance) {
                    string = ((item_instance)iinstance).getitem_definition().getname().toString();
                    arrayList.add(new InputArgument(string));
                    item_instance2 = (item_instance)this.item_collections.get(string);
                    if (item_instance2 != null) continue;
                    this.item_collections.put(string, iinstance);
                    continue;
                }
                if (!(iinstance instanceof tag_instance)) continue;
                arrayList.add(new TagArgument(((tag_instance)iinstance).gettag_definition().getname().toString()));
            }
            for (n = 0; n < instanceList3.size(); ++n) {
                iinstance = instanceList3.getinstanceAt(n);
                if (iinstance instanceof item_instance) {
                    string = ((item_instance)iinstance).getitem_definition().getname().toString();
                    arrayList.add(new OutputArgument(string));
                    item_instance2 = (item_instance)this.item_collections.get(string);
                    if (item_instance2 != null) continue;
                    this.item_collections.put(string, iinstance);
                    continue;
                }
                if (!(iinstance instanceof tag_instance)) continue;
                arrayList.add(new TagArgument(((tag_instance)iinstance).gettag_definition().getname().toString()));
            }
            this.all_steps.put(step_instance2.getname().toString(), arrayList);
        }
        return false;
    }

    public void endVisit(statementList statementList2) {
        this.generateGraph();
        this.generateTagCollection();
        this.generateSteps();
    }

    private void generateGraph() {
        try {
            String string;
            PrintStream printStream = new PrintStream(new File(this.graphClass + ".hj"));
            this.printHeader(printStream);
            printStream.println("import java.util.ArrayList;");
            printStream.println();
            printStream.println("public class " + this.graphClass + " extends Graph{");
            printStream.println("   CnCRuntime runtime;");
            Enumeration enumeration = this.tag_map.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                printStream.println("   TagCollection " + string + ";");
            }
            enumeration = this.item_collections.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                printStream.println("   ItemCollection " + string + ";");
            }
            printStream.println();
            printStream.print("   public static " + this.graphClass + " Factory(");
            enumeration = this.all_steps.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                printStream.print("A" + string + " " + string.toLowerCase() + "_");
                if (!enumeration.hasMoreElements()) continue;
                printStream.print(", ");
            }
            printStream.println(") {");
            printStream.println("      " + this.graphClass + " g1 = new " + this.graphClass + "();");
            printStream.println("      ArrayList cl = new ArrayList();");
            enumeration = this.tag_map.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                printStream.print("      g1." + string + " = new " + string + "Collection(g1, ");
                ArrayList arrayList = (ArrayList)this.tag_steps.get(string);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    printStream.print(string2.toLowerCase() + "_");
                    if (!iterator.hasNext()) continue;
                    printStream.print(", ");
                }
                printStream.println(");");
                printStream.println("      cl.add(g1." + string + ");");
            }
            enumeration = this.item_collections.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                printStream.println("      g1." + string + " = new ItemCollectionImplementation(\"" + string + "\");");
            }
            printStream.println("      g1.runtime = new CnCRuntime(cl, g1);");
            printStream.println("      return g1;");
            printStream.println("   }");
            printStream.println("}");
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    private void generateTagCollection() {
        try {
            Enumeration enumeration = this.tag_map.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string22;
                String string3 = (String)enumeration.nextElement();
                String string4 = (String)this.all_steps_types.get(string3);
                tag_instance tag_instance2 = (tag_instance)this.tag_map.get(string3);
                PrintStream printStream = new PrintStream(new File(string3 + "Collection.hj"));
                this.printHeader(printStream);
                printStream.println("class " + string3 + "Collection extends java.lang.Object implements TagCollection {");
                printStream.println("    " + this.graphClass + " g;");
                printStream.println("    String name;");
                printStream.println("    public String name(){return name;}");
                ArrayList arrayList = (ArrayList)this.tag_steps.get(string3);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    printStream.println();
                    string22 = (String)iterator.next();
                    string = string22.toLowerCase();
                    printStream.println("    A" + string22 + " " + string + ";");
                    printStream.println();
                }
                printStream.println("    public void Put(final java.lang.Object tag) {");
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    printStream.println();
                    string22 = (String)iterator.next();
                    string = string22.toLowerCase();
                    printStream.println("        g.runtime.PutTag(tag, this, ");
                    printStream.println("            new Closure () {");
                    printStream.println("                public boolean ready()     { return " + string + ".ready(g, tag); }");
                    printStream.print("                public CnCReturnValue compute() { return " + string + ".compute((point)tag");
                    ArrayList arrayList2 = (ArrayList)this.all_steps.get(string22);
                    for (Argument argument : arrayList2) {
                        printStream.print(", g." + argument.name());
                    }
                    printStream.println("); }");
                    printStream.println("            }");
                    printStream.println("        );");
                }
                printStream.println("    }");
                printStream.println();
                printStream.print("    " + string3 + "Collection(" + this.graphClass + " g_");
                for (String string22 : arrayList) {
                    printStream.print(", A" + string22 + " " + string22.toLowerCase() + "_");
                }
                printStream.println(") {");
                printStream.println("        g = g_;");
                printStream.println("        name = \"" + string3 + "Collection\";");
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string22 = ((String)iterator.next()).toLowerCase();
                    printStream.println("        " + string22 + " = " + string22 + "_;");
                }
                printStream.println("    }");
                printStream.println("}");
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    private void generateSteps() {
        Enumeration enumeration = this.all_steps.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                ArrayList arrayList = (ArrayList)this.all_steps.get(string);
                String string2 = "A" + string;
                PrintStream printStream = new PrintStream(new File(string2 + ".hj"));
                this.printHeader(printStream);
                printStream.println("abstract class " + string2 + " extends Step {");
                String string3 = this.resolveStepTagType(string);
                String string4 = (String)this.all_steps_types.get(string3);
                printStream.print("    abstract CnCReturnValue compute(" + string4 + " tag");
                for (Argument argument : arrayList) {
                    if (argument instanceof InputArgument) {
                        printStream.print(", InputCollection " + argument.name());
                        continue;
                    }
                    if (argument instanceof OutputArgument) {
                        printStream.print(", OutputCollection " + argument.name());
                        continue;
                    }
                    if (!(argument instanceof TagArgument)) continue;
                    printStream.print(", TagCollection " + argument.name());
                }
                printStream.println(");");
                printStream.println("}");
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
            }
        }
    }

    String resolveStepTagType(String string) {
        for (Map.Entry entry : this.tag_steps.entrySet()) {
            ArrayList arrayList = (ArrayList)entry.getValue();
            if (((String)arrayList.get(0)).compareTo(string) != 0) continue;
            return (String)entry.getKey();
        }
        System.out.println("error key " + string + " not found");
        return null;
    }

    void printHeader(PrintStream printStream) {
        printStream.println();
        printStream.println("   // ***** AUTO-GENERATED FILE FROM " + this.filename + ", DO NOT MODIFY!  *****//");
        printStream.println();
        printStream.println("//Standard imports://");
        printStream.println("import CnCHJ.api.*;");
        printStream.println("import CnCHJ.runtime.*;");
        printStream.println();
    }

    private class TagArgument
    extends Argument {
        public TagArgument(String string) {
            super(string);
        }
    }

    private class OutputArgument
    extends Argument {
        public OutputArgument(String string) {
            super(string);
        }
    }

    private class InputArgument
    extends Argument {
        public InputArgument(String string) {
            super(string);
        }
    }

    private class Argument {
        String name;

        public Argument(String string) {
            this.name = string;
        }

        public String name() {
            return this.name;
        }
    }
}

