/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.Type;
import soot.TypeSwitch;
import soot.UnitPrinter;
import soot.util.Switch;

public class ArrayType
extends RefLikeType {
    public final Type baseType;
    public final int numDimensions;

    protected ArrayType(Type baseType, int numDimensions) {
        if (!(baseType instanceof PrimType) && !(baseType instanceof RefType)) {
            throw new RuntimeException("oops");
        }
        if (numDimensions < 1) {
            throw new RuntimeException("attempt to create array with " + numDimensions + " dimensions");
        }
        this.baseType = baseType;
        this.numDimensions = numDimensions;
    }

    public static ArrayType v(Type baseType, int numDimensions) {
        if (numDimensions < 1) {
            throw new RuntimeException("attempt to create array with " + numDimensions + " dimensions");
        }
        Type elementType = numDimensions == 1 ? baseType : ArrayType.v(baseType, numDimensions - 1);
        ArrayType ret = elementType.getArrayType();
        if (ret == null) {
            ret = new ArrayType(baseType, numDimensions);
            elementType.setArrayType(ret);
        }
        return ret;
    }

    public boolean equals(Object t) {
        return t == this;
    }

    public void toString(UnitPrinter up) {
        up.type(this.baseType);
        for (int i = 0; i < this.numDimensions; ++i) {
            up.literal("[]");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.baseType.toString());
        for (int i = 0; i < this.numDimensions; ++i) {
            buffer.append("[]");
        }
        return buffer.toString();
    }

    public int hashCode() {
        return this.baseType.hashCode() + 1127088961 * this.numDimensions;
    }

    public void apply(Switch sw) {
        ((TypeSwitch)sw).caseArrayType(this);
    }

    public Type getArrayElementType() {
        return this.getElementType();
    }

    public Type getElementType() {
        if (this.numDimensions > 1) {
            return ArrayType.v(this.baseType, this.numDimensions - 1);
        }
        return this.baseType;
    }

    public ArrayType makeArrayType() {
        return ArrayType.v(this.baseType, this.numDimensions + 1);
    }
}

