/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.List;
import soot.HjToJimple.HabLocalGenerator;
import soot.HjToJimple.jimple.HjAbstractArrayOper;
import soot.HjToJimple.jimple.HjArrayOper;
import soot.HjToJimple.util.HjValueBox;
import soot.HjToJimple.util.Point;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjArrayAccess
extends HjAbstractArrayOper
implements HjArrayOper {
    protected ValueBox arrayLocalBox;
    protected Point point;

    public HjArrayAccess() {
    }

    public HjArrayAccess(Local arrayLocal, Point point) {
        this.arrayLocalBox = new HjValueBox(arrayLocal);
        this.point = point;
    }

    public Local getArrayRef() {
        return (Local)this.arrayLocalBox.getValue();
    }

    public void setArrayRef(Local arrayLocal) {
        this.arrayLocalBox.setValue(arrayLocal);
    }

    public Point getArrayIndex() {
        return this.point;
    }

    public void setArrayIndex(Point point) {
        this.point = point;
    }

    @Override
    public List getUseBoxes() {
        ArrayList<ValueBox> useBoxes = new ArrayList<ValueBox>();
        List valUseBoxes = this.arrayLocalBox.getValue().getUseBoxes();
        if (valUseBoxes.size() == 0) {
            useBoxes.add(this.arrayLocalBox);
        } else {
            useBoxes.addAll(valUseBoxes);
        }
        useBoxes.addAll(this.point.getUseBoxes());
        return useBoxes;
    }

    @Override
    public List<Stmt> generateStmts(HabLocalGenerator lg) {
        return this.generateStmts(null, lg);
    }

    @Override
    public List<Stmt> generateStmts(Value retValue, HabLocalGenerator lg) {
        Local arrayLocal;
        if (retValue == null) {
            throw new RuntimeException("There must be a return value corresponding to the Hj Array Access");
        }
        ArrayList<Stmt> stmts = new ArrayList<Stmt>();
        Value arrayValue = this.arrayLocalBox.getValue();
        if (arrayValue instanceof Local) {
            arrayLocal = (Local)arrayValue;
        } else {
            arrayLocal = lg.generateLocal("$", arrayValue.getType());
            stmts.add(Jimple.v().newAssignStmt(arrayLocal, arrayValue));
        }
        SootClass arrayClass = ((RefType)arrayLocal.getType()).getSootClass();
        ArrayList<Value> paramList = new ArrayList<Value>();
        ArrayList<Type> typeList = new ArrayList<Type>();
        if (this.point.getPointLocal() != null) {
            paramList.add(this.point.getPointLocal());
            typeList.add(this.point.getPointLocal().getType());
        } else {
            for (Value indexVal : this.point.getIndexList()) {
                paramList.add(indexVal);
                typeList.add(indexVal.getType());
            }
        }
        SootMethod getMethod = arrayClass.getMethodFromCH("get", typeList, retValue.getType());
        VirtualInvokeExpr invokeExpr = Jimple.v().newVirtualInvokeExpr(arrayLocal, getMethod.makeRef(), paramList);
        stmts.add(Jimple.v().newAssignStmt(retValue, invokeExpr));
        return stmts;
    }

    @Override
    public Object clone() {
        return new HjArrayAccess((Local)this.arrayLocalBox.getValue(), this.point);
    }

    @Override
    public String toString() {
        return "HjArrayAccess: " + this.arrayLocalBox.getValue() + "[" + this.point + "]";
    }
}

