/*
 * Decompiled with CFR 0.152.
 */
package soot.HjToJimple.jimple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import polyglot.ast.Binary;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.G;
import soot.HjToJimple.HabLocalGenerator;
import soot.HjToJimple.jimple.ActivityClassBuilder;
import soot.HjToJimple.jimple.AsyncRegionExpr;
import soot.HjToJimple.jimple.AtEachRegionExpr;
import soot.HjToJimple.jimple.ForEachRegionExpr;
import soot.HjToJimple.jimple.ForLoopRegionExpr;
import soot.HjToJimple.jimple.HjRegionStmt;
import soot.HjToJimple.jimple.LoopRegionExpr;
import soot.HjToJimple.jimple.Region;
import soot.HjToJimple.jimple.RegionExit;
import soot.HjToJimple.jimple.RegionStmt;
import soot.HjToJimple.util.Dist;
import soot.HjToJimple.util.LoopDomain;
import soot.HjToJimple.util.Place_c;
import soot.IntType;
import soot.Local;
import soot.PatchingChain;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.ConditionExpr;
import soot.jimple.EqExpr;
import soot.jimple.GtExpr;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.VirtualInvokeExpr;
import soot.options.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjHPIRToMPIRTranslator
extends BodyTransformer {
    public HjHPIRToMPIRTranslator(Singletons.Global g) {
    }

    public static HjHPIRToMPIRTranslator v() {
        return G.v().soot_HjToJimple_jimple_HjHPIRToMPIRTranslator();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map opts) {
        SootMethod method = body.getMethod();
        if (!body.getMethod().isStatic() && body.getThisLocal() == null) {
            throw new Error("H2M this local");
        }
        if (Options.v().hjVerbose()) {
            G.v().out.println("HPIR: " + body);
        }
        this.hjHPIRToMPIRTransform(body, phaseName, opts);
    }

    protected void hjHPIRToMPIRTransform(Body body, String phaseName, Map opts) {
        StmtBody stmtBody = (StmtBody)body;
        PatchingChain<Unit> units = stmtBody.getUnits();
        HashMap<Stmt, ArrayList<Stmt>> rtStmtMap = new HashMap<Stmt, ArrayList<Stmt>>();
        ArrayList<Stmt> removeStmts = new ArrayList<Stmt>();
        Iterator<Stmt> stmtIt = units.iterator();
        while (stmtIt.hasNext()) {
            Stmt stmt = (Stmt)stmtIt.next();
            if (!(stmt instanceof RegionStmt)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (regionExpr instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (regionExpr instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (regionExpr instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(regionExpr instanceof LoopRegionExpr)) continue;
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        }
        for (Stmt stmt : rtStmtMap.keySet()) {
            ArrayList rtStmts = (ArrayList)rtStmtMap.get(stmt);
            for (Stmt rtStmt : rtStmts) {
                body.getUnits().insertAfter(rtStmt, (Unit)stmt);
                stmt = rtStmt;
            }
        }
        Iterator stmtIter = removeStmts.iterator();
        while (stmtIter.hasNext()) {
            body.getUnits().remove(stmtIter.next());
        }
    }

    protected Local generateRegionCall(LoopDomain loopDomain, HabLocalGenerator lg, Local factoryLocal, SootClass hjRegionClass, SootClass hjRegionFactoryClass, SootMethod regionIntMethod, ArrayList<Stmt> stmtList) {
        AssignStmt assignStmt;
        Local regionLocal;
        VirtualInvokeExpr virtualInvoke;
        ArrayList<Local> paramsList = new ArrayList<Local>();
        ArrayList<Type> typesList = new ArrayList<Type>();
        if (loopDomain.hasSubDomains()) {
            Iterator<LoopDomain> domainIter = loopDomain.getSubDomains().iterator();
            while (domainIter.hasNext()) {
                paramsList.add(this.generateRegionCall(domainIter.next(), lg, factoryLocal, hjRegionClass, hjRegionFactoryClass, regionIntMethod, stmtList));
                typesList.add(hjRegionClass.getType());
            }
        } else {
            if (loopDomain.getDomainValue() != null) {
                return (Local)loopDomain.getDomainValue();
            }
            ArrayList<Value> regionParams = new ArrayList<Value>();
            regionParams.add(loopDomain.getInitialValue());
            regionParams.add(loopDomain.getTerminalValue());
            virtualInvoke = Jimple.v().newVirtualInvokeExpr(factoryLocal, regionIntMethod.makeRef(), regionParams);
            regionLocal = lg.generateLocal("$", hjRegionClass.getType());
            assignStmt = Jimple.v().newAssignStmt(regionLocal, virtualInvoke);
            stmtList.add(assignStmt);
            paramsList.add(regionLocal);
            typesList.add(regionLocal.getType());
        }
        SootMethod regionRefMethod = hjRegionFactoryClass.getMethod("region", typesList, hjRegionClass.getType());
        virtualInvoke = Jimple.v().newVirtualInvokeExpr(factoryLocal, regionRefMethod.makeRef(), paramsList);
        regionLocal = lg.generateLocal("$", hjRegionClass.getType());
        assignStmt = Jimple.v().newAssignStmt(regionLocal, virtualInvoke);
        stmtList.add(assignStmt);
        return regionLocal;
    }

    protected void generateRegionIterator(Iterator<Local> localIter, Body body, HabLocalGenerator lg, Local iterLocal, SootClass javaIterClass, ArrayList<Stmt> stmtList) {
        SootClass hjPointClass = Scene.v().getSootClass("hj.lang.point");
        SootClass objectClass = Scene.v().getSootClass("java.lang.Object");
        SootMethod nextMethod = javaIterClass.getMethod("next", new ArrayList(), objectClass.getType());
        InterfaceInvokeExpr interfaceInvoke = Jimple.v().newInterfaceInvokeExpr(iterLocal, nextMethod.makeRef(), new ArrayList());
        Local objectLocal = lg.generateLocal("$", objectClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(objectLocal, interfaceInvoke);
        stmtList.add(assignStmt);
        CastExpr castExpr = Jimple.v().newCastExpr(objectLocal, hjPointClass.getType());
        Local pointLocal = lg.generateLocal("$", castExpr.getCastType());
        AssignStmt castAssign = Jimple.v().newAssignStmt(pointLocal, castExpr);
        stmtList.add(castAssign);
        ArrayList<IntType> typesList = new ArrayList<IntType>();
        typesList.add(IntType.v());
        SootMethod pointGetMethod = hjPointClass.getMethod("get", typesList, IntType.v());
        int dimCount = 0;
        while (localIter.hasNext()) {
            Local domainLocal = localIter.next();
            ArrayList<IntConstant> paramList = new ArrayList<IntConstant>();
            paramList.add(IntConstant.v(dimCount++));
            VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(pointLocal, pointGetMethod.makeRef(), paramList);
            assignStmt = Jimple.v().newAssignStmt(domainLocal, virtualInvoke);
            stmtList.add(assignStmt);
        }
    }

    protected void handleForEachRegion(RegionStmt forEachRegionStmt, Body body, Iterator<Stmt> stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        ForEachRegionExpr forEachRegion = (ForEachRegionExpr)forEachRegionStmt.getRegionExpr();
        ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succStmts = new ArrayList<Stmt>();
        SootClass hjPointClass = Scene.v().getSootClass("hj.lang.point");
        SootClass hjRegionClass = Scene.v().getSootClass("hj.lang.region");
        SootClass hjRegionFactoryClass = Scene.v().getSootClass("hj.lang.region$factory");
        SootClass javaIterClass = Scene.v().getSootClass("java.util.Iterator");
        HabLocalGenerator lg = new HabLocalGenerator(body);
        ArrayList<IntType> regionIntParams = new ArrayList<IntType>();
        regionIntParams.add(IntType.v());
        regionIntParams.add(IntType.v());
        SootMethod regionIntMethod = hjRegionFactoryClass.getMethod("region", regionIntParams, hjRegionClass.getType());
        SootFieldRef sootField = Scene.v().makeFieldRef(hjRegionClass, "factory", hjRegionFactoryClass.getType(), true);
        StaticFieldRef fieldRef = Jimple.v().newStaticFieldRef(sootField);
        Local factoryLocal = lg.generateLocal(hjRegionFactoryClass.getType());
        predStmts.add(Jimple.v().newAssignStmt(factoryLocal, fieldRef));
        Local regionLocal = this.generateRegionCall(forEachRegion.getDomains(), lg, factoryLocal, hjRegionClass, hjRegionFactoryClass, regionIntMethod, predStmts);
        ArrayList iterParams = new ArrayList();
        SootMethod iterMethod = hjRegionClass.getMethod("iterator", iterParams, javaIterClass.getType());
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(regionLocal, iterMethod.makeRef(), new ArrayList());
        Local iterLocal = lg.generateLocal(javaIterClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(iterLocal, virtualInvoke);
        predStmts.add(assignStmt);
        SootMethod hasNextMethod = javaIterClass.getMethod("hasNext", new ArrayList(), BooleanType.v());
        InterfaceInvokeExpr interfaceInvoke = Jimple.v().newInterfaceInvokeExpr(iterLocal, hasNextMethod.makeRef(), new ArrayList());
        Local hasNextLocal = lg.generateLocal(BooleanType.v());
        assignStmt = Jimple.v().newAssignStmt(hasNextLocal, interfaceInvoke);
        predStmts.add(assignStmt);
        AssignStmt loopEntryLabel = assignStmt;
        NopStmt loopExitLabel = Jimple.v().newNopStmt();
        EqExpr condExpr = Jimple.v().newEqExpr(hasNextLocal, IntConstant.v(0));
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, loopExitLabel);
        predStmts.add(ifStmt);
        this.generateRegionIterator(forEachRegion.getLocals().iterator(), body, lg, iterLocal, javaIterClass, predStmts);
        AsyncRegionExpr asyncEntryExpr = Jimple.v().newAsyncRegionExpr();
        RegionExit asyncExitExpr = Jimple.v().newRegionExitExpr(asyncEntryExpr);
        asyncEntryExpr.setExit(asyncExitExpr);
        asyncExitExpr.setEntry(asyncEntryExpr);
        asyncEntryExpr.setPhasers(forEachRegion.getPhasers());
        asyncEntryExpr.setPlaces(forEachRegion.getPlaces());
        RegionStmt asyncEntryStmt = Jimple.v().newRegionStmt(asyncEntryExpr);
        predStmts.add(asyncEntryStmt);
        RegionExit regionExitExpr = forEachRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = stmtIt.next()) instanceof RegionStmt)) continue;
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        RegionStmt asyncExitStmt = Jimple.v().newRegionStmt(asyncExitExpr);
        HjRegionStmt.setConnect(asyncEntryStmt, asyncExitStmt);
        succStmts.add(asyncExitStmt);
        succStmts.add(Jimple.v().newGotoStmt(loopEntryLabel));
        succStmts.add(loopExitLabel);
        rtStmtMap.put(forEachRegionStmt, predStmts);
        rtStmtMap.put(regionExitStmt, succStmts);
        removeStmts.add(forEachRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected Stmt generateRegionRanks(Iterator<Local> localIter, Body body, HabLocalGenerator lg, Local regionLocal, SootClass regionClass, SootMethod rankMethod, SootMethod lowMethod, SootMethod highMethod, int rankCount, ArrayList<Stmt> predStmts, ArrayList<Stmt> succStmts, Stmt loopExitLabel) {
        IfStmt loopEntryLabel = null;
        if (localIter.hasNext()) {
            ArrayList<IntConstant> rankParams = new ArrayList<IntConstant>();
            rankParams.add(IntConstant.v(rankCount++));
            VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(regionLocal, rankMethod.makeRef(), rankParams);
            Local rankLocal = lg.generateLocal(regionClass.getType());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(rankLocal, virtualInvoke);
            predStmts.add(assignStmt);
            virtualInvoke = Jimple.v().newVirtualInvokeExpr(rankLocal, lowMethod.makeRef(), new ArrayList());
            Local loopIterLocal = lg.generateLocal(IntType.v());
            assignStmt = Jimple.v().newAssignStmt(loopIterLocal, virtualInvoke);
            predStmts.add(assignStmt);
            virtualInvoke = Jimple.v().newVirtualInvokeExpr(rankLocal, highMethod.makeRef(), new ArrayList());
            Local termLocal = lg.generateLocal(IntType.v());
            assignStmt = Jimple.v().newAssignStmt(termLocal, virtualInvoke);
            predStmts.add(assignStmt);
            NopStmt newLoopExitLabel = Jimple.v().newNopStmt();
            GtExpr condExpr = Jimple.v().newGtExpr(loopIterLocal, termLocal);
            IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, loopExitLabel);
            predStmts.add(ifStmt);
            loopEntryLabel = ifStmt;
            Local iterLocal = localIter.next();
            assignStmt = Jimple.v().newAssignStmt(iterLocal, loopIterLocal);
            predStmts.add(assignStmt);
            this.generateRegionRanks(localIter, body, lg, regionLocal, regionClass, rankMethod, lowMethod, highMethod, rankCount, predStmts, succStmts, newLoopExitLabel);
            succStmts.add(newLoopExitLabel);
            assignStmt = Jimple.v().newAssignStmt(loopIterLocal, Jimple.v().newAddExpr(loopIterLocal, IntConstant.v(1)));
            succStmts.add(assignStmt);
            succStmts.add(Jimple.v().newGotoStmt(loopEntryLabel));
        }
        return loopEntryLabel;
    }

    protected void handleForLoopRegion(RegionStmt forLoopRegionStmt, Body body, Iterator<Stmt> stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        ForLoopRegionExpr forLoopRegion = (ForLoopRegionExpr)forLoopRegionStmt.getRegionExpr();
        ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succStmts = new ArrayList<Stmt>();
        SootClass hjPointClass = Scene.v().getSootClass("hj.lang.point");
        SootClass hjRegionClass = Scene.v().getSootClass("hj.lang.region");
        SootClass hjRegionFactoryClass = Scene.v().getSootClass("hj.lang.region$factory");
        SootClass javaIterClass = Scene.v().getSootClass("java.util.Iterator");
        HabLocalGenerator lg = new HabLocalGenerator(body);
        ArrayList<IntType> regionIntParams = new ArrayList<IntType>();
        regionIntParams.add(IntType.v());
        regionIntParams.add(IntType.v());
        SootMethod regionIntMethod = hjRegionFactoryClass.getMethod("region", regionIntParams, hjRegionClass.getType());
        SootFieldRef sootField = Scene.v().makeFieldRef(hjRegionClass, "factory", hjRegionFactoryClass.getType(), true);
        StaticFieldRef fieldRef = Jimple.v().newStaticFieldRef(sootField);
        Local factoryLocal = lg.generateLocal(hjRegionFactoryClass.getType());
        predStmts.add(Jimple.v().newAssignStmt(factoryLocal, fieldRef));
        Local regionLocal = this.generateRegionCall(forLoopRegion.getDomains(), lg, factoryLocal, hjRegionClass, hjRegionFactoryClass, regionIntMethod, predStmts);
        SootMethod sizeMethod = hjRegionClass.getMethod("size", new ArrayList(), IntType.v());
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(regionLocal, sizeMethod.makeRef(), new ArrayList());
        Local sizeLocal = lg.generateLocal(IntType.v());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(sizeLocal, virtualInvoke);
        predStmts.add(assignStmt);
        Stmt loopExitLabel = forLoopRegion.getLoopExits().iterator().next();
        Stmt loopContLabel = forLoopRegion.getBackEdges().iterator().next();
        EqExpr condExpr = Jimple.v().newEqExpr(sizeLocal, IntConstant.v(0));
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, loopExitLabel);
        predStmts.add(ifStmt);
        ArrayList<IntType> rankParams = new ArrayList<IntType>();
        rankParams.add(IntType.v());
        SootMethod rankMethod = hjRegionClass.getMethod("rank", rankParams, hjRegionClass.getType());
        SootMethod lowMethod = hjRegionClass.getMethod("low", new ArrayList(), IntType.v());
        SootMethod highMethod = hjRegionClass.getMethod("high", new ArrayList(), IntType.v());
        Stmt loopEntryLabel = this.generateRegionRanks(forLoopRegion.getLocals().iterator(), body, lg, regionLocal, hjRegionClass, rankMethod, lowMethod, highMethod, 0, predStmts, succStmts, loopExitLabel);
        RegionExit regionExitExpr = forLoopRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = stmtIt.next()) instanceof RegionStmt)) continue;
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        rtStmtMap.put(forLoopRegionStmt, predStmts);
        rtStmtMap.put(loopContLabel, succStmts);
        removeStmts.add(loopExitLabel);
        removeStmts.add(loopContLabel);
        removeStmts.add(forLoopRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleAtEachRegion(RegionStmt atEachRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        AtEachRegionExpr atEachRegion = (AtEachRegionExpr)atEachRegionStmt.getRegionExpr();
        ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
        ArrayList<Stmt> succStmts = new ArrayList<Stmt>();
        SootClass hjPointClass = ActivityClassBuilder.v().hjPointClass;
        SootClass hjRegionClass = ActivityClassBuilder.v().hjRegionClass;
        SootClass javaIterClass = ActivityClassBuilder.v().javaIterClass;
        SootClass javaObjectClass = ActivityClassBuilder.v().javaObjectClass;
        SootClass hjLangPlaceClass = ActivityClassBuilder.v().hjLPlaceClass;
        SootClass hjRTPlaceClass = ActivityClassBuilder.v().hjRTPlaceClass;
        HabLocalGenerator lg = new HabLocalGenerator(body);
        Local distLocal = null;
        Dist dist = atEachRegion.getDist();
        if (dist == null) {
            throw new RuntimeException("Can't find the dist object for AtEach loop");
        }
        Value distValue = dist.getDistValue();
        if (!(distValue instanceof Local)) {
            distLocal = lg.generateLocal(Scene.v().getSootClass("hj.lang.dist").getType());
            predStmts.add(Jimple.v().newAssignStmt(distLocal, distValue));
        } else {
            distLocal = (Local)distValue;
        }
        VirtualInvokeExpr virtualInvoke = Jimple.v().newVirtualInvokeExpr(distLocal, ActivityClassBuilder.v().distIterMethod.makeRef(), new ArrayList());
        Local iterLocal = lg.generateLocal(javaIterClass.getType());
        AssignStmt assignStmt = Jimple.v().newAssignStmt(iterLocal, virtualInvoke);
        predStmts.add(assignStmt);
        InterfaceInvokeExpr interfaceInvoke = Jimple.v().newInterfaceInvokeExpr(iterLocal, ActivityClassBuilder.v().iterHasNextMethod.makeRef(), new ArrayList());
        Local hasNextLocal = lg.generateLocal(BooleanType.v());
        assignStmt = Jimple.v().newAssignStmt(hasNextLocal, interfaceInvoke);
        predStmts.add(assignStmt);
        AssignStmt loopEntryLabel = assignStmt;
        NopStmt loopExitLabel = Jimple.v().newNopStmt();
        EqExpr condExpr = Jimple.v().newEqExpr(hasNextLocal, IntConstant.v(0));
        IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, loopExitLabel);
        predStmts.add(ifStmt);
        interfaceInvoke = Jimple.v().newInterfaceInvokeExpr(iterLocal, ActivityClassBuilder.v().iterNextMethod.makeRef(), new ArrayList());
        Local objectLocal = lg.generateLocal(javaObjectClass.getType());
        assignStmt = Jimple.v().newAssignStmt(objectLocal, interfaceInvoke);
        predStmts.add(assignStmt);
        CastExpr castExpr = Jimple.v().newCastExpr(objectLocal, hjPointClass.getType());
        Local pointLocal = lg.generateLocal(castExpr.getCastType());
        AssignStmt castAssign = Jimple.v().newAssignStmt(pointLocal, castExpr);
        predStmts.add(castAssign);
        ArrayList<IntType> typesList = new ArrayList<IntType>();
        typesList.add(IntType.v());
        SootMethod pointGetMethod = hjPointClass.getMethod("get", typesList, IntType.v());
        Iterator<Local> localIter = atEachRegion.getLocals().iterator();
        int indexCounter = 0;
        while (localIter.hasNext()) {
            Local indexLocal = localIter.next();
            ArrayList<IntConstant> paramList = new ArrayList<IntConstant>();
            paramList.add(IntConstant.v(indexCounter++));
            assignStmt = Jimple.v().newAssignStmt(indexLocal, Jimple.v().newVirtualInvokeExpr(pointLocal, pointGetMethod.makeRef(), paramList));
            predStmts.add(assignStmt);
        }
        ArrayList<Local> paramList = new ArrayList<Local>();
        paramList.add(pointLocal);
        virtualInvoke = Jimple.v().newVirtualInvokeExpr(distLocal, ActivityClassBuilder.v().distGetMethod.makeRef(), paramList);
        Local langPlaceLocal = lg.generateLocal(hjLangPlaceClass.getType());
        assignStmt = Jimple.v().newAssignStmt(langPlaceLocal, virtualInvoke);
        predStmts.add(assignStmt);
        castExpr = Jimple.v().newCastExpr(langPlaceLocal, hjRTPlaceClass.getType());
        Local placeLocal = lg.generateLocal(castExpr.getCastType());
        castAssign = Jimple.v().newAssignStmt(placeLocal, castExpr);
        predStmts.add(castAssign);
        AsyncRegionExpr asyncEntryExpr = Jimple.v().newAsyncRegionExpr();
        RegionExit asyncExitExpr = Jimple.v().newRegionExitExpr(asyncEntryExpr);
        asyncEntryExpr.setExit(asyncExitExpr);
        asyncExitExpr.setEntry(asyncEntryExpr);
        asyncEntryExpr.setPhasers(atEachRegion.getPhasers());
        asyncEntryExpr.addPlace(new Place_c(placeLocal));
        RegionStmt asyncEntryStmt = Jimple.v().newRegionStmt(asyncEntryExpr);
        predStmts.add(asyncEntryStmt);
        RegionExit regionExitExpr = atEachRegion.getExit();
        Stmt regionExitStmt = null;
        Stmt stmt = null;
        do {
            if (!((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt)) continue;
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        } while (!(stmt instanceof RegionStmt) || ((RegionStmt)stmt).getRegionExpr() != regionExitExpr);
        regionExitStmt = stmt;
        RegionStmt asyncExitStmt = Jimple.v().newRegionStmt(asyncExitExpr);
        HjRegionStmt.setConnect(asyncEntryStmt, asyncExitStmt);
        succStmts.add(asyncExitStmt);
        succStmts.add(Jimple.v().newGotoStmt(loopEntryLabel));
        succStmts.add(loopExitLabel);
        rtStmtMap.put(atEachRegionStmt, predStmts);
        rtStmtMap.put(regionExitStmt, succStmts);
        removeStmts.add(atEachRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleLoopRegion(RegionStmt loopRegionStmt, Body body, Iterator stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        LoopRegionExpr loopRegion = (LoopRegionExpr)loopRegionStmt.getRegionExpr();
        Stmt regionExitStmt = loopRegionStmt.getConnect();
        if (Options.v().hjVerbose()) {
            G.v().out.println("Handle Loop Region 1: " + body.getMethod());
        }
        if (loopRegion.isLabeled()) {
            AssignStmt assignStmt;
            ConditionExpr condExpr;
            Local tempLocal;
            Stmt loopContLabel;
            if (Options.v().hjVerbose()) {
                G.v().out.println("Handle Loop Regin: " + body.getMethod());
            }
            ArrayList<Stmt> predStmts = new ArrayList<Stmt>();
            ArrayList<Stmt> succStmts = new ArrayList<Stmt>();
            HabLocalGenerator lg = new HabLocalGenerator(body);
            Stmt loopExitLabel = loopRegion.getLoopExits().iterator().next();
            if (loopExitLabel == (loopContLabel = loopRegion.getBackEdges().iterator().next())) {
                loopExitLabel = (Stmt)body.getUnits().getSuccOf(loopContLabel);
            }
            LoopDomain domain = loopRegion.getDomains();
            Local iterLocal = loopRegion.getLocals().iterator().next();
            Value initVal = domain.getInitialValue();
            Value termVal = domain.getTerminalValue();
            Value strideVal = domain.getStrideValue();
            if (initVal instanceof Local) {
                tempLocal = lg.generateLocal(initVal.getType());
                predStmts.add(Jimple.v().newAssignStmt(tempLocal, initVal));
                initVal = tempLocal;
            }
            if (termVal instanceof Local) {
                tempLocal = lg.generateLocal(termVal.getType());
                predStmts.add(Jimple.v().newAssignStmt(tempLocal, termVal));
                termVal = tempLocal;
            }
            if (strideVal instanceof Local) {
                tempLocal = lg.generateLocal(strideVal.getType());
                predStmts.add(Jimple.v().newAssignStmt(tempLocal, strideVal));
                strideVal = tempLocal;
            }
            predStmts.add(Jimple.v().newAssignStmt(iterLocal, initVal));
            if (domain.getDomainOper() == Binary.GT) {
                condExpr = Jimple.v().newLeExpr(iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.LT) {
                condExpr = Jimple.v().newGeExpr(iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.EQ) {
                condExpr = Jimple.v().newNeExpr(iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.LE) {
                condExpr = Jimple.v().newGtExpr(iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.GE) {
                condExpr = Jimple.v().newLtExpr(iterLocal, termVal);
            } else if (domain.getDomainOper() == Binary.NE) {
                condExpr = Jimple.v().newEqExpr(iterLocal, termVal);
            } else {
                throw new RuntimeException("Unsupport loop bound operation: " + domain.getDomainOper());
            }
            IfStmt ifStmt = Jimple.v().newIfStmt((Value)condExpr, loopExitLabel);
            predStmts.add(ifStmt);
            IfStmt loopEntryLabel = ifStmt;
            Stmt stmt = null;
            do {
                if (!((stmt = (Stmt)stmtIt.next()) instanceof RegionStmt)) continue;
                if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                    this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                    continue;
                }
                if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                    this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                    continue;
                }
                if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                    this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                    continue;
                }
                if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
                Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
                if (((LoopRegionExpr)regionExpr).isLabeled()) {
                    this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                    continue;
                }
                this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
            } while (stmt != regionExitStmt);
            if (domain.getStrideOper() == Binary.ADD) {
                assignStmt = Jimple.v().newAssignStmt(iterLocal, Jimple.v().newAddExpr(iterLocal, strideVal));
            } else if (domain.getStrideOper() == Binary.SUB) {
                assignStmt = Jimple.v().newAssignStmt(iterLocal, Jimple.v().newSubExpr(iterLocal, strideVal));
            } else {
                throw new RuntimeException("Unsupported loop iteration operation: " + domain.getStrideOper());
            }
            succStmts.add(assignStmt);
            succStmts.add(Jimple.v().newGotoStmt(loopEntryLabel));
            rtStmtMap.put(loopRegionStmt, predStmts);
            rtStmtMap.put(loopContLabel, succStmts);
            removeStmts.add(loopContLabel);
            removeStmts.add(loopExitLabel);
        }
        removeStmts.add(loopRegionStmt);
        removeStmts.add(regionExitStmt);
    }

    protected void handleIrregularLoopRegion(RegionStmt loopRegionStmt, Body body, Iterator<Stmt> stmtIt, HashMap<Stmt, ArrayList<Stmt>> rtStmtMap, ArrayList<Stmt> removeStmts) {
        removeStmts.add(loopRegionStmt);
        RegionStmt regionExitStmt = (RegionStmt)loopRegionStmt.getConnect();
        Stmt stmt = null;
        do {
            if (!((stmt = stmtIt.next()) instanceof RegionStmt)) continue;
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForEachRegionExpr) {
                this.handleForEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof ForLoopRegionExpr) {
                this.handleForLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (((RegionStmt)stmt).getRegionExpr() instanceof AtEachRegionExpr) {
                this.handleAtEachRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            if (!(((RegionStmt)stmt).getRegionExpr() instanceof LoopRegionExpr)) continue;
            Region regionExpr = ((RegionStmt)stmt).getRegionExpr();
            if (((LoopRegionExpr)regionExpr).isLabeled()) {
                this.handleLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
                continue;
            }
            this.handleIrregularLoopRegion((RegionStmt)stmt, body, stmtIt, rtStmtMap, removeStmts);
        } while (stmt != regionExitStmt);
        if (!(regionExitStmt.getRegionExpr() instanceof RegionExit)) {
            throw new Error("Can not find the exit of loop region");
        }
        removeStmts.add(regionExitStmt);
    }
}

